<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Adm_reimburse extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('pengaturan/admin/Adm_reimburse_m');
    }

    public function index()
    {
        $data['judul']   = $this->lang->line('menu_admin_reimbursement');
        $data['aktif']   = 'p_admin';
        $this->load->view('pengaturan/admin/adm_reimburse/home', $data, false);
    }

    public function list_data(){
		$list = $this->Adm_reimburse_m->get_datatables();
		$data = array();
		$no   = $_GET['start'];

		$cabang_arr = $this->Adm_reimburse_m->getCabang();
		foreach ($list as $field) {
			$no++;

			$id_cabang = $field->id_cabang;
			if($id_cabang  == "all"){
				$cabang = $this->lang->line('semua_cabang');
			}else{
				$id_cabang_arr = explode(",",$id_cabang);

				$cabang = "";
				foreach($id_cabang_arr as $row){
					$cabang .= "<h6 class='badge badge-primary'>".$cabang_arr[$row]['nm_cabang']."</h6>";
					$cabang .=" ";
				}
			}

			$row = array();
			$row[] = $no;
			$row[] = $field->nm_karyawan."<br><b>".$field->nik."</b>";
			$row[] = $cabang;

            if(in_array($this->level_user, array("1"))) {
                $btn_edit  = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id) . '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';
                $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id) . '" class="btn_delete fa fa-trash" onclick="hapus_form(this)"></i></a>';
                $row[]     = $btn_edit. '&nbsp'. $btn_hapus;
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Adm_reimburse_m->count_all(),
							"recordsFiltered" => $this->Adm_reimburse_m->count_filtered(),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('pengaturan/admin/adm_reimburse/form');
		}else{
			$data['data'] 		= $this->Adm_reimburse_m->getDataById($id);
			$data['cabang_arr'] = $this->Adm_reimburse_m->getCabang();
			$this->load->view('pengaturan/admin/adm_reimburse/form',$data);
		}

	}

	public function form_delete($id=null){
		$data['data'] 		= $this->Adm_reimburse_m->getDataById($id);
		$data['cabang_arr'] = $this->Adm_reimburse_m->getCabang();
		$this->load->view('pengaturan/admin/adm_reimburse/form_delete',$data);
	}

	public function save(){
		$id = $this->input->post('id');

		$data = array('id_karyawan'		=>$this->input->post('id_karyawan'),
					'id_cabang'			=>empty($this->input->post('id_cabang'))?"all":$this->input->post('id_cabang'),
					'id_company' 		=>$this->id_company);

		$this->Adm_reimburse_m->save($data,$id);
	}

	public function delete(){
		$id = $this->input->post("id");
		$this->Adm_reimburse_m->delete($id);
	}
}