<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Detail extends MY_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->model('kpi/user/team/detail_m');
        $this->load->helper(['generateid', 'kpi/kpi', 'response', 'kpi/response']);
    }

    public function index($id)
    {
        $this->load->helper('kpi/kpi');

        $data['data']            = detailData($id);
        $this->detail_m->insertPrevKpi($data['data']);
        
        $periode                 = periodeTarget($data['data']['tahun'], $data['data']['bulan']);
        $data['validasiPeriode'] = validasiPeriodeInput($periode);
        $this->load->view('kpi/user/team/detail/home', $data);
    }

    public function list_data() {
		$list     = $this->detail_m->get_datatables();
		$idAtasan = $this->detail_m->getDataTrx()->row()->id_atasan;

        $data       = array();
        $namaObject = '';
		foreach ($list as $field) {
			$row   = array();
			
            $row[]      = $field->nm_object == $namaObject ? '' : $field->nm_object;
            $namaObject = $field->nm_object != $namaObject ? $field->nm_object : $namaObject;

			$row[] = $field->nm_aspek_kinerja;
			$row[] = $field->target;
			$row[] = $field->bobot."%";
			$row[] = $field->poin_1;
			$row[] = $field->poin_2;
			$row[] = $field->poin_3;
			$row[] = $field->poin_4;
			$row[] = $field->poin_5;
			$row[] = $this->aksi($idAtasan, $field->id_pi_trx);

			$data[] = $row;
		}

		$output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->detail_m->count_all(),
            "recordsFiltered" => $this->detail_m->count_filtered(),
            "data"            => $data,
            "statusAksi"      => $this->statusAksi($idAtasan)
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    public function button($tahun, $bulan, $karyawan, $jenis) 
    {
        $data['periodeTarget'] = periodeTarget($tahun, $bulan);
        $data['status']        = $this->detail_m->getDataTrx($tahun, $bulan, $karyawan)->row()->status;
        $this->load->view('kpi/user/team/detail/button/'.$jenis, $data);
    }

    private function statusAksi($idAtasan) 
    {
        $periodeTarget = periodeTarget();
        $status        = $this->detail_m->getDataTrx()->row()->status;
        $idAtasanApv = $this->detail_m->getIdAtasan();
        // jika periode input, yang melihat atasan, dan status draf atau periode input, yang melihat atasan, dan belum diinput
        if($periodeTarget['isPeriodeInput'] == true and (($this->id_karyawan == $idAtasan and $status == '5') or ($status == null and $this->id_karyawan = $idAtasanApv))) {
            return true;
        } else {
            return false;
        }
    }

    private function aksi($idAtasan, $id) 
    {
        if($idAtasan == $this->id_karyawan) {
            return "<a href='#' id='".md5($id)."' class='btn_edit text-warning'><i class='fa fa-pencil-square-o'></i></a>&nbsp;
                    <a href='#' id='".md5($id)."' class='btn_delete text-danger'><i class='fa fa-trash'></i></a>";
        } else {
            return '';
        }
    }

    public function delete() {
        $this->db->where('md5(id_pi_trx)', htmlentities($this->input->post('id')));
        __response_delete($this->db->delete('kpi_aspek_kinerja_trx'));
    }

    public function form_publish() {
        $this->load->view('kpi/user/team/detail/form_publish');
    }

    public function publish() 
    {
        $this->load->model(['kpi/notif_m', 'karyawan_m']);
        $this->load->helper('kpi/notif');

        $nama_lengkap = $this->karyawan_m->getDataById(md5(htmlentities($this->input->post('karyawan'))))->nama_lengkap;
        $this->db->trans_start();
        $this->db->set('status', '6');
        $this->db->set('tgl_update', date('Y-m-d H:i:s'));
        $this->db->set('user_update', "$this->nik_karyawan - $this->nm_karyawan");
        $this->db->where('id_karyawan', htmlentities($this->input->post('karyawan')));
        $this->db->where('tahun', htmlentities($this->input->post('tahun')));
        $this->db->where('bulan', htmlentities($this->input->post('bulan')));
        $this->db->update('kpi_trx');

        $this->notif_m->insertNotifPublishTarget($nama_lengkap);
        $this->db->trans_complete();
        $status = $this->db->trans_status();
        if($status) {
            publishTarget();
        }
        __response_publish($status);
    }
    
    public function form($id = null) {
        if($id == null) {
            $this->load->view('kpi/user/team/detail/form');
        } else {
            $data['data'] = $this->detail_m->getDataPerformanceById($id);
            $this->load->view('kpi/user/team/detail/form', $data);
        }
    }

    public function save()
    {
        $data = $this->detail_m->getDataTrx();
        $id   = htmlentities($this->input->post('id'));

        $this->db->trans_start();
        $dataPerformanceIndikator = $this->detail_m->dataPerformanceIndikator($id);
        if($id == '') {
            $this->db->insert('kpi_aspek_kinerja_trx', $dataPerformanceIndikator);
            if($data->num_rows() == 0) {
                $dataTrx = $this->detail_m->dataTrx();
                $this->db->insert('kpi_trx', $dataTrx);
            }
            $this->db->trans_complete();
            __response_save($this->db->trans_status());
        } else {
            $this->db->where('md5(id_pi_trx)', $id);
            $this->db->update('kpi_aspek_kinerja_trx', $dataPerformanceIndikator);
            $this->db->trans_complete();
            __response_update($this->db->trans_status());
        }
    }
}