<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pengalaman_kerja_pengajuan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan/pengalaman_kerja_pengajuan_m', 'model');
        $this->load->model('notif_kepegawaian_m', 'notif');
        $this->load->model('pengalaman_kerja_m');
        $this->load->helper('approval');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'pengalaman_pengajuan';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan_md5 = null)
    {
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['tab_aktif']       = 'pengajuan';
        $data['tab']             = $this->load->view('karyawan/pengalaman_kerja/tab', $data, true);
        $this->load->view('karyawan/pengalaman_kerja/pengajuan/home', $data);
    }

    public function list_data($id_karyawan = null)
    {
        $list = $this->model->get_datatables($id_karyawan);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = keterangan_action($this->lang->line('pengalaman_kerja'), $field->action);
            $row[] = $field->nama_perusahaan;
            $row[] = $field->jenis_perusahaan;
            $row[] = $field->jabatan;
            $row[] = pengajuan_badge($field->status_pengajuan, $field->ket_revisi);
            $row[] = $this->button($field->status_pengajuan, md5($field->id_riwayat_pekerjaan));

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_POST['draw'],
            "recordsTotal"    => $this->model->count_all($id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    function button($status, $id)
    {
        $btn_approve = '<button class="btn btn-sm btn-primary" title="approve" onclick="form_approve(\'' . $id . '\')"><i class="fa fa-check"></i></button>';
        $btn_revisi  = '<button class="btn btn-sm btn-secondary" title="' . strtolower($this->lang->line('revisi')) . '" onclick="form_revisi(\'' . $id . '\')"><i class="fa fa-undo"></i></button>';
        $btn_info    = '<button class="btn btn-sm btn-info" title="info" onclick="form_info(\'' . $id . '\')"><i class="fa fa-info"></i></button>';
        $btn_delete  = '<button class="btn btn-sm btn-danger" title="delete" onclick="form_hapus(\'' . $id . '\')"><i class="fa fa-trash"></i></button>';
        if ($status == '1') {
            return $btn_info . '&nbsp;' . $btn_approve . '&nbsp;' . $btn_revisi;
        } elseif ($status == '3' or $status == '2') {
            return $btn_info;
        } elseif ($status == '4') {
            return $btn_info . '&nbsp;' . $btn_delete;
        }
    }

    function form($jenis, $id)
    {
        $data['id'] = $id;
        if ($jenis == 'revisi') {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_revisi', $data);
        } elseif ($jenis == 'info') {
            $data['data']            = $this->model->getDataById($id);
            $data['data_sebelumnya'] = $this->pengalaman_kerja_m->getDataById($id);
            $this->load->view('karyawan/pengalaman_kerja/pengajuan/form_detail', $data);
        } elseif ($jenis == 'approve') {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_approve', $data);
        } elseif ($jenis == 'hapus') {
            $this->load->view('karyawan/riwayat_pendidikan/pengajuan/form_hapus', $data);
        }
    }

    function revisi()
    {
        $id             = $this->input->get('id');
        $keterangan     = $this->input->get('keterangan');
        $approve        = $this->model->approve($id, '3', $keterangan);
        $data_pengajuan = $this->model->getDataById($id);
        $cek_pengalaman = $this->model->cek_pengalaman($id);
        if ($approve) {
            notif_approval('detail_data_pengalaman_kerja', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('pengalaman_kerja'), $data_pengajuan->action)), 'Revisi ' . $keterangan, $data_pengajuan->id_riwayat_pekerjaan);
            notif_kepegawaian($data_pengajuan->id_karyawan, 'pengalaman_kerja', $data_pengajuan->id_riwayat_pekerjaan, jenis_revisi($cek_pengalaman), 'revisi');
            $this->logger->create_log('pengalaman_pengajuan', 'revisi', $this->db->last_query());
            $this->notif->update_flag_baca('pengalaman_kerja', $data_pengajuan->id_karyawan, $data_pengajuan->id_riwayat_pekerjaan);
        }
        __response_revisi($approve);
    }

    function approve()
    {
        $id = $this->input->get('id');
        $approve = $this->model->approve($id, '2');
        if ($approve) {
            $this->logger->create_log('pengalaman_pengajuan', 'approve', $this->db->last_query());
            $cek_id = $this->model->cek_id($id);
            $data_pengajuan = $this->model->getDataById($id);
            if ($cek_id == 0) {
                //jika tidak ada id maka insert data
                $folder_master = $this->move_file_to_master('file', $id);
                $insert_master = $this->model->insert_master($id, $folder_master);
                if ($insert_master) {
                    $this->model->insert_history($id, $folder_master);
                    $id_history = $this->db->insert_id();
                    notif_approval('detail_data_pengalaman_kerja', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('pengalaman_kerja'), $data_pengajuan->action)), 'Disetujui', $id_history);
                    notif_kepegawaian($data_pengajuan->id_karyawan, 'pengalaman_kerja', $id_history, 'tambah', 'setuju');
                    $this->logger->create_log('pengalaman_pengajuan', 'approve insert data pengalaman', $this->db->last_query());
                    $this->notif->update_flag_baca('pengalaman_kerja', $data_pengajuan->id_karyawan, $data_pengajuan->id_riwayat_pekerjaan);
                }
            } else {
                //sebaliknya maka update
                $folder_history = $this->move_file_to_history('file', $id);
                $insert_history = $this->model->insert_history($id, $folder_history);
                if ($insert_history) {
                    $id_history = $this->db->insert_id();
                    $this->logger->create_log('pengalaman_pengajuan', 'approve insert histori', $this->db->last_query());
                    $this->model->update_path_foto_history($id, $folder_history);
                    $folder_master = $this->move_file_to_master('file', $id);
                    $update_data   = $this->model->update_data($id, $folder_master);
                    if ($update_data) {
                        notif_approval('detail_data_pengalaman_kerja', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('pengalaman_kerja'), $data_pengajuan->action)), 'Disetujui', $id_history);
                        notif_kepegawaian($data_pengajuan->id_karyawan, 'pengalaman_kerja', $id_history, 'update', 'setuju');
                        $this->logger->create_log('pengalaman_pengajuan', 'approve update data pengalaman', $this->db->last_query());
                        $this->notif->update_flag_baca('pengalaman_kerja', $data_pengajuan->id_karyawan, $data_pengajuan->id_riwayat_pekerjaan);
                    }
                }
            }
            $this->model->delete($id);
        }

        __response_approve($approve);
    }

    function hapus()
    {
        $id             = $this->input->get('id');
        $approve        = $this->model->approve($id, '2');
        $data_pengajuan = $this->model->getDataById($id);
        if ($approve) {
            $this->logger->create_log('pengalaman_pengajuan', 'hapus', $this->db->last_query());
            $folder_history = $this->move_file_to_history_hapus('file', $id);
            $insert_history = $this->model->insert_history($id, $folder_history);
            $id_history     = $this->db->insert_id();
            notif_approval('detail_data_pengalaman_kerja', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('pengalaman_kerja'), $data_pengajuan->action)), $this->lang->line('disetujui'), $id_history);
            notif_kepegawaian($data_pengajuan->id_karyawan, 'pengalaman_kerja', $id_history, 'hapus', 'setuju');
            $this->model->update_path_foto_history($id, $folder_history);
            $hapus_data = $this->model->hapus_data($id);
            if ($hapus_data) {
                $this->logger->create_log('pengalaman_pengajuan', 'hapus data pengalaman', $this->db->last_query());
                $this->notif->update_flag_baca('pengalaman_kerja', $data_pengajuan->id_karyawan, $data_pengajuan->id_riwayat_pekerjaan);
            }
            $this->model->delete($id);
        }

        __response_delete($approve);
    }

    function move_file_to_history_hapus($jenis, $id)
    {
        //memindahkan file master ke history
        $id_company = $this->session->userdata('id_company');
        $data_temp  = $this->pengalaman_kerja_m->getDataById($id);
        if ($data_temp->$jenis == '') {
            return '';
        } else {
            //data di master
            $directory      = FCPATH . $this->config->item('base_upload');
            $file_name_temp = pathinfo($data_temp->$jenis);
            $old            = $directory . $data_temp->$jenis;
            $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/pengalaman-pekerjaan/history');
            $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/pengalaman-pekerjaan/history/' . $file_name_temp['basename'];
            $new      = $directory . $new_temp;
            rename($old, $new);
            return $new_temp;
        }
    }

    function move_file_to_history($jenis, $id)
    {
        $id_company = $this->session->userdata('id_company');
        $data_temp  = $this->pengalaman_kerja_m->getDataById($id);
        if ($data_temp->$jenis == '') {
            return '';
        } else {
            //data di master
            $data_pengajuan = $this->model->getDataById($id);
            //data di pengajuan
            if ($data_temp->$jenis == $data_pengajuan->$jenis) {
                //jika nama di pengajuan dan di master sama (kondisi untuk edit foto saja)
                $new_temp = $data_temp->$jenis;
            } else {
                $directory      = FCPATH . $this->config->item('base_upload');
                $file_name_temp = pathinfo($data_temp->$jenis);
                $old            = $directory . $data_temp->$jenis;
                $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/pengalaman-pekerjaan/history');
                $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/pengalaman-pekerjaan/history/' . $file_name_temp['basename'];
                $new      = $directory . $new_temp;
                rename($old, $new);
            }
            return $new_temp;
        }
    }

    function create_directory($dir)
    {
        if (!file_exists($dir) && !is_dir($dir)) {
            mkdir($dir, 0777, true);
        }
    }

    function move_file_to_master($jenis, $id)
    {
        $id_company = $this->session->userdata('id_company');
        $data_temp  = $this->model->getDataById($id);
        //data pengajuan
        if ($data_temp->$jenis == '') {
            return '';
        } else {
            $data_master = $this->pengalaman_kerja_m->getDataById($id);
            //data master
            if ($data_master->$jenis == $data_temp->$jenis) {
                $new_temp = $data_temp->$jenis;
            } else {
                $directory      = FCPATH . $this->config->item('base_upload');
                $file_name_temp = pathinfo($data_temp->$jenis);
                $old            = $directory . $data_temp->$jenis;
                $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/pengalaman-pekerjaan');
                $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/pengalaman-pekerjaan/' . $file_name_temp['basename'];
                $new      = $directory . $new_temp;
                rename($old, $new);
            }
            return $new_temp;
        }
    }
}
