<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Data_akun extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Data_akun_m');
    }

    public function index($id_karyawan = null){
		$data['id_karyawan'] = $id_karyawan;
		$this->load->view('karyawan/data_akun/home', $data);
	}

	public function list_data($id_karyawan = null){
		$data['id'] = $id_karyawan;
		$data['data_user'] = $this->Data_akun_m->getDataByIdKaryawan($id_karyawan);
		$data['data_lokasi'] = $this->Data_akun_m->getDataLokasi($id_karyawan);
		$this->load->view('karyawan/data_akun/list_data', $data);
	}

	public function form($id_karyawan =null, $id_user = null){
		if($id_user != null){
			$data['data_user'] = $this->Data_akun_m->getDataByIdUser($id_user);
			$data['data_lokasi'] = $this->Data_akun_m->getDataLokasi($id_karyawan);
		}
		$this->load->view('karyawan/data_akun/form/home', $data);
	}

	public function form_kamera() {
		$this->load->view('karyawan/data_akun/form/kamera');
	}

	public function form_reset() {
		$this->load->view('karyawan/data_akun/form/reset');
	}

	public function save(){
		$id_karyawan = $this->input->post('id_karyawan');
		$id_user = $this->input->post('id_user');
		$password_baru = $this->input->post('password_baru');
		$lock_lokasi = $this->input->post('lock_lokasi');
		$lock_device = $this->input->post('lock_device');
		$lock_facerecognition = $this->input->post('lock_facerecognition');
		if($lock_device == "0"){
			$data_user['device_id'] = '';
		}

		if($lock_facerecognition == "1"){
			$data_user['kamera'] = "2";
		}

		$data_user['username'] 				=  $this->input->post('username');
		$data_user['lock_device'] 			=  $lock_device;
		$data_user['lock_facerecognition'] 	=  $lock_facerecognition;

		if($password_baru != "") {
			$encrypt_password = sha1(sha1(md5($password_baru)));
			$data_user['password'] = $encrypt_password;
		}

		if($lock_lokasi == '1'){
			$id_lokasi = $this->input->post('id_lokasi');
		}else{
			$id_lokasi = '';
		}

		$data_lokasi = array('lock_lokasi'	=>$lock_lokasi,
							'id_lokasi'		=>$id_lokasi);

		$this->Data_akun_m->save($data_user, $data_lokasi, $id_karyawan, $id_user);
	}


	public function reset_deviceid(){
		$id_user = $this->input->post('id_user');
		$data = array('device_id' => "");

		$this->Data_akun_m->reset_deviceid($data, $id_user);
	}

	public function reset_facerecognition(){
		$id_user = $this->input->post('id_user');
		$data = array("matrix_facerecognition" => "",
					"foto_facerecognition" => "");

		$this->Data_akun_m->reset_facerecognition($data, $id_user);
	}

	public function save_camera(){
		$id_user = $this->input->post('id_user');
		$kamera = $this->input->post('id_camera');

		if($kamera == "0"){
			$data = array("kamera" => $kamera,
						"lock_facerecognition" => "0",
						"matrix_facerecognition" => "",
						"foto_facerecognition" => "");
		}else{
			$data = array("kamera" => $kamera);
		}

		$this->Data_akun_m->save_camera($data, $id_user);
	}
}
