<style>
    .icon_target_realisasi {
        border-radius: 10px;
        box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);
        padding: 7px;
        flex: 0 0 auto;
        height: 45px;
        width: 45px;
    }
</style>

<script type="text/javascript">
    $(function() {
        // 1. Dropdown Bulan
        $(".kolom_filter #bulan").inputmask({
            'alias': 'datetime',
            'inputFormat': 'mm-yyyy'
        });
        $(".kolom_filter #bulan").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
        });

        // 2. Dropdown Group
        $(".kolom_filter #id_group_m").select2({
            placeholder: "Semua Group/Area",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.master.dropdown.group.area") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });        

        // 3. Button Filter/Cari
        $(".kolom_filter #btn_cari").on("click", function() {
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function() {
                loading.stop();
            });
        });

        // 4. List Datatable
        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.master.target.personil.list.data') ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                    d.bulan      = $(".kolom_filter #bulan").val() ? $('.kolom_filter #bulan').val() : "00-0000";
                    d.id_group_m = $(".kolom_filter #id_group_m").val() ? $('.kolom_filter #id_group_m').val() : "all";
                },
                "complete": function(data) {
                    var result = data.responseJSON;
                    $('.kolom_filter #total_target_bulanan').html(result.target_bulanan);
                    $('.kolom_filter #total_target_personil').html(result.total_target_personil);
                    $('.kolom_filter #selisih').html(result.selisih);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({'text-align': 'center', 'width': '10px'});
                $('td:eq(1)', nRow).css({'text-align': 'left'});
                $('td:eq(2)', nRow).css({'text-align': 'left', 'width': '250px'});
                $('td:eq(3)', nRow).css({'text-align': 'right', 'width': '250px'});
                $('td:eq(-1)', nRow).css({'text-align': 'center', 'width': '50px'});
            }
        });
    });
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color"><?= $this->lang->line('target_personil') ?></h5>
    </div>
</div>

<div class="kolom_filter mt-1">
    <div class="row">
        <div class="col-md-5">
            <div class="form-group row" style="font-size: 13px !important;">
                <div class="col-md-5">
                    <label class="align-self-center"><?= strtoupper($this->lang->line('bulan')) ?></label>
                    <input type="text" id="bulan" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('m-Y') ?>">
                </div>
                <?php if($this->fungsi->cek_adm_satu_grup() == true) : ?>
                    <div class="col-md-3 align-self-end">
                        <button type="button" id="btn_cari" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">FILTER</button>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
                <div class="form-group row" style="font-size: 13px !important;">
                    <div class="col-md-7">
                        <label class="align-self-center"><?= strtoupper($this->lang->line('group_area')) ?></label>
                        <select class="form-control" id="id_group_m" style="width: 100%"></select>
                    </div>
                    <div class="col-md-3 align-self-end">
                        <button type="button" id="btn_cari" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">FILTER</button>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        
        <div class="col-md-7 ">
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-4">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-3 p-0">
                            <div class="icon_target_realisasi" style="background-color:#007aff;">
                                <img src="<?= $this->config->item('dir_assets') ?>images/icon/target_icon.png" style="width:30px;height:30px;">
                            </div>
                        </div>
                        <div class="col-md-7 pl-0">
                            <label>Target Bulanan</label><BR>
                            <label id="total_target_bulanan" class="font-weight-bold">0</label>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="row">
                        <div class="col-md-3 p-0">
                            <div class="icon_target_realisasi" style="background-color:#ff9500;">
                                <img src="<?= $this->config->item('dir_assets') ?>images/icon/target_icon.png" style="width:30px;height:30px;">
                            </div>
                        </div>
                        <div class="col-md-9 pl-0">
                            <label>Total Target Personil</label><BR>
                            <label id="total_target_personil" class="font-weight-bold">0</label>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="row">
                        <div class="col-md-3 p-0">
                            <div class="icon_target_realisasi" style="background-color:#ff3b30; padding: 10px !important">
                                <img src="<?= $this->config->item('dir_assets') ?>images/icon/selisih_icon.png" style="width:25px;height:25px;">
                            </div>
                        </div>
                        <div class="col-md-9 pr-0">
                            <label>Selisih Target</label><BR>
                            <label id="selisih" class="font-weight-bold">0</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<hr>

<div class="table-responsive mt-3">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle text-uppercase">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_karyawan') ?></th>

                <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
                    <th class="text-center align-middle text-uppercase"><?= $this->lang->line('group_area') ?></th>
                <?php endif; ?>

                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nominal_target') ?></th>
                <th class="text-center align-middle text-uppercase">AKSI</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
