<style>
    th,
    td {
        white-space: nowrap;
    }

    div.dataTables_wrapper {
        margin: 0 auto;
    }
</style>
<table id="list_data" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr class="bg-tr">
            <?php
            $numrow = 1;
            if (count($master['pendapatan']) > 0 || count($master['potongan']) > 0) {
                $numrow = 2;
            }
            ?>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center" width="30">NO</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">NIK</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">NAMA KARYAWAN</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">BULAN</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">CABANG</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">DEPARTEMEN</th>
            <th rowspan="<?= $numrow ?>" class="align-middle text-center">JABATAN</th>
            <?php
            if (count($master['pendapatan']) > 0) {
                echo '<th colspan="' . count($master['pendapatan']) . '" class="align-middle text-center">PENDAPATAN</th>';
            }
            if (count($master['potongan']) > 0) {
                echo '<th colspan="' . count($master['potongan']) . '" class="align-middle text-center">POTONGAN</th>';
            }
            ?>
        </tr>
        <?php
        if (count($master['pendapatan']) > 0 || count($master['potongan']) > 0) {
            echo '<tr class="bg-tr">';
            if (count($master['pendapatan']) > 0) {
                foreach ($master['pendapatan'] as $komponen) {
                    echo '<th class="align-middle text-center">' . strtoupper($komponen['nm_komponen']) . '</th>';
                }
            }
            if (count($master['potongan']) > 0) {
                foreach ($master['potongan'] as $komponen) {
                    echo '<th class="align-middle text-center">' . strtoupper($komponen['nm_komponen']) . '</th>';
                }
            }
        }
        ?>
    </thead>
    <tbody>
    </tbody>
</table>

<script type="text/javascript">
    $(function() {
        var paramBulan = "<?= $bulan ?>";
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function(e, settings, techNote, message) {
            // if(confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')){
            //     window.location.reload();
            // }
        }).DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            'scrollCollapse': true,
            'fixedColumns': {
                'leftColumns': 3,
            },
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'NIK/Karyawan'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('payroll.data.komponen.tdk.tetap.import.listdata', ['bulan' => '"+paramBulan+"']) ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [1],
                    "bSortable": true
                },
                {
                    "aTargets": "_all",
                    "bSortable": false
                },
                {
                    "visible": false,
                    "targets": [1]
                },
                {
                    "className": "text-center",
                    "targets": [0]
                },
                {
                    "className": "text-left",
                    "targets": [1, 2, 3, 4, 5, 6]
                },
                {
                    "className": "text-right",
                    "targets": "_all"
                },
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                for (let index = 1; index < aData.length; index++) {
                    const col = aData[index];
                    if (col === "") {
                        $('td:eq(' + index + ')', nRow).css({
                            'background-color': '#FF7588',
                            'color': 'White'
                        });
                    }
                }
                if (aData[1] == "-") {
                    $('td:eq(1)', nRow).css({
                        'background-color': '#ffbc34',
                        'color': 'White'
                    });
                }
            },
        });
    });
</script>
