<script>
    $(document).on('click','#btn_form_template',function(){
        $('#tampil_form').load("<?= route('payroll.master.gapok.import.form.templateimport') ?>",function(){
            $('#modal_form').modal('show');
            $(".title").text("Unduh Template Gapok");
            $(".btn_unduh").addClass("btn_unduh btn btn-success");
            $(".btn_unduh").append('<i class="fa fa-download"></i> ');
            $(".btn_unduh").append('UNDUH');
            dropdown_cabang();
            dropdown_departemen();
        });
    });

    function dropdown_cabang() {
        $("#cabang").select2({
            placeholder: "Pilih Cabang",
            dropdownParent: $("#modal_form"),
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function dropdown_departemen(){
        $("#departemen").select2({
            placeholder: "Pilih Departemen",
            dropdownParent: $("#modal_form"),
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>'+'/'+$('#cabang').val(),
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }

    $(document).on("click", ".btn_unduh", function(){
        var loading = Ladda.create(this);
        loading.start();

        var id_cabang     = cek_null($('#cabang').val());
        var id_departemen = cek_null($('#departemen').val());
        window.location.href = "<?= route('payroll.master.bpjs.import.unduh.templateimport') ?>"+"/"+id_cabang+"/"+id_departemen;
        setTimeout(function (){
            loading.stop();
        },1000);
    });

    function cek_null($value) {
        if($value == null) {
            return "-";
        } else {
            return $value;
        }
    }

    $(document).on('click', '#btn_import_gaji', function(){
        var loading = Ladda.create(this);
        $('.form_import #message').html("");

        if(document.getElementById("file").files.length == "0"){
            $('.form_import #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> File belum diupload</font>");
            $('#file').focus();
            return false;
        }

        loading.start();

        var data = new FormData();
        data.append('file',$('#file').prop('files')[0]);

        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.bpjs.import.excel') ?>",
            data: data,
            contentType: false,
            processData: false,
            dataType: "json",
            success: function(result){
                if(result.success == true){
                    $('.form_import input').val('');
                }

                loading.stop();
                $('.form_import #message').show();
                $('.form_import #message').html(result.message);
            },
            error: function(){
                loading.stop();
                $('.form_import #message').show();
                $('.form_import #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });

    });

    $(document).on('click','.btn_hapus_semua',function(){
        $('#modal_hapus').modal('show');
        $(".title").text("Apakah anda ingin menghapus semua data ini?");
        $("#modal_hapus .card-body").show();
        $("#modal_hapus .card-footer").show();
        $(".tombol").empty();
        $(".tombol").append('<button class="btn_delete_semua btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');
    });

    //btn_delete
    $(document).on('click', '.btn_delete_semua',function(){
        var loading = Ladda.create(this);
        loading.start();
        $.ajax({
            type: 'DELETE',
            url: "<?=  route('payroll.master.bpjs.import.deleteall') ?>",
            dataType:'JSON',
            success: function(result){
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html(result.message.replace("#009900","FFFFFF"));
                loading.stop();
                setTimeout(() => {
                    $("#modal_hapus").modal("hide");
                }, 1000);
            },
            error:function(){
                loading.stop();
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });
    //btn_delete

    function edit(id_karyawan) {
        $('#tampil_form_bpjs_m').load("<?= site_url('payroll/bpjs/master/import/form') ?>/"+id_karyawan,function(){
            $('#modal_form_bpjs_m').modal('show');
            $(".title").text("Form Edit Data");
            $(".btn_save").addClass("btn_save btn btn-warning");
            $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save").append('PERBARUI');
            $("#btn_new_input").hide();
            initAutoNumeric();
            on_keyup_gaji_didaftakan();
            on_key_up_jml_anak();
        });
    }

    function hapus(id_karyawan) {
        $('#tampil_form_bpjs_m').load("<?= site_url('payroll/bpjs/master/import/form') ?>/"+id_karyawan,function(){
            $('#modal_form_bpjs_m').modal('show');
            $('#nominal').removeClass('form-control').addClass('form-control-plaintext');
            $(".title").text("Apakah Anda ingin menghapus data ini?");
            $('#form_input input:not(#id)').prop("disabled",true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('HAPUS');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            initAutoNumeric();
        });
    }

    function initAutoNumeric() {
        $('#form_input .nominal_normal').autoNumeric('init', {aSep: '.', aDec: ',', vMin: '0', vMax: '999999999'});
        $('#form_input .nominal_normal_rp').autoNumeric('init', {aSep: '.', aDec: ',', aSign: 'Rp. ', vMin: '0', vMax: '999999999'});
        $('#form_input .nominal').autoNumeric('init', {aSep: '.', aDec: ','});
        $('#form_input .nominal_text').autoNumeric('init', {aSep: '.', aDec: ',', aSign: 'Rp. '});
    }

    function on_keyup_gaji_didaftakan() {
        $('#form_input #gaji_daftar').on('keyup', function() {
            set_bpjs();
        });
    }

    function set_bpjs() {
        set_bpjs_kes_tunj_perus();
        set_bpjs_kes_pot_kry();
        set_bpjs_tk_tunj_jht_perus();
        set_bpjs_tk_pot_jht_kry();
        set_bpjs_tk_tunj_jkk();
        set_bpjs_tk_tunj_jkm();
        set_bpjs_tk_tunj_jp_perus();
        set_bpjs_tk_pot_jp_kry();
        set_ttl_pot_kry();
        set_ttl_dibiayai_perus();
    }

    function set_bpjs_kes_tunj_perus() {
        var bpjs_kes_tunj_perus = hitung_bpjs_kes_tunj_perus();
        $('#form_input #bpjs_kes_tunj_perus_rp, #form_input #bpjs_kes_tunj_perus_rp_text').autoNumeric('set', bpjs_kes_tunj_perus);
    }

    function hitung_bpjs_kes_tunj_perus() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        if(bpjs_kes_flag == 0) {
            return 0;
        } else {
            var gaji_daftar = aturan_maksimal_gaji_bpjs_kes(get_gaji_didaftarkan());
            var bpjs_kes_tunj_perus = $('#form_input #bpjs_kes_tunj_perus').val();
            return gaji_daftar*(bpjs_kes_tunj_perus/100);
        }
    }

    function aturan_maksimal_gaji_bpjs_kes(gaji) {
        if(gaji > 12000000) {
            return 12000000;
        } else {
            return gaji;
        }
    }

    function get_gaji_didaftarkan() {
        return $('#form_input #gaji_daftar').autoNumeric('get');
    }

    function set_bpjs_kes_pot_kry() {
        var bpjs_kes_pot_kry = hitung_bpjs_kes_pot_kry();
        $('#form_input #bpjs_kes_pot_kry_rp, #form_input #bpjs_kes_pot_kry_rp_text').autoNumeric('set', bpjs_kes_pot_kry);
    }

    function hitung_bpjs_kes_pot_kry() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        if(bpjs_kes_flag == 0) {
            return 0;
        } else {
            var gaji_daftar      = aturan_maksimal_gaji_bpjs_kes(get_gaji_didaftarkan());
            var bpjs_kes_pot_kry = $('#form_input #bpjs_kes_pot_kry').val();
            var jml_anak         = $('#form_input #jml_anak').val();
            if(jml_anak > 3) { //jika jumlh anak lebih dari 3
                return gaji_daftar*((jml_anak-2)/100);
            } else {
                return gaji_daftar*(bpjs_kes_pot_kry/100);
            }
        }
    }

    function set_bpjs_tk_tunj_jht_perus() {
        var bpjs_tk_tunj_jht_perus = hitung_bpjs_tk_tunj_jht_perus();
        $('#form_input #bpjs_tk_tunj_jht_perus_rp, #form_input #bpjs_tk_tunj_jht_perus_rp_text').autoNumeric('set', bpjs_tk_tunj_jht_perus);
    }

    function hitung_bpjs_tk_tunj_jht_perus() {
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        if(bpjs_tk_flag_jht == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_tunj_jht_perus = $('#form_input #bpjs_tk_tunj_jht_perus').val();
            return gaji_daftar*(bpjs_tk_tunj_jht_perus/100);
        }
    }

    function set_bpjs_tk_pot_jht_kry() {
        var bpjs_tk_pot_jht_kry = hitung_bpjs_tk_pot_jht_kry();
        $('#form_input #bpjs_tk_pot_jht_kry_rp, #form_input #bpjs_tk_pot_jht_kry_rp_text').autoNumeric('set', bpjs_tk_pot_jht_kry);
    }

    function hitung_bpjs_tk_pot_jht_kry() {
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        if(bpjs_tk_flag_jht == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_pot_jht_kry = $('#form_input #bpjs_tk_pot_jht_kry').val();
            return gaji_daftar*(bpjs_tk_pot_jht_kry/100);
        }
    }

    function set_bpjs_tk_tunj_jkk() {
        var bpjs_tk_tunj_jkk = hitung_bpjs_tk_tunj_jkk();
        $('#form_input #bpjs_tk_tunj_jkk_rp, #form_input #bpjs_tk_tunj_jkk_rp_text').autoNumeric('set', bpjs_tk_tunj_jkk);
    }

    function hitung_bpjs_tk_tunj_jkk() {
        var bpjs_tk_flag_jkk = $('#form_input #bpjs_tk_flag_jkk').val();
        if(bpjs_tk_flag_jkk == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_tunj_jkk = $('#form_input #bpjs_tk_tunj_jkk').val();
            return gaji_daftar*(bpjs_tk_tunj_jkk/100);
        }
    }

    function set_bpjs_tk_tunj_jkm() {
        var bpjs_tk_tunj_jkm = hitung_bpjs_tk_tunj_jkm();
        $('#form_input #bpjs_tk_tunj_jkm_rp, #form_input #bpjs_tk_tunj_jkm_rp_text').autoNumeric('set', bpjs_tk_tunj_jkm);
    }

    function hitung_bpjs_tk_tunj_jkm() {
        var bpjs_tk_flag_jkm = $('#form_input #bpjs_tk_flag_jkm').val();
        if(bpjs_tk_flag_jkm == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_tunj_jkm = $('#form_input #bpjs_tk_tunj_jkm').val();
            return gaji_daftar*(bpjs_tk_tunj_jkm/100);
        }
    }

    function aturan_maksimal_gaji_bpjs_tk_jp(gaji) {
        if(gaji > 9559600) {
            return 9559600;
        } else {
            return gaji;
        }
    }

    function set_bpjs_tk_tunj_jp_perus() {
        var bpjs_tk_tunj_jp_perus = hitung_bpjs_tk_tunj_jp_perus();
        $('#form_input #bpjs_tk_tunj_jp_perus_rp, #form_input #bpjs_tk_tunj_jp_perus_rp_text').autoNumeric('set', bpjs_tk_tunj_jp_perus);
    }

    function hitung_bpjs_tk_tunj_jp_perus() {
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();
        if(bpjs_tk_flag_jp == 0) {
            return 0;
        } else {
            var gaji_daftar = aturan_maksimal_gaji_bpjs_tk_jp(get_gaji_didaftarkan());
            var bpjs_tk_tunj_jp_perus = $('#form_input #bpjs_tk_tunj_jp_perus').val();
            return gaji_daftar*(bpjs_tk_tunj_jp_perus/100);
        }
    }

    function hitung_bpjs_tk_pot_jp_kry() {
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();
        if(bpjs_tk_flag_jp == 0) {
            return 0;
        } else {
            var gaji_daftar = aturan_maksimal_gaji_bpjs_tk_jp(get_gaji_didaftarkan());
            var bpjs_tk_pot_jp_kry = $('#form_input #bpjs_tk_pot_jp_kry').val();
            return gaji_daftar*(bpjs_tk_pot_jp_kry/100);
        }
    }

    function set_bpjs_tk_pot_jp_kry() {
        var bpjs_tk_pot_jp_kry = hitung_bpjs_tk_pot_jp_kry();
        $('#form_input #bpjs_tk_pot_jp_kry_rp, #form_input #bpjs_tk_pot_jp_kry_rp_text').autoNumeric('set', bpjs_tk_pot_jp_kry);
    }

    function hitung_ttl_pot_kry() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();

        var bpjs_kes_pot_kry = 0;
        var bpjs_tk_pot_jht_kry = 0;
        var bpjs_tk_pot_jp_kry = 0;

        if(bpjs_kes_flag == 1) {
            bpjs_kes_pot_kry = $('#form_input #bpjs_kes_pot_kry_rp_text').autoNumeric('get');
        }
        if(bpjs_tk_flag_jht == 1) {
            bpjs_tk_pot_jht_kry = $('#form_input #bpjs_tk_pot_jht_kry_rp_text').autoNumeric('get');
        }
        if(bpjs_tk_flag_jp == 1) {
            bpjs_tk_pot_jp_kry = $('#form_input #bpjs_tk_pot_jp_kry_rp_text').autoNumeric('get');
        }

        return bpjs_kes_pot_kry+bpjs_tk_pot_jht_kry+bpjs_tk_pot_jp_kry;
    }

    function set_ttl_pot_kry() {
        var ttl_pot_kry = hitung_ttl_pot_kry();
        $('').val();
        $('#form_input #ttl_pot_kry, #form_input #ttl_pot_kry_text').autoNumeric('set', ttl_pot_kry);
    }

    function hitung_ttl_dibiayai_perus() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        var bpjs_tk_flag_jkk = $('#form_input #bpjs_tk_flag_jkk').val();
        var bpjs_tk_flag_jkm = $('#form_input #bpjs_tk_flag_jkm').val();
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();

        var bpjs_kes_tunj_perus = 0;
        var bpjs_tk_tunj_jht_perus = 0;
        var bpjs_tk_tunj_jkk = 0;
        var bpjs_tk_tunj_jkm = 0;
        var bpjs_tk_tunj_jp_perus = 0;

        if(bpjs_kes_flag == 1) {
            bpjs_kes_tunj_perus = $('#form_input #bpjs_kes_tunj_perus_rp_text').autoNumeric('get');
        }
        if(bpjs_tk_flag_jht == 1) {
            bpjs_tk_tunj_jht_perus = $('#form_input #bpjs_tk_tunj_jht_perus_rp_text').autoNumeric('get');
        }
        if(bpjs_tk_flag_jkk == 1) {
            bpjs_tk_tunj_jkk = $('#form_input #bpjs_tk_tunj_jkk_rp_text').autoNumeric('get');
        }
        if(bpjs_tk_flag_jkm == 1) {
            bpjs_tk_tunj_jkm = $('#form_input #bpjs_tk_tunj_jkm_rp_text').autoNumeric('get');
        }
        if(bpjs_tk_flag_jp == 1) {
            bpjs_tk_tunj_jp_perus = $('#form_input #bpjs_tk_tunj_jp_perus_rp_text').autoNumeric('get');
        }

        return bpjs_kes_tunj_perus+bpjs_tk_tunj_jht_perus+bpjs_tk_tunj_jkk+bpjs_tk_tunj_jkm+bpjs_tk_tunj_jp_perus;
    }

    function set_ttl_dibiayai_perus() {
        var ttl_dibiayai_perus = hitung_ttl_dibiayai_perus();
        $('').val(ttl_dibiayai_perus);
        $('#form_input #ttl_tunj_dibiayai_perus, #form_input #ttl_tunj_dibiayai_perus_text').autoNumeric('set', ttl_dibiayai_perus);
    }

    function on_key_up_jml_anak() {
        $('#form_input #jml_anak').on('keyup mouseup', function() {
            set_bpjs_kes_pot_kry();
            set_ttl_pot_kry();
            set_ttl_dibiayai_perus();
        });
    }

    // PROSES DELETE
    $(document).on('click','.btn_hapus',function(){
        var loading = Ladda.create(this);
        loading.start();

        var param = {};
        param.id = $("#id").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.bpjs.import.delete') ?>",
            data: param,
            dataType:'JSON',
            success: function(result){
                $("#tampil_form_bpjs_m .card-body").hide();
                $("#tampil_form_bpjs_m .card-footer").hide();
                $("#tampil_form_bpjs_m .title").html(result.message.replace("#009900","FFFFFF"));
                loading.stop();
                setTimeout(() => {
                    $("#tampil_form_bpjs_m").modal("hide");
                }, timeout);
            },
            error:function(){
                loading.stop();
                $("#tampil_form_bpjs_m .card-body").hide();
                $("#tampil_form_bpjs_m .card-footer").hide();
                $("#tampil_form_bpjs_m .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    $(document).on("click",".btn_save",function(e){
        e.preventDefault();
        $('#tampil_form_bpjs_m #message').html("");
        var gaji_daftar = $('#gaji_daftar').val();
        var loading = Ladda.create(this);

        if(gaji_daftar == '') {
            $('#tampil_form_bpjs_m #message').html('<span class="text-danger"><i class="fa fa-exclamation-triangle"></i> gaji yang didaftarkan belum diisi</span>');
            return false;
        }

        loading.start();
        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.bpjs.import.save') ?>",
            data: $('#tampil_form_bpjs_m #form_input').serialize(),
            dataType:'JSON',
            success: function(result) {
                loading.stop();
                $('#tampil_form_bpjs_m #message').show();
                $('#tampil_form_bpjs_m #message').html(result.message);
            },
            error:function(){
                loading.stop();
                $('#tampil_form_bpjs_m #message').show();
                $('#tampil_form_bpjs_m #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    // # SIMPAN SEMUA DATA TEMPORARY
    $(document).on('click','.btn_simpan_semua',function(){
            $('#modal_hapus').modal('show');
            $(".title").text("Apakah anda ingin menyimpan semua data ini?");
            $("#modal_hapus .card-body").show();
            $("#modal_hapus .card-footer").show();
            $(".tombol").empty();
            $(".tombol").append('<button class="btn_save_semua btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>');
    });

    //btn_delete
    $(document).on('click', '.btn_save_semua',function(){
        var id = $(this).attr('id');
        var loading = Ladda.create(this);
        loading.start();
        $.ajax({
            type: 'POST',
            url: "<?= route('payroll.master.bpjs.import.publishall') ?>",
            data: 'id='+id,
            dataType:'JSON',
            success: function(result){
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html(result.message.replace("#009900","FFFFFF"));
                loading.stop();
                setTimeout(() => {
                    $("#modal_hapus").modal("hide");
                }, 1000);
            },
            error:function(){
                loading.stop();
                $("#modal_hapus .card-body").hide();
                $("#modal_hapus .card-footer").hide();
                $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    $(function() {
        list_data = $('#list_data').DataTable({
                'searching'     : true,
                'paging'        : true,
                'lengthChange'  : true,
                'ordering'      : true,
                'info'          : true,
                'scrollX'       :true,
                'fixedColumns': {
                        leftColumns: 3,
                        rightColumns: 3
                },
                'scrollCollapse': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                    "url": "<?= route('payroll.master.bpjs.import.listdata') ?>",
                                    "type": "GET",
                                    "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                    },
                    "aoColumnDefs": [
                                        { "aTargets": [0, -1], "bSortable": false}

                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(3)', nRow).css({'text-align':'right'});
                            $('td:eq(-1)', nRow).css({'text-align':'center'});
                            if(aData[17] == 3) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#FFF9EI'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #F2C94C'});
                            } else if(aData[17] == 2) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#FFF1F1'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #EB5757'});
                            } else if(aData[17] == 4) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#DEFBE6'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #27AE60'});
                            }
                    }
        });
    });
</script>
