<script type="text/javascript">
    $(function() {
        loading('#myTabContent');
        $("#modal_form .modal-dialog").removeClass("modal-lg");

        // set padding-top to content-wrapper
        $(".content-wrapper").css("padding-top", "20px");

        if (localStorage.getItem("patroli-tab-menu") != null) {
            let thisTab = document.getElementById(localStorage.getItem("patroli-tab-menu"));
            if (!thisTab) {
                thisTab = document.querySelector('.tab_menu a');
            }
            thisTab.closest('li').click();
            thisTab.classList.add("active");
        } else {
            const thisTab = document.querySelector('.tab_menu a');
            thisTab.closest('li').click();
            thisTab.classList.add("active");
        }

        $('.tab_menu li a').click(function() {
            $('.tab_menu li a').removeClass("active");
            $(this).addClass("active");
        });
    });

    function select_tab_menu(e) {
        loading('#myTabContent');
        switch (e.attr("id")) {
            case "tab_masterqr":
                $("#myTabContent").load("<?= route('patroli.master.qrcode.home') ?>");
                localStorage.setItem("patroli-tab-menu", "tab_masterqr");
                break;

            case "tab_jadwal":
                $("#myTabContent").load("<?= route('patroli.jadwal.home') ?>");
                localStorage.setItem("patroli-tab-menu", "tab_jadwal");
                break;

            case "tab_laporan":
                $("#myTabContent").load("<?= route('patroli.laporan.home') ?>");
                localStorage.setItem("patroli-tab-menu", "tab_laporan");
                break;

            default:
                $("#myTabContent").html("Halaman Dashboard");
                localStorage.setItem("patroli-tab-menu", "tab_masterqr");
                break;
        }
    }

    function loading(id) {
        $(id).html('<div class="modal-body"><div class="text-center"><div class="custom-lds-ring"><div></div><div></div><div></div></div></div></div>');
    }

    function screenUp(y) {
        window.scroll({
            top: y,
            left: 0,
            behavior: 'smooth'
        });
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($this->level_user === '1') : ?>
    <div class="row match-height">
        <div class="col-xl-12 col-lg-12">
            <div class="card card-rounded card-detail-karyawan">
                <div class="card-content">
                    <div class="card-body p-custom">
                        <div class="nav-vertical row">
                            <div class="col-md-2 border-kanan">
                                <ul class="tab_menu nav nav-tabs nav-left flex-column">
                                    <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                        <a id="tab_masterqr" class="nav-link" aria-expanded="false">
                                            Master QR Code
                                        </a>
                                    </li>
                                    <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                        <a id="tab_jadwal" class="nav-link" aria-expanded="false">
                                            <?= $this->lang->line('jadwal') ?>
                                        </a>
                                    </li>
                                    <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                        <a id="tab_laporan" class="nav-link" aria-expanded="false">
                                            <?= $this->lang->line('laporan_pat') ?>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-10" style="padding: 20px;">
                                <div id="myTabContent" class="tab-content">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <?php redirect(route('page.not.found')); ?>
<?php endif; ?>
