<script>
    $(function() {
        table = $('#list_data').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "order": [], //Initial no order.
            "searching": true,
            'ordering'    : true,
            'paging'      : true,
            'lengthChange': true,
            'info'        : true,
            'language'    :{
                                'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                'searchPlaceholder': 'Nama Lokasi'
                            },
            // Load data for the table's content from an Ajax source
            "ajax": {
                "url": "<?php echo site_url('master/lokasi/list_data') ?>",
                "type": "POST",
                "data": {
                                id_cabang : function() {
                                    return $(".filter #id_cabang").val()
                                },
                        },
                "complete" : function(data){
                                reconfigure(data);
                            }
            },
            //Set column definition initialisation properties.
            "columnDefs": [{
                    "targets": [-1], //last column
                    "orderable": false //set not orderable
                },
                {
                    "targets": [0], //2 last column (photo)
                    "orderable": false //set not orderable
                }
            ],
            "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                    $('td:eq(0)', nRow).css({'text-align':'center'});
                    $('td:eq(1)', nRow).css({'text-align':'left'});
                    $('td:eq(2)', nRow).css({'text-align':'left'});
                    $('td:eq(3)', nRow).css({'text-align':'left'});
                    $('td:eq(5)', nRow).css({'text-align':'center'});
                    $('td:eq(6)', nRow).css({'text-align':'center'});
            }
        });

        $('.filter #id_cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });

        $(document).on('click','.filter #btn_filter',function(){
            var loading = Ladda.create(this);
            loading.start();
            table.ajax.reload(function(){
                loading.stop();
            });
        });


         //btn_hapus
        $(document).on('click','.btn_delete',function(){
                var id_lokasi = $(this).attr('id');
                $('#modal_lokasi #id_lokasi').val(id_lokasi);
                $('#modal_lokasi').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $(".btn_hapus").removeClass("btn_hapus").addClass("btn_hapus btn btn-danger");
                $("#modal_lokasi .card-body").show();
                $("#modal_lokasi .card-footer").show();
        });

        //btn_delete
        $(document).on('click','.btn_hapus',function(){
            var loading = Ladda.create(this);
            loading.start();
            id_lokasi = $('#modal_lokasi #id_lokasi').val();
            $.ajax({
                type: 'POST',
                url: "<?php echo site_url('master/lokasi/delete') ?>",
                data: 'id_lokasi='+id_lokasi,
                dataType:'JSON',
                success: function(result){
                    $("#modal_lokasi .card-body").hide();
                    $("#modal_lokasi .card-footer").hide();
                    $("#modal_lokasi .title").html(result.message);
                    if(result.success == true){
                        location.reload();
                    }

                    loading.stop();
                },
                error:function(){
                    loading.stop();
                    $("#modal_lokasi .card-body").hide();
                    $("#modal_lokasi .card-footer").hide();
                    $("#modal_lokasi .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
        //btn_delete

    });
</script>
<style type="text/css">
    th {
        text-align: center;
    }
</style>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Master Data</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <?php
                    if (in_array($this->session->userdata('level_user'), array("1","5")) and $kode_paket != 15) {
                ?>
                <div class="text-right">
                    <a href="<?= site_url("master/lokasi/tambah")  ?>" title="Tambah Lokasi">
                        <button id="new" type="button" class="btn waves-effect waves-light btn-biru">
                            <i class="fa fa-plus"></i> Tambah Lokasi
                        </button>
                    </a>
                </div>
                <?php
                    }
                ?>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <div id= "map" style = "height:580px"></div>
                </div>
            </div>

            <div class="row mt-3 filter">
                <div class="col-md-4">
                    <select id="id_cabang" class="form-control select2"></select>
                </div>
                <div class="col-md-1">
                    <button id="btn_filter" class="btn btn-primary ladda-button" data-style="expand-left">FILTER</button>
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-md-12 table-responsive">
                    <table id="list_data" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="text-center">NO</th>
                                <th class="text-left">NAMA LOKASI</th>
                                <th class="text-left">NAMA CABANG</th>
                                <th class="text-left">LATITUDE</th>
                                <th class="text-left">LONGITUDE</th>
                                <th class="text-center">RADIUS (METER)</th>
                                <?php
                                    if(in_array($this->session->userdata('level_user'), array("1","5")) || in_array($this->session->userdata('level_khusus'), array("1"))) {
                                ?>
                                        <th>AKSI</th>
                                <?php
                                    }
                                ?>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>  <!-- card-body -->
    </div><!-- card-content -->
</div><!-- card-rounded -->


<!-- START TAMPIL MODAL -->
<div id="modal_lokasi" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content">
            <input type="hidden" id="id_lokasi">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left">HAPUS</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script>
    // Creating map options
    var mapOptions = {
                        center: [<?= $lat_one.','.$long_one;  ?>],
                        zoom: 7
                    }
    // Creating a map object
    var map = new L.map('map', mapOptions);

    // Creating a Layer object
    var layer = new L.TileLayer("https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png");

    // Adding layer to the map
    map.addLayer(layer);


    <?php
        $sin = array();
        foreach ($list as $row) {

        $sin[] = "[".$row->lat_asli.','.$row->long_asli."]";

    ?>

    var marker = new L.Marker([<?= $row->lat_asli.','.$row->long_asli ?>]).bindPopup(<?= "'<label>Kantor :".$row->nama_kantor."</label><br>"."<label>Latitude :".$row->lat_asli."</label><br>"."<label>Longitude :".$row->long_asli."</label>'" ?>);

    var latlngs = [<?php echo implode(',', $sin) ?>];
    marker.addTo(map);
    <?php } ?>
    var bounds = new L.LatLngBounds(latlngs);
    map.fitBounds(bounds);

</script>
