<script type="text/javascript">
    $(document).ready(function() {
        datepicker();
    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_karyawan" class="form-control" value="<?= $id_karyawan ?>">
    <input type="hidden" id="id_keluarga" class="form-control" value="<?= ((isset($data)) ? md5($data->id_keluarga) : '') ?>">
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('hubungan_dengan_karyawan') ?> <i class="text-danger">*</i></label>
                <select id="hub_keluarga" name="hub_keluarga" class="form-control">
                    <option value="Ayah" <?= ((isset($data) and $data->hub_keluarga == 'Ayah') ? 'selected' : '') ?>><?= $this->lang->line('ayah') ?></option>
                    <option value="Ibu" <?= ((isset($data) and $data->hub_keluarga == 'Ibu') ? 'selected' : '') ?>><?= $this->lang->line('ibu') ?></option>
                    <option value="Suami" <?= ((isset($data) and $data->hub_keluarga == 'Suami') ? 'selected' : '') ?>><?= $this->lang->line('suami') ?></option>
                    <option value="Istri" <?= ((isset($data) and $data->hub_keluarga == 'Istri') ? 'selected' : '') ?>><?= $this->lang->line('istri') ?></option>
                    <option value="Anak" <?= ((isset($data) and $data->hub_keluarga == 'Anak') ? 'selected' : '') ?>><?= $this->lang->line('anak') ?></option>
                    <option value="Saudara Kandung" <?= ((isset($data) and $data->hub_keluarga == 'Saudara Kandung') ? 'selected' : '') ?>><?= $this->lang->line('saudara_kandung') ?></option>
                </select>
            </div>
            <div class="col-md-6">
                <label><?= $this->lang->line('status_perkawinan') ?> <i class="text-danger">*</i></label>
                <select id="status_perkawinan" name="status_perkawinan" class="form-control">
                    <option value="Belum Kawin" <?= ((isset($data) and $data->status_perkawinan == 'Belum Kawin') ? 'selected' : '') ?>><?= $this->lang->line('belum_kawin') ?></option>
                    <option value="Kawin" <?= ((isset($data) and $data->status_perkawinan == 'Kawin') ? 'selected' : '') ?>><?= $this->lang->line('kawin') ?></option>
                    <option value="Cerai Hidup" <?= ((isset($data) and $data->status_perkawinan == 'Cerai Hidup') ? 'selected' : '') ?>><?= $this->lang->line('cerai_hidup') ?></option>
                    <option value="Cerai Mati" <?= ((isset($data) and $data->status_perkawinan == 'Cerai Mati') ? 'selected' : '') ?>><?= $this->lang->line('cerai_mati') ?></option>
                </select>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label><?= $this->lang->line('nama_lengkap') ?> <i class="text-danger">*</i></label>
                <input type="text" id="nama" class="form-control" value="<?= isset($data->nama) ? $data->nama : '' ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('tempat_lahir') ?> <i class="text-danger">*</i></label>
                <input type="text" id="tempat_lahir" class="form-control" value="<?= ((isset($data)) ? $data->tempat_lahir : '') ?>">
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('tgl_lahir') ?> <i class="text-danger">*</i></label>
                <?php
                if (isset($data)) {
                    $tanggal = date('d-m-Y', strtotime($data->tanggal_lahir));
                } else {
                    $tanggal = "";
                }
                ?>
                <input type="text" id="tanggal_lahir" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tanggal ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('nomor_induk_karyawan') ?></label>
                <input type="text" id="nik" class="form-control numberbox" value="<?= ((isset($data)) ? $data->nik : '') ?>">
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('no_bpjs_kes') ?></label>
                <input type="text" id="no_bpjs" class="form-control numberbox" value="<?= ((isset($data)) ? $data->no_bpjs : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('jenis_kelamin') ?> <i class="text-danger">*</i></label>
                <select id="jenis_kelamin" name="jenis_kelamin" class="form-control">
                    <option value="L" <?= ((isset($data) and $data->jenis_kelamin == 'L') ? 'selected' : '') ?>><?= $this->lang->line('laki_laki') ?></option>
                    <option value="P" <?= ((isset($data) and $data->jenis_kelamin == 'P') ? 'selected' : '') ?>><?= $this->lang->line('perempuan') ?></option>
                </select>
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('agama') ?> <i class="text-danger">*</i></label>
                <select id="agama" name="agama" class="form-control">
                    <option value="Islam" <?= ((isset($data) and $data->agama == 'Islam') ? 'selected' : '') ?>><?= $this->lang->line('islam') ?></option>
                    <option value="Kristen" <?= ((isset($data) and $data->agama == 'Kristen') ? 'selected' : '') ?>><?= $this->lang->line('kristen') ?></option>
                    <option value="Hindu" <?= ((isset($data) and $data->agama == 'Hindu') ? 'selected' : '') ?>><?= $this->lang->line('hindu') ?></option>
                    <option value="Buddha" <?= ((isset($data) and $data->agama == 'Buddha') ? 'selected' : '') ?>><?= $this->lang->line('buddha') ?></option>
                    <option value="Katolik" <?= ((isset($data) and $data->agama == 'Katolik') ? 'selected' : '') ?>><?= $this->lang->line('katolik') ?></option>
                    <option value="Khonghucu" <?= ((isset($data) and $data->agama == 'Khonghucu') ? 'selected' : '') ?>><?= $this->lang->line('khonghucu') ?></option>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('no_telp') ?></label>
                <input type="text" id="telepon" class="numberbox form-control" value="<?= ((isset($data)) ? $data->telepon : '') ?>">
            </div>
            <div class="col-md-6">
                <label><?= $this->lang->line('pekerjaan') ?> <i class="text-danger">*</i></label>
                <select id="pekerjaan" name="pekerjaan" class="form-control">
                    <option value="Pelajar/Mahasiswa" <?= ((isset($data) and $data->pekerjaan == 'Pelajar/Mahasiswa') ? 'selected' : '') ?>><?= $this->lang->line('pelajar_mahasiswa') ?></option>
                    <option value="Belum Bekerja" <?= ((isset($data) and $data->pekerjaan == 'Belum Bekerja') ? 'selected' : '') ?>><?= $this->lang->line('tidak_bekerja') ?></option>
                    <option value="Bekerja" <?= ((isset($data) and $data->pekerjaan == 'Bekerja') ? 'selected' : '') ?>><?= $this->lang->line('bekerja') ?></option>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('tgl_perkawinan') ?></label>
                <?php
                if (isset($data)) {
                    if ($data->tanggal_perkawinan != "0000-00-00") {
                        $tanggal_kawin = date('d-m-Y', strtotime($data->tanggal_perkawinan));
                    } else {
                        $tanggal_kawin = "";
                    }
                } else {
                    $tanggal_kawin = "";
                }
                ?>
                <input type="text" id="tanggal_perkawinan" class="form-control datepicker dateonly" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tanggal_kawin ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>
            <div class="col-md-6">
                <label><?= $this->lang->line('pendidikan_terakhir') ?> <i class="text-danger">*</i></label>
                <select id="pendidikan_terakhir" name="pendidikan_terakhir" class="form-control">
                    <option value="Belum Sekolah" <?= ((isset($data) and $data->pendidikan_terakhir == 'Belum Sekolah') ? 'selected' : '') ?>><?= $this->lang->line('belum_sekolah') ?></option>
                    <option value="TK" <?= ((isset($data) and $data->pendidikan_terakhir == 'TK') ? 'selected' : '') ?>><?= $this->lang->line('tk') ?></option>
                    <option value="SD" <?= ((isset($data) and $data->pendidikan_terakhir == 'SD/MI') ? 'selected' : '') ?>><?= $this->lang->line('sd_mi') ?></option>
                    <option value="SMP" <?= ((isset($data) and $data->pendidikan_terakhir == 'SMP/MTS') ? 'selected' : '') ?>><?= $this->lang->line('smp_mts') ?></option>
                    <option value="SMA" <?= ((isset($data) and $data->pendidikan_terakhir == 'SMA/SMK') ? 'selected' : '') ?>><?= $this->lang->line('sma_smk') ?></option>
                    <option value="D3" <?= ((isset($data) and $data->pendidikan_terakhir == 'D3') ? 'selected' : '') ?>><?= $this->lang->line('d3') ?></option>
                    <option value="D4" <?= ((isset($data) and $data->pendidikan_terakhir == 'D4') ? 'selected' : '') ?>><?= $this->lang->line('d4') ?></option>
                    <option value="S1" <?= ((isset($data) and $data->pendidikan_terakhir == 'S1') ? 'selected' : '') ?>><?= $this->lang->line('s1') ?></option>
                    <option value="S2" <?= ((isset($data) and $data->pendidikan_terakhir == 'S2') ? 'selected' : '') ?>><?= $this->lang->line('s2') ?></option>
                    <option value="S3" <?= ((isset($data) and $data->pendidikan_terakhir == 'S3') ? 'selected' : '') ?>><?= $this->lang->line('s3') ?></option>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Status <i class="text-danger">*</i></label>
                <select id="status" name="status" class="form-control">
                    <option value="Hidup" <?= ((isset($data) and $data->status == 'Hidup') ? 'selected' : '') ?>><?= $this->lang->line('hidup') ?></option>
                    <option value="Meninggal" <?= ((isset($data) and $data->status == 'Meninggal') ? 'selected' : '') ?>><?= $this->lang->line('meninggal') ?></option>
                </select>
            </div>
        </div>
    </div>

</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save_keluarga btn btn-primary ladda-button" id="btn_save_keluarga" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
