<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Target_personil_m extends CI_Model
{
    var $table = 'data_karyawan';

    function get_datatables($bulan="00-0000",  $id_group_m="all"){
        $this->_get_datatables_query($bulan, $id_group_m);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($bulan="00-0000",  $id_group_m="all"){
        $this->_get_datatables_query($bulan, $id_group_m);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($bulan="00-0000",  $id_group_m="all"){
        $this->_get_datatables_query($bulan, $id_group_m);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($bulan="00-0000",  $id_group_m="all"){
        $this->db->select("
            karyawan.id_karyawan,
            karyawan.nik,
            karyawan.nama_lengkap,
            karyawan.id_company,
            target.tahun,
            target.bulan,
            IF(target.nominal IS NULL, 0, target.nominal) AS nominal,
            IF(target.nominal IS NULL, 'insert', 'update') AS action,
            approver.id_group_m,
            sgm.kode AS kode_group,
            sgm.nama AS nama_group
        ")
        ->from($this->table. ' AS karyawan')
        ->join('sales_approver as approver', 'approver.id_karyawan = karyawan.id_karyawan')
        ->join('sales_group_m as sgm', 'sgm.id_group_m = approver.id_group_m', 'LEFT')
        ->join('
            sales_target_personil_p as target', 
            'target.id_karyawan = karyawan.id_karyawan
                AND CONCAT(bulan,"-",tahun) ="'.$bulan.'"',
            'LEFT'
        )
        ->where("karyawan.id_company", $this->id_company)
        ->where("karyawan.flag_sales", "1")
        ->where_in("karyawan.status", ["1", "2", "3", "4"]);
        
        // filter id_group_m
        if($id_group_m != "all"){
            $this->db->where('approver.id_group_m', $id_group_m);
        }

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('approver.id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        $column_search = array('nik' ,'nama_lengkap');
        $i = 0;
        foreach ($column_search as $item) {
            if ($_GET['search']['value']) {

                if ($i === 0) {
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        // $column_order = array('', 'kode', 'nama', 'flag');
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("karyawan.nama_lengkap" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function save($data=[], $id="", $status=""){
        if($status == 'update'){
            // PROSES UPDATE
            $user_update = array(
                    'tgl_update'  => date("Y-m-d H:i:s"),
                    'user_update' => $this->nik_karyawan. " - ". $this->nm_karyawan
                );

            $this->db->trans_start();

            $this->db->where('id_company', $this->id_company);
            $this->db->where("md5(CONCAT(id_karyawan,tahun,bulan,id_company))",$id);
            $this->db->update('sales_target_personil_p', array_merge($data,$user_update));

            $data['nominal_target'] = $data['nominal'];
            unset($data['nominal']);
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_group_m', $this->input->post('id_group_m'));
            $this->db->where("md5(CONCAT(id_karyawan,tahun,bulan,id_company))",$id);
            $this->db->update('sales_target_personil_r', array_merge($data,$user_update));

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->db->trans_commit();
                return  __response_update(true);
            } else {
                $this->db->trans_rollback();
                return  __response_update(false);
            }
        }else{
            // PROSES SAVE
            $karyawan   = $this->_get_data_target_personil($data['id_karyawan']);
            $user_input = array(
                    'tgl_input'  => date("Y-m-d H:i:s"),
                    'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
                );

            $this->db->trans_start();

            // 1. Save ke target_personil_p
            $this->db->insert('sales_target_personil_p', array_merge($data,$user_input));
            
            // 2. Save ke target_personil_r
            $data['jumlah_po']         = 0;
            $data['nominal_realisasi'] = 0;
            $data['nominal_target']    = $data['nominal'];
            $data['nik']               = $karyawan->nik;
            $data['nama_karyawan']     = $karyawan->nama_karyawan;
            $data['id_group_m']        = $karyawan->id_group_m;
            $data['nama_group']        = $karyawan->kode_group. " - ". $karyawan->nama_group;
            unset($data['nominal']);

            $this->db->insert('sales_target_personil_r', array_merge($data,$user_input));

            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->db->trans_commit();
                return  __response_save(true);
            } else {
                $this->db->trans_rollback();
                return  __response_save(false);
            }
        }
    }

    public function target_bulanan($bulan = "00-0000", $id_group_m="all"){
        $explode = explode('-', $bulan);

        if($id_group_m != "all"){
            $this->db->where('id_group_m', $id_group_m);
        }

        $result = $this->db->select('SUM(nominal) AS nominal')
                            ->from('sales_target_bulanan_p AS target')
                            ->where('id_company', $this->id_company)
                            ->where('bulan', $explode[0])
                            ->where('tahun', $explode[1])
                            ->group_by('tahun, bulan')
                            ->get()
                            ->row();
                           
        return $result ? $result->nominal : 0;
    }

    public function total_target_personil($bulan = "00-0000", $id_group_m="all"){
        $explode = explode('-', $bulan);

        if($id_group_m != "all"){
            $this->db->where('approver.id_group_m', $id_group_m);
        }

        $result = $this->db->select('SUM(target.nominal) AS total_target')
                            ->from('sales_target_personil_p AS target')
                            ->join('sales_approver as approver', 'approver.id_karyawan = target.id_karyawan')
                            ->where('target.id_company', $this->id_company)
                            ->where('target.bulan', $explode[0])
                            ->where('target.tahun', $explode[1])
                            ->group_by('target.tahun, target.bulan')
                            ->get()
                            ->row();
                           
        return $result ? $result->total_target : 0;
    }

    private function _get_data_target_personil($id_karyawan = ""){
        return $this->db->select("
                sa.id_karyawan,
                dk.nik,
                dk.nama_lengkap AS nama_karyawan,
                sa.id_group_m,
                sgm.kode AS kode_group,
                sgm.nama AS nama_group
            ")
            ->from("sales_approver AS sa")
            ->join("data_karyawan AS dk", "dk.id_karyawan = sa.id_karyawan")
            ->join("sales_group_m AS sgm", "sgm.id_group_m = sa.id_group_m")
            ->where("sa.id_company", $this->id_company)
            ->where("sa.id_karyawan", $id_karyawan)
            ->get()
            ->row();
    }
}