<?php

function flag_map($flag)
{
    $data = [
        'flag_jht' => ['tunj_jht_perus', 'pot_jht_kry'],
        'flag_jkk' => ['tunj_jkk'],
        'flag_jp'  => ['tunj_jp_perus', 'pot_jp_kry'],
        'flag_jkm' => ['tunj_jkm']
    ];

    return $data[$flag];
}

function id_map_table($id)
{
    $data = [
        'gapok'     => 'payroll_gapok_m',
        'tunjtetap' => 'payroll_tunj_tetap_m',
        'pottetap'  => 'payroll_pot_tetap_m'
    ];

    return $data[$id];
}

function id_map_title($id)
{
    $data = [
        'gapok' => 'Gaji Pokok'
    ];

    return $data[$id];
}

if (!function_exists('cek_empty')) {
    function cek_empty($nominal)
    {
        if ($nominal == '') {
            return 0;
        } else {
            return $nominal;
        }
    }
}

/**
 * nominal proteksi jika flag_pot_absensi / flag_pph21 diikutsertakan hitungan potongan
 * berlaku untuk tunjangan tetap, tunjangan tidak tetap dan tunjangan kehadiran
 *
 * @param object $row => array data karyawan
 * @param mixed $komponen[id_karyawan] => array multidimensi / terkadang null
 * @param string $jenis_kehadiran => kehadiran / tetap / tidak tetap
 * @return array
 */
function nominal_pendapatan(object $row, $komponen, string $jenis_komponen): array
{
    $result = [];
    foreach ($komponen as $value) {
        $nominal = (int)$value['nominal'];
        $hadir   = 0;
        if ($jenis_komponen == 'kehadiran') {
            $hadir   = ($row->reguler + $row->shift);
            $nominal = ((int)$value['nominal'] * $hadir);
            if ($value['flag_cuti'] != '0') {
                $nominal += ((int)$value['nominal'] * $row->cuti);
                $hadir += $row->cuti;
            }
            if ($value['flag_izin'] != '0') {
                $nominal += ((int)$value['nominal'] * $row->izin);
                $hadir += $row->izin;
            }
            if ($value['flag_sakit'] != '0') {
                $nominal += ((int)$value['nominal'] * $row->sakit);
                $hadir += $row->sakit;
            }

            $result['update_kehadiran'][] = [
                'concat(id_company,id_karyawan,periode,id_item)' => $row->id_company . $row->id_karyawan . $row->periode . $value['id_item'],
                'ttl_kehadiran'                                  => $hadir,
                'ttl_tunjangan'                                  => ($hadir != 0 ? $nominal : 0)
            ];
        }

        if ($jenis_komponen != 'tidak tetap') {
            if ($value['flag_upah_lembur'] == '1') {
                $result['nominal_upah_lembur'][$value['id_item']] = $nominal;
            }
        }
        if ($value['flag_pot_absensi'] == '1') {
            $result['proteksi'][$value['id_item']] = $nominal;
        }
        if ($value['flag_pph21'] == '1') {
            $result['nominal_pph21'][$value['id_item']] = $nominal;
        }
        $result['total_pendapatan'][$value['id_item']] = $nominal;
    }

    return $result;
}

function nominal_potongan($komponen): array
{
    $result = [];
    foreach ($komponen as $value) {
        $nominal = (int)$value['nominal'];
        if ($value['flag_pph21'] == '1') {
            $result['nominal_pph21'][$value['id_item']] = $nominal;
        }
        $result['total_potongan'][$value['id_item']] = $nominal;
    }

    return $result;
}

function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) === $date;
}
