<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Master extends MY_Controller
{
    public function index(){
        $data['judul'] = 'Master';
        $this->load->view('sales_activity/master/index', $data);
    }

    public function tabs($tabs = null)
    {   
        switch ($tabs) {
            case "aktivitas" :
                $this->load->view('sales_activity/master/aktivitas/home');
                break;
            case "lead_source" :
                $this->load->view('sales_activity/master/lead_source/home');
                break;
            case "group_area" :
                $this->load->view('sales_activity/master/group_area/home');
                break;
            case "tahapan" :
                $this->load->model('sales_activity/master/Tahapan_m');
                $this->Tahapan_m->check_data_tahapan();

                $data['data'] = $this->Tahapan_m->list_data();
                $this->load->view('sales_activity/master/tahapan/home', $data);
                break;
            case "group_product" :
                $this->load->view('sales_activity/master/group_product/home');
                break;
            case "product" :
                $this->load->view('sales_activity/master/product/home');
                break;
            case "jenis_perusahaan" :
                $this->load->view('sales_activity/master/jenis_perusahaan/home');
                break;
            case "jenis_perorangan" :
                $this->load->view('sales_activity/master/jenis_perorangan/home');
                break;
            default:
                echo $this->lang->line('data_tidak_ditemukan');
        }
    }

    public function dropdown_group_area($opsi_all = "no")
    {
        $search = $this->input->get("q");

        $this->db->select('id_group_m, kode, nama');
        $this->db->where('id_company', $this->id_company);

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        $this->db->group_start();
        $this->db->like('nama', $search);
        $this->db->or_like('kode', $search);
        $this->db->group_end();
        $this->db->order_by('nama', 'ASC');
        $result = $this->db->get('sales_group_m')->result();

        if($opsi_all == "yes"){
            $json[] = ['id'=>'all', 'text'=>'Semua Group'];
        }else{
            $json = [];
        }

        foreach ($result as $rows) {
            $json[] = [ 'id' => $rows->id_group_m, 
                        'text' => $rows->kode . " - " . $rows->nama,
                        'nama_group' => $rows->kode . " - " . $rows->nama,
                    ];
        }
        echo json_encode($json);
    }
}
