<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Download_pph_uu24_cortax_bpmp extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/laporan_pph/Laporan_pph_uu24_m', 'model');
        $this->load->helper(['payroll', 'download']);
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel'));
    }

    /**
     * Download laporan PPh21 excel format cortax
     *
     * @param mixed $periode => jika tahunan mengabaikan periode
     * @param mixed $cabang
     * @param mixed $departemen
     * @param mixed $karyawan
     * @return void
     */
    public function download_excel($periode = "00-0000", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        // Load plugin PHPExcel nya
        include APPPATH . 'third_party/PHPExcel/PHPExcel.php';

        $periode             = $this->periode($periode);
        list($tahun, $bulan) = explode('-', $periode);

        // FILENAME
        if ($karyawan != "all") {
            $nama_karyawan = $this->model->nama_karyawan($karyawan);
            $filename      = "Data PPh21 " . $bulan . " " . $nama_karyawan;
        } else {
            if ($departemen != "all") {
                $nama_cab = $this->model->nama_cabang($cabang);
                $nama_dep = $this->model->nama_departemen($departemen);
                $nama     = "Data PPh21 " . $bulan . " Cabang " . $nama_cab . " Departemen " . str_replace("/", "-", $nama_dep);
                $filename = $nama;
            } else {
                if ($cabang != "all") {
                    $nama     = $this->model->nama_cabang($cabang);
                    $filename = "Data PPh21 " . $bulan . " Cabang " . $nama . " Semua Departemen";
                } else {
                    $nama     = "Data PPh21 " . $bulan . " Semua Cabang";
                    $filename = $nama;
                }
            }
        }
        // data
        $data = $this->model->get_datatables($periode, $cabang, $departemen, $karyawan);

        // Panggil class PHPExcel nya
        $excel = new PHPExcel();

        // Settingan awal fil excel
        $excel->getProperties()
            ->setCreator('Absenku')
            ->setLastModifiedBy('Absenku')
            ->setTitle("Laporan PPH Absenku")
            ->setSubject("Laporan PPH")
            ->setDescription("Laporan PPH Absenku Profesioanal");

        // Create a new worksheet for tab coretax DATA
        $this->coretax_data($excel, $data, $periode);

        // Create a new worksheet for tab coretax BPMP
        $this->coretax_bpmp($excel);

        // Create a new worksheet for tab coretax REF
        $this->coretax_ref($excel);

        $excel->setActiveSheetIndex(0);

        // Proses file excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename=' . removeSpecialChar($filename) . '.xlsx'); // Set nama file excel nya
        header('Cache-Control: max-age=0');
        $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $write->save('php://output');
    }

    /**
     * worksheet for tab coretax DATA
     *
     * @param object $excel => library PHPExcel
     * @param object $data => data pph21
     * @param string $periode => YYYY-MM
     * @param integer $index => worksheet dimulai dari 0
     * @param string $title => Judul worksheet
     * @return void
     */
    private function coretax_data($excel, $data, $periode, $index = 0, $title = 'DATA')
    {
        $excel->setActiveSheetIndex($index);
        $sheet = $excel->getActiveSheet();
        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle($title);
        // set width
        $sheet->getColumnDimension('A')->setWidth(20);
        $sheet->getColumnDimension('B')->setWidth(17);
        $sheet->getColumnDimension('C')->setWidth(14);
        $sheet->getColumnDimension('D')->setWidth(16);
        $sheet->getColumnDimension('E')->setWidth(25);
        $sheet->getColumnDimension('F')->setWidth(17);
        $sheet->getColumnDimension('G')->setWidth(8);
        $sheet->getColumnDimension('H')->setAutoSize(true);
        $sheet->getColumnDimension('I')->setWidth(19);
        $sheet->getColumnDimension('J')->setWidth(19);
        $sheet->getColumnDimension('K')->setWidth(19);
        $sheet->getColumnDimension('L')->setWidth(7);
        $sheet->getColumnDimension('M')->setWidth(24);
        $sheet->getColumnDimension('N')->setWidth(17);
        $sheet->getColumnDimension('O')->setWidth(10);
        $sheet->getColumnDimension('P')->setWidth(10);
        $sheet->getColumnDimension('Q')->setWidth(10);
        $sheet->getColumnDimension('R')->setWidth(10);

        // set value header
        $sheet->setCellValue('A1', 'NPWP Pemotong');
        $sheet->setCellValue('B4', 'Masa Pajak');
        $sheet->setCellValue('C4', 'Tahun Pajak');
        $sheet->setCellValue('D4', 'Status Pegawai');
        $sheet->setCellValue('E4', 'NPWP/NIK/TIN');
        $sheet->setCellValue('F4', 'Nomor Passport');
        $sheet->setCellValue('G4', 'Status');
        $sheet->setCellValue('H4', 'Posisi');
        $sheet->setCellValue('I4', 'Sertifikat/Fasilitas');
        $sheet->setCellValue('J4', 'Kode Objek Pajak');
        $sheet->setCellValue('K4', 'Penghasilan Kotor');
        $sheet->setCellValue('L4', 'Tarif');
        $sheet->setCellValue('M4', 'ID TKU');
        $sheet->setCellValue('N4', 'Tgl Pemotongan');
        $sheet->setCellValue('P4', 'TER A');
        $sheet->setCellValue('Q4', 'TER B');
        $sheet->setCellValue('R4', 'TER C');

        // set value with data
        list($tahun, $bulan) = explode('-', $periode);
        $pengaturan_pph      = $this->model->get_pengaturan_pph($periode);

        $sheet->setCellValueExplicit('B1', $pengaturan_pph->npwp);
        $row = 5;
        foreach ($data as $value) {
            $sheet->setCellValueExplicit('B' . $row, $bulan, PHPExcel_Cell_DataType::TYPE_NUMERIC);
            $sheet->setCellValue('C' . $row, $tahun);
            $sheet->setCellValue('D' . $row, $value->status_karyawan);
            $sheet->setCellValueExplicit('E' . $row, $value->no_ktp);
            $sheet->setCellValue('G' . $row, $value->kd_ptkp);
            $sheet->setCellValue('H' . $row, $value->nm_jabatan);
            $sheet->setCellValueExplicit('I' . $row, $value->fasilitas == 'N' ? 'N/A' : $value->fasilitas);
            $sheet->setCellValueExplicit('J' . $row, $value->kd_objek_pajak);
            $sheet->setCellValueExplicit('K' . $row, $value->gaji_bruto, PHPExcel_Cell_DataType::TYPE_NUMERIC);
            $sheet->setCellValue('L' . $row, '=IF(OR(G' . $row . '="TK/0",G' . $row . '="TK/1",G' . $row . '="K/0",G' . $row . '="HB/0",G' . $row . '="HB/1"),P' . $row . ',IF(OR(G' . $row . '="TK/2",G' . $row . '="TK/3",G' . $row . '="K/1",G' . $row . '="K/2",G' . $row . '="HB/2",G' . $row . '="HB/3"),Q' . $row . ',R' . $row . '))');
            $sheet->setCellValueExplicit('M' . $row, $value->id_tku);
            $sheet->setCellValue('N' . $row, date('d/m/Y', strtotime($value->tgl_pemotongan)));
            // ter A, B, C
            $sheet->setCellValue('P' . $row, '=IF(K' . $row . '<=5400000,0,IF(AND(K' . $row . '>5400000,K' . $row . '<=5650000),0.25,IF(AND(K' . $row . '>5650000,K' . $row . '<=5950000),0.5,IF(AND(K' . $row . '>5950000,K' . $row . '<=6300000),0.75,IF(AND(K' . $row . '>6300000,K' . $row . '<=6750000),1,IF(AND(K' . $row . '>6750000,K' . $row . '<=7500000),1.25,IF(AND(K' . $row . '>7500000,K' . $row . '<=8550000),1.5,IF(AND(K' . $row . '>8550000,K' . $row . '<=9650000),1.75,IF(AND(K' . $row . '>9650000,K' . $row . '<=10050000),2,IF(AND(K' . $row . '>10050000,K' . $row . '<=10350000),2.25,IF(AND(K' . $row . '>10350000,K' . $row . '<=10700000),2.5,IF(AND(K' . $row . '>10700000,K' . $row . '<=11050000),3,IF(AND(K' . $row . '>11050000,K' . $row . '<=11600000),3.5,IF(AND(K' . $row . '>11600000,K' . $row . '<=12500000),4,IF(AND(K' . $row . '>12500000,K' . $row . '<=13750000),5,IF(AND(K' . $row . '>13750000,K' . $row . '<=15100000),6,IF(AND(K' . $row . '>15100000,K' . $row . '<=16950000),7,IF(AND(K' . $row . '>16950000,K' . $row . '<=19750000),8,IF(AND(K' . $row . '>19750000,K' . $row . '<=24150000),9,IF(AND(K' . $row . '>24150000,K' . $row . '<=26450000),10,IF(AND(K' . $row . '>26450000,K' . $row . '<=28000000),11,IF(AND(K' . $row . '>28000000,K' . $row . '<=30050000),12,IF(AND(K' . $row . '>30050000,K' . $row . '<=32400000),13,IF(AND(K' . $row . '>32400000,K' . $row . '<=35400000),14,IF(AND(K' . $row . '>35400000,K' . $row . '<=39100000),15,IF(AND(K' . $row . '>39100000,K' . $row . '<=43850000),16,IF(AND(K' . $row . '>43850000,K' . $row . '<=47800000),17,IF(AND(K' . $row . '>47800000,K' . $row . '<=51400000),18,IF(AND(K' . $row . '>51400000,K' . $row . '<=56300000),19,IF(AND(K' . $row . '>56300000,K' . $row . '<=62200000),20,IF(AND(K' . $row . '>62200000,K' . $row . '<=68600000),21,IF(AND(K' . $row . '>68600000,K' . $row . '<=77500000),22,IF(AND(K' . $row . '>77500000,K' . $row . '<=89000000),23,IF(AND(K' . $row . '>89000000,K' . $row . '<=103000000),24,IF(AND(K' . $row . '>103000000,K' . $row . '<=125000000),25,IF(AND(K' . $row . '>125000000,K' . $row . '<=157000000),26,IF(AND(K' . $row . '>157000000,K' . $row . '<=206000000),27,IF(AND(K' . $row . '>206000000,K' . $row . '<=337000000),28,IF(AND(K' . $row . '>337000000,K' . $row . '<=454000000),29,IF(AND(K' . $row . '>454000000,K' . $row . '<=550000000),30,IF(AND(K' . $row . '>550000000,K' . $row . '<=695000000),31,IF(AND(K' . $row . '>695000000,K' . $row . '<=910000000),32,IF(AND(K' . $row . '>910000000,K' . $row . '<=1400000000),33,34)))))))))))))))))))))))))))))))))))))))))))');
            $sheet->setCellValue('Q' . $row, '=IF(K' . $row . '<=6200000,0,IF(AND(K' . $row . '>6200000,K' . $row . '<=6500000),0.25,IF(AND(K' . $row . '>6500000,K' . $row . '<=6850000),0.5,IF(AND(K' . $row . '>6850000,K' . $row . '<=7300000),0.75,IF(AND(K' . $row . '>7300000,K' . $row . '<=9200000),1,IF(AND(K' . $row . '>9200000,K' . $row . '<=10750000),1.5,IF(AND(K' . $row . '>10750000,K' . $row . '<=11250000),2,IF(AND(K' . $row . '>11250000,K' . $row . '<=11600000),2.5,IF(AND(K' . $row . '>11600000,K' . $row . '<=12600000),3,IF(AND(K' . $row . '>12600000,K' . $row . '<=13600000),4,IF(AND(K' . $row . '>13600000,K' . $row . '<=14950000),5,IF(AND(K' . $row . '>14950000,K' . $row . '<=16400000),6,IF(AND(K' . $row . '>16400000,K' . $row . '<=18450000),7,IF(AND(K' . $row . '>18450000,K' . $row . '<=21850000),8,IF(AND(K' . $row . '>21850000,K' . $row . '<=26000000),9,IF(AND(K' . $row . '>26000000,K' . $row . '<=27700000),10,IF(AND(K' . $row . '>27700000,K' . $row . '<=29350000),11,IF(AND(K' . $row . '>29350000,K' . $row . '<=31450000),12,IF(AND(K' . $row . '>31450000,K' . $row . '<=33950000),13,IF(AND(K' . $row . '>33950000,K' . $row . '<=37100000),14,IF(AND(K' . $row . '>37100000,K' . $row . '<=41100000),15,IF(AND(K' . $row . '>41100000,K' . $row . '<=45800000),16,IF(AND(K' . $row . '>45800000,K' . $row . '<=49500000),17,IF(AND(K' . $row . '>49500000,K' . $row . '<=53800000),18,IF(AND(K' . $row . '>53800000,K' . $row . '<=58500000),19,IF(AND(K' . $row . '>58500000,K' . $row . '<=64000000),20,IF(AND(K' . $row . '>64000000,K' . $row . '<=71000000),21,IF(AND(K' . $row . '>71000000,K' . $row . '<=80000000),22,IF(AND(K' . $row . '>80000000,K' . $row . '<=93000000),23,IF(AND(K' . $row . '>93000000,K' . $row . '<=109000000),24,IF(AND(K' . $row . '>109000000,K' . $row . '<=129000000),25,IF(AND(K' . $row . '>129000000,K' . $row . '<=163000000),26,IF(AND(K' . $row . '>163000000,K' . $row . '<=211000000),27,IF(AND(K' . $row . '>211000000,K' . $row . '<=374000000),28,IF(AND(K' . $row . '>374000000,K' . $row . '<=459000000),29,IF(AND(K' . $row . '>459000000,K' . $row . '<=555000000),30,IF(AND(K' . $row . '>555000000,K' . $row . '<=704000000),31,IF(AND(K' . $row . '>704000000,K' . $row . '<=957000000),32,IF(AND(K' . $row . '>957000000,K' . $row . '<=1405000000),33,34)))))))))))))))))))))))))))))))))))))))');
            $sheet->setCellValue('R' . $row, '=IF(K' . $row . '<=6600000,0,IF(AND(K' . $row . '>6600000,K' . $row . '<=6950000),0.25,IF(AND(K' . $row . '>6950000,K' . $row . '<=7350000),0.5,IF(AND(K' . $row . '>7350000,K' . $row . '<=7800000),0.75,IF(AND(K' . $row . '>7800000,K' . $row . '<=8850000),1,IF(AND(K' . $row . '>8850000,K' . $row . '<=9800000),1.25,IF(AND(K' . $row . '>9800000,K' . $row . '<=10950000),1.5,IF(AND(K' . $row . '>10950000,K' . $row . '<=11200000),1.75,IF(AND(K' . $row . '>11200000,K' . $row . '<=12050000),2,IF(AND(K' . $row . '>12050000,K' . $row . '<=12950000),3,IF(AND(K' . $row . '>12950000,K' . $row . '<=14150000),4,IF(AND(K' . $row . '>14150000,K' . $row . '<=15550000),5,IF(AND(K' . $row . '>15550000,K' . $row . '<=17050000),6,IF(AND(K' . $row . '>17050000,K' . $row . '<=19500000),7,IF(AND(K' . $row . '>19500000,K' . $row . '<=22700000),8,IF(AND(K' . $row . '>22700000,K' . $row . '<=26600000),9,IF(AND(K' . $row . '>26600000,K' . $row . '<=28100000),10,IF(AND(K' . $row . '>28100000,K' . $row . '<=30100000),11,IF(AND(K' . $row . '>30100000,K' . $row . '<=32600000),12,IF(AND(K' . $row . '>32600000,K' . $row . '<=35400000),13,IF(AND(K' . $row . '>35400000,K' . $row . '<=38900000),14,IF(AND(K' . $row . '>38900000,K' . $row . '<=43000000),15,IF(AND(K' . $row . '>43000000,K' . $row . '<=47400000),16,IF(AND(K' . $row . '>47400000,K' . $row . '<=51200000),17,IF(AND(K' . $row . '>51200000,K' . $row . '<=55800000),18,IF(AND(K' . $row . '>55800000,K' . $row . '<=60400000),19,IF(AND(K' . $row . '>60400000,K' . $row . '<=66700000),20,IF(AND(K' . $row . '>66700000,K' . $row . '<=74500000),21,IF(AND(K' . $row . '>74500000,K' . $row . '<=83200000),22,IF(AND(K' . $row . '>83200000,K' . $row . '<=95600000),23,IF(AND(K' . $row . '>95600000,K' . $row . '<=110000000),24,IF(AND(K' . $row . '>110000000,K' . $row . '<=134000000),25,IF(AND(K' . $row . '>134000000,K' . $row . '<=169000000),26,IF(AND(K' . $row . '>169000000,K' . $row . '<=221000000),27,IF(AND(K' . $row . '>221000000,K' . $row . '<=390000000),28,IF(AND(K' . $row . '>390000000,K' . $row . '<=463000000),29,IF(AND(K' . $row . '>463000000,K' . $row . '<=561000000),30,IF(AND(K' . $row . '>561000000,K' . $row . '<=709000000),31,IF(AND(K' . $row . '>709000000,K' . $row . '<=965000000),32,IF(AND(K' . $row . '>965000000,K' . $row . '<=1419000000),33,34))))))))))))))))))))))))))))))))))))))))');

            $row++;
        }

        // Tambahkan format style tabel dengan warna biru medium
        $blue_medium = '4472C4';
        $this->setCellBackgroundColor($sheet, 'B4:N4', $blue_medium);
        $sheet->getStyle('B4:N4')->getFont()->setBold(true);
        $sheet->getStyle('B4:N4')->getFont()->setColor(new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_WHITE));

        // Tambahkan border untuk seluruh data
        $lastRow = $row - 1; // Baris terakhir data
        $sheet->getStyle('B5:N' . $lastRow)->applyFromArray(array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => '8EA9DB')
                )
            )
        ));

        // Tambahkan zebra striping (selang-seling warna baris)
        $light_blue = 'D9E1F2'; // Warna biru muda
        for ($i = 5; $i <= $lastRow; $i += 2) {
            $this->setCellBackgroundColor($sheet, 'B' . $i . ':N' . $i, $light_blue);
        }

        // Tambahkan format style tabel dengan warna biru medium
        $blue_medium = '4472C4'; // Warna biru medium
        $this->setCellBackgroundColor($sheet, 'B4:N4', $blue_medium);
        $sheet->getStyle('B4:N4')->getFont()->setBold(true);
        $sheet->getStyle('B4:N4')->getFont()->setColor(new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_WHITE));

        // Set alignment
        $sheet->getStyle('A1:B1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('B5:C' . $lastRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $sheet->getStyle('D5:J' . $lastRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('K5:L' . $lastRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $sheet->getStyle('M5:M' . $lastRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('N5:R' . $lastRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    }

    /**
     * worksheet for tab coretax BPMP
     *
     * @param object $excel => library PHPExcel
     * @return void
     */
    private function coretax_bpmp($excel)
    {
        $excel->createSheet();
        $excel->setActiveSheetIndex(1);
        $sheet = $excel->getActiveSheet();
        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle("BPMP");
        // set width
        $sheet->getColumnDimension('A')->setAutoSize(true);
        $sheet->getColumnDimension('B')->setAutoSize(true);
        $sheet->getColumnDimension('C')->setAutoSize(true);
        $sheet->getColumnDimension('D')->setAutoSize(true);
        $sheet->getColumnDimension('E')->setAutoSize(true);
        $sheet->getColumnDimension('F')->setAutoSize(true);
        // set styles
        $sheet->getStyle('A1:F1')->getFont()->setBold(true);
        $sheet->getStyle('A2:C15')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('D2:D15')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $sheet->getStyle('E2:F15')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        // set value header
        $sheet->setCellValue('A1', 'Kolom pada excel');
        $sheet->setCellValue('B1', 'Kolom pada xml');
        $sheet->setCellValue('C1', 'Petunjuk pengisian');
        $sheet->setCellValue('D1', 'Contoh pengisian');
        $sheet->setCellValue('E1', 'Validasi');
        $sheet->setCellValue('F1', 'Keterangan tambahan');

        // set value with data
        $sheet->setCellValue('A2', 'NPWP Pemotong');
        $sheet->setCellValue('A3', 'Masa Pajak');
        $sheet->setCellValue('A4', 'Tahun Pajak');
        $sheet->setCellValue('A5', 'Status Pegawai');
        $sheet->setCellValue('A6', 'NPWP/NIK/TIN');
        $sheet->setCellValue('A7', 'Nomor Passport');
        $sheet->setCellValue('A8', 'Status');
        $sheet->setCellValue('A9', 'Posisi');
        $sheet->setCellValue('A10', 'Sertifikat/Fasilitas');
        $sheet->setCellValue('A11', 'Kode Objek Pajak');
        $sheet->setCellValue('A12', 'Penghasilan Kotor');
        $sheet->setCellValue('A13', 'Tarif');
        $sheet->setCellValue('A14', 'ID TKU');
        $sheet->setCellValue('A15', 'Tgl Pemotongan');

        $sheet->setCellValue('B2', 'TIN');
        $sheet->setCellValue('B3', 'TaxPeriodMonth');
        $sheet->setCellValue('B4', 'TaxPeriodYear');
        $sheet->setCellValue('B5', 'CounterpartOpt');
        $sheet->setCellValue('B6', 'CounterpartTin');
        $sheet->setCellValue('B7', 'CounterpartPassport');
        $sheet->setCellValue('B8', 'StatusTaxExemption');
        $sheet->setCellValue('B9', 'Position');
        $sheet->setCellValue('B10', 'TaxCertificate');
        $sheet->setCellValue('B11', 'TaxObjectCode');
        $sheet->setCellValue('B12', 'Gross');
        $sheet->setCellValue('B13', 'Rate');
        $sheet->setCellValue('B14', 'IDPlaceOfBusinessActivity');
        $sheet->setCellValue('B15', 'WithholdingDate');

        $sheet->setCellValue('C2', 'Diisi dengan NPWP pemotong');
        $sheet->setCellValue('C3', 'Diisi dengan masa pajak pemotongan');
        $sheet->setCellValue('C4', 'Diisi dengan masa pajak pemotongan');
        $sheet->setCellValue('C5', 'Diisi dengan status kewarganegaraan pegawai (karyawan asing atau tidak)');
        $sheet->setCellValue('C6', 'Diisi dengan NIK pegawai tetap');
        $sheet->setCellValue('C7', 'Diisi dengan nomor paspor pegawai tetap (jika karyawan asing)');
        $sheet->setCellValue('C8', 'Diisi dengan status PTKP penerima penghasilan');
        $sheet->setCellValue('C9', 'Diisi dengan posisi pegawai tetap');
        $sheet->setCellValue('C10', 'Diisi dengan fasilitas perpajakan yang digunakan');
        $sheet->setCellValue('C11', 'Diisi dengan kode objek pajak');
        $sheet->setCellValue('C12', 'Diisi dengan penghasilan bruto');
        $sheet->setCellValue('C13', 'Diisi dengan tarif yang sesuai dengan referensi kode objek pajak');
        $sheet->setCellValue('C14', 'Diisi dengan ID TKU pemotong');
        $sheet->setCellValue('C15', 'Diisi dengan tanggal pemotongan');

        $sheet->setCellValueExplicit('D2', '1234567890123456');
        $sheet->setCellValueExplicit('D3', '1');
        $sheet->setCellValueExplicit('D4', '2025');
        $sheet->setCellValueExplicit('D5', 'Resident');
        $sheet->setCellValueExplicit('D6', '0987654321098765');
        $sheet->setCellValueExplicit('D7', '');
        $sheet->setCellValueExplicit('D8', 'TK/3');
        $sheet->setCellValueExplicit('D9', 'Staff');
        $sheet->setCellValueExplicit('D10', 'N/A');
        $sheet->setCellValueExplicit('D11', '21-100-01');
        $sheet->setCellValueExplicit('D12', '10000000');
        $sheet->setCellValueExplicit('D13', '2');
        $sheet->setCellValueExplicit('D14', '1234567890123456789012');
        $sheet->setCellValueExplicit('D15', '16/01/2025');

        $sheet->setCellValue('E2', 'NPWP Pemotong harus sama dengan NPWP login');
        $sheet->setCellValue('E3', '');
        $sheet->setCellValue('E4', '');
        $sheet->setCellValue('E5', '');
        $sheet->setCellValue('E6', 'NPWP/NIK wajib valid');
        $sheet->setCellValue('E7', '');
        $sheet->setCellValue('E8', '');
        $sheet->setCellValue('E9', '');
        $sheet->setCellValue('E10', '');
        $sheet->setCellValue('E11', '');
        $sheet->setCellValue('E12', '');
        $sheet->setCellValue('E13', 'Jika menggunakan fasilitas perpajakan lainnya, tarif dapat diisi tidak sesuai dengan referensi kode objek pajak');
        $sheet->setCellValue('E14', '');
        $sheet->setCellValue('E15', 'Tanggal pemotongan tidak boleh lebih rendah dari masa/tahun pajak bukti potong');

        $sheet->setCellValue('F2', '');
        $sheet->setCellValue('F3', '');
        $sheet->setCellValue('F4', '');
        $sheet->setCellValue('F5', '');
        $sheet->setCellValue('F6', '');
        $sheet->setCellValue('F7', '');
        $sheet->setCellValue('F8', '');
        $sheet->setCellValue('F9', '');
        $sheet->setCellValue('F10', '');
        $sheet->setCellValue('F11', '');
        $sheet->setCellValue('F12', '');
        $sheet->setCellValue('F13', 'Jika tarif menggunakan koma, di export ke xml, excel secara otomatis akan merubah menjadi format desimal menggunakan titik');
        $sheet->setCellValue('F14', '');
        $sheet->setCellValue('F15', 'Saat di export ke xml, excel secara otomatis akan merubah menjadi format YYYY-MM-DD');
    }

    /**
     * worksheet for tab coretax REF
     *
     * @param object $excel => library PHPExcel
     * @return void
     */
    private function coretax_ref($excel)
    {
        $excel->createSheet();
        $excel->setActiveSheetIndex(2);
        $sheet = $excel->getActiveSheet();
        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle("REF");
        // set width
        $sheet->getColumnDimension('A')->setWidth(9);
        $sheet->getColumnDimension('B')->setWidth(9);
        $sheet->getColumnDimension('C')->setWidth(9);
        $sheet->getColumnDimension('D')->setWidth(9);
        $sheet->getColumnDimension('E')->setWidth(9);
        $sheet->getColumnDimension('F')->setAutoSize(true);
        $sheet->getColumnDimension('G')->setAutoSize(true);
        // set styles
        $sheet->getStyle('A1:G13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        // set value header
        $sheet->setCellValue('F1', 'Kode Objek Pajak');
        $sheet->setCellValue('G1', 'Nama Objek Pajak');

        // set value with data
        $sheet->setCellValue('B2', 'Resident');
        $sheet->setCellValue('B3', 'Foreign');

        $sheet->setCellValue('C2', 'TK/0');
        $sheet->setCellValue('C3', 'TK/1');
        $sheet->setCellValue('C4', 'TK/2');
        $sheet->setCellValue('C5', 'TK/3');
        $sheet->setCellValue('C6', 'K/0');
        $sheet->setCellValue('C7', 'K/1');
        $sheet->setCellValue('C8', 'K/2');
        $sheet->setCellValue('C9', 'K/3');
        $sheet->setCellValue('C10', 'HB/0');
        $sheet->setCellValue('C11', 'HB/1');
        $sheet->setCellValue('C12', 'HB/2');
        $sheet->setCellValue('C13', 'HB/3');

        $sheet->setCellValue('D2', 'N/A');
        $sheet->setCellValue('D3', 'DTP');
        $sheet->setCellValue('D4', 'ETC');

        $sheet->setCellValueExplicit('F2', '21-100-01');
        $sheet->setCellValueExplicit('F3', '21-100-02');
        $sheet->setCellValueExplicit('F4', '21-100-32');

        $sheet->setCellValue('G2', 'Penghasilan yang diterima oleh Pegawai Tetap termasuk Pegawai Negeri Sipil, Anggota Tentara Nasional Indonesia, Anggota Polisi Republik Indonesia atau Pejabat Negara');
        $sheet->setCellValue('G3', 'Penghasilan yang diterima oleh Penerima Pensiun secara  teratur');
        $sheet->setCellValue('G4', 'Penghasilan yang diterima oleh Pegawai tetap yang menerima fasilitas di daerah tertentu');
    }

    /**
     * set cells background color
     *
     * @param object $sheet => active sheet
     * @param string $cell => ex: A1 or A1:H1
     * @param string $color => ex: FF0000
     * @return void
     */
    private function setCellBackgroundColor($sheet, $cell, $color)
    {
        $sheet->getStyle($cell)
            ->getFill()
            ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
            ->getStartColor()
            ->setRGB($color);
    }

    private function periode($bulan)
    {
        return date_format(date_create("01-" . $bulan), "Y-m");
    }
}
