<script type="text/javascript">
    $(function() {
        loading('#myTabContent');
        $("#modal_form .modal-dialog").removeClass("modal-lg");

        // set padding-top to content-wrapper
        $(".content-wrapper").css("padding-top", "20px");

        if (localStorage.getItem("sales-activity-tab-menu") != null) {
            let thisTab = document.getElementById(localStorage.getItem("sales-activity-tab-menu"));
            if (!thisTab) {
                thisTab = document.querySelector('.tab_menu a');
            }
            thisTab.closest('li').click();
            thisTab.classList.add("active");
        } else {
            const thisTab = document.querySelector('.tab_menu a');
            thisTab.closest('li').click();
            thisTab.classList.add("active");
        }

        $('.tab_menu li a').click(function() {
            $('.tab_menu li a').removeClass("active");
            $(this).addClass("active");
        });
    });

    function select_tab_menu(e) {
        loading('#myTabContent');
        switch (e.attr("id")) {
            case "tab_dashboard":
                $("#myTabContent").load("<?= route('sales_activity.dashboard.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_dashboard");
                break;

            case "tab_master":
                $("#myTabContent").load("<?= route('sales_activity.master.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_master");
                var loc_storage_m = localStorage.getItem('sales-activity-tab-master');
                if (loc_storage_m == null) {
                    localStorage.setItem("sales-activity-tab-master", "tahapan");
                }
                break;

            case "tab_pengaturan":
                $("#myTabContent").load("<?= route('sales_activity.pengaturan.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_pengaturan");
                var loc_storage_p = localStorage.getItem('sales-activity-tab-pengaturan');
                if (loc_storage_p == null) {
                    localStorage.setItem("sales-activity-tab-pengaturan", "admin_sales");
                }
                break;

            case "tab_kanban":
                $("#myTabContent").load("<?= route('sales_activity.kanban.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_kanban");
                break;

            case "tab_daily_activity":
                $("#myTabContent").load("<?= route('sales_activity.daily_activity.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_daily_activity");
                break;

            case "tab_approval_activity":
                $("#myTabContent").load("<?= route('sales_activity.approval_activity.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_approval_activity");
                break;

            case "tab_report":
                $("#myTabContent").load("<?= route('sales_activity.report.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_report");
                var loc_storage_r = localStorage.getItem('sales-activity-tab-report');
                if (loc_storage_r == null) {
                    localStorage.setItem("sales-activity-tab-report", "data_sales");
                }
                break;

            case "tab_demografi_pelanggan":
                $("#myTabContent").load("<?= route('sales_activity.demografi.pelanggan.home') ?>");
                localStorage.setItem("sales-activity-tab-menu", "tab_demografi_pelanggan");
                var loc_storage_r = localStorage.getItem('sales-activity-tab-demografi');
                if (loc_storage_r == null) {
                    localStorage.setItem("sales-activity-demografi", "demografi_pelanggan");
                }
                break;

            default:
                $("#myTabContent").html("Halaman Dashboard");
                localStorage.setItem("sales-activity-tab-menu", "tab_dashboard");
                break;
        }
    }

    function loading(id) {
        $(id).html('<div class="modal-body"><div class="text-center"><div class="custom-lds-ring"><div></div><div></div><div></div></div></div></div>');
    }

    function screenUp(y) {
        window.scroll({
            top: y,
            left: 0,
            behavior: 'smooth'
        });
    }

    function downloadChartImage(filename, chart, buttonElement = '') {
        let laddaInstance;
        if (buttonElement !== '') {
            laddaInstance = Ladda.create(buttonElement);
            laddaInstance.start();
        }

        const canvas = chart.canvas;
        const tempCanvas = document.createElement('canvas');
        const tempCtx = tempCanvas.getContext('2d');
        tempCanvas.width = canvas.width;
        tempCanvas.height = canvas.height;

        tempCtx.fillStyle = '#FFFFFF';
        tempCtx.fillRect(0, 0, tempCanvas.width, tempCanvas.height);
        tempCtx.drawImage(canvas, 0, 0);

        if (tempCanvas.toBlob) {
            tempCanvas.toBlob(blob => saveBlobAsImage(blob), 'image/jpeg');
        } else {
            // Fallback for browsers that do not support toBlob
            const dataUrl = tempCanvas.toDataURL('image/jpeg');
            const blob = dataURLToBlob(dataUrl);
            saveBlobAsImage(blob);
        }

        function saveBlobAsImage(blob) {
            const url = URL.createObjectURL(blob);
            const link = document.createElement('a');
            link.href = url;
            link.download = filename + '.jpg';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            URL.revokeObjectURL(url);

            if (laddaInstance) {
                setTimeout(() => laddaInstance.stop(), 500);
            }
        }

        function dataURLToBlob(dataUrl) {
            const byteString = atob(dataUrl.split(',')[1]);
            const mimeString = dataUrl.split(',')[0].split(':')[1].split(';')[0];
            const ab = new ArrayBuffer(byteString.length);
            const ia = new Uint8Array(ab);
            for (let i = 0; i < byteString.length; i++) {
                ia[i] = byteString.charCodeAt(i);
            }
            return new Blob([ab], {
                type: mimeString
            });
        }
    }

    function get_target_poin_harian_bulanan_karyawan(){
        $.ajax({
            type: 'GET',
            url: '<?= route("sales_activity.get_target.harian_bulanan") ?>',
            dataType: 'json',
            success: function(result){
                var target_poin_harian  = result.poin_harian.realisasi + " / " + result.poin_harian.target;
                var target_poin_bulanan = result.poin_bulanan.realisasi + " / " + result.poin_bulanan.target;

                $(".target_poin_per_karyawan #target_poin_harian").html(target_poin_harian);
                $(".target_poin_per_karyawan #target_poin_bulanan").html(target_poin_bulanan);
            }
        })
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($this->level_user === '1' || $this->is_sales === true || $this->is_sales_atasan === true || $this->is_sales_admin === true) : ?>
    <div class="row match-height">
        <div class="col-xl-12 col-lg-12">
            <div class="card card-rounded card-detail-karyawan">
                <div class="card-content">
                    <div class="card-body p-custom">
                        <div class="nav-vertical row">
                            <div class="col-md-2 border-kanan">
                                <ul class="tab_menu nav nav-tabs nav-left flex-column">
                                    <?php if ($this->is_sales_admin === true || $this->level_user == '1') : ?>
                                        <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                            <a id="tab_dashboard" class="nav-link" aria-expanded="false">
                                                Dashboard
                                            </a>
                                        </li>
                                        <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                            <a id="tab_master" class="nav-link" aria-expanded="false">
                                                Master
                                            </a>
                                        </li>
                                        <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                            <a id="tab_pengaturan" class="nav-link" aria-expanded="false">
                                                <?= $this->lang->line('menu_pengaturan') ?>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                        <a id="tab_kanban" class="nav-link" aria-expanded="false">
                                            Kanban Board
                                        </a>
                                    </li>
                                    <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                        <a id="tab_daily_activity" class="nav-link" aria-expanded="false">
                                            Daily Activity
                                        </a>
                                    </li>

                                    <?php if ($this->is_sales_admin === true || $this->level_user == '1' || $this->is_sales_atasan === true) : ?>
                                        <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                            <a id="tab_approval_activity" class="nav-link" aria-expanded="false">
                                                Approval Activity
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if ($this->is_sales_admin === true || $this->level_user == '1') : ?>
                                        <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                            <a id="tab_report" class="nav-link" aria-expanded="false">
                                                Report
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if ($this->is_sales_admin === true || $this->level_user == '1') : ?>
                                        <li class="nav-item" onclick="select_tab_menu($(this).find('a'))">
                                            <a id="tab_demografi_pelanggan" class="nav-link" aria-expanded="false">
                                                Demografi Pelanggan
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="col-md-10" style="padding: 20px;">
                                <div id="myTabContent" class="tab-content">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <?php redirect(route('page.not.found')); ?>
<?php endif; ?>

<?php
    // Script Js Master
    include "master/aktivitas/js.php";
    include "master/lead_source/js.php";
    include "master/tahapan/js.php";
    include "master/group_product/js.php";
    include "master/product/js.php";
    include "master/jenis_perusahaan/js.php";
?>
