<script type="text/javascript">
    $(document).ready(function() {
        lockLokasi();

        $("#username, #password_baru").on({
            keydown: function(e) {
                if (e.which === 32)
                    return false;
            },
            keyup: function(){
                this.value = this.value.replace(/\s/g, "");
            }
        });

        $('#id_lokasi').select2({
            placeholder: 'Semua Lokasi',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.lokasiabsensi") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
        
    });

    function lockLokasi() {
        var lock_lokasi = $('#lock_lokasi').val();
        if (lock_lokasi != '0') {
            $(".row_lokasi").show();
        }else{
            $(".row_lokasi").hide();
        }
    }
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_karyawan" class="form-control" value="<?= ((isset($data_user))?md5($data_user->id_karyawan):'') ?>">
    <input type="hidden" id="id_user" class="form-control" value="<?= ((isset($data_user))?md5($data_user->id_user):'') ?>">

    <div class="row form-group">
        <div class="col-md-12">
            <label>Username <i class="text-danger">*</i></label>
            <input type="text" id="username" class="form-control" value="<?= ((isset($data_user))?$data_user->username:'') ?>">
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-12">
            <label>Password Baru</label>
            <input type="text" id="password_baru" class="form-control">
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-12">
            <label>Lock Face Recognition <i class="text-danger">*</i></label><br>
            <select id="lock_facerecognition" class="form-control">
                <option value="0" <?= ((isset($data_user) AND $data_user->lock_facerecognition == '0')?'selected':'') ?>>Tidak</option>
                <option value="1" <?= ((isset($data_user) AND $data_user->lock_facerecognition == '1')?'selected':'') ?>>Ya</option>
            </select>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-12">
            <label>Lock Device <i class="text-danger">*</i></label><br>
            <select id="lock_device" class="form-control">
                <option value="0" <?= ((isset($data_user) AND $data_user->lock_device == '0')?'selected':'') ?>>Tidak</option>
                <option value="1" <?= ((isset($data_user) AND $data_user->lock_device == '1')?'selected':'') ?>>Ya</option>
            </select>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-md-12">
            <label>Lock Lokasi Absensi <i class="text-danger">*</i></label><br>
            <select id="lock_lokasi" class="form-control" onchange="lockLokasi()">
                <option value="0" <?= ((isset($data_user) AND $data_user->lock_lokasi == '0')?'selected':'') ?>>Tidak</option>
                <option value="1" <?= ((isset($data_user) AND $data_user->lock_lokasi == '1')?'selected':'') ?>>Ya</option>
            </select>
        </div>
    </div>

    <div class="row form-group row_lokasi" style="display:none">
        <div class="col-md-12">
            <label>Lokasi Absensi</label>
            <select id="id_lokasi" name="id_lokasi[]" class="select2 form-control" multiple="multiple" style="width: 100%;">
                <?php
                    if(!empty($data_lokasi)){
                        foreach($data_lokasi as $rows){
                            echo '<option value="'.$rows->id_lokasi_kantor.'" selected>'.$rows->nama_kantor.'</option>';
                        }
                    }
                ?>
            </select>
        </div>
    </div>

</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button class="btn_save_akun btn btn-primary ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
