<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Detail_m extends CI_Model
{
    var $table = 'kpi_aspek_kepribadian_m';

    public function __construct()
    {
        parent::__construct();
    }

    function get_datatables($id_jabatan="")
    {
        $this->_get_datatables_query($id_jabatan);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($id_jabatan="")
    {
        $this->_get_datatables_query($id_jabatan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($id_jabatan="")
    {
        $this->_get_datatables_query($id_jabatan);
        $query = $this->db->get();
        return $query->num_rows();
    }
    private function _get_datatables_query($id_jabatan="")
    {
        $this->db->select("kakm.id_aspek_kepribadian_m,
                        kakm.personal_aspek,
                        kakm.keterangan,
                        kakm.bobot,
                        kakm.poin_1,
                        kakm.poin_2,
                        kakm.poin_3,
                        kakm.poin_4,
                        kakm.poin_5,
                        kakm.no_urut,
                        mj.id_jabatan,
                        mj.nama AS nama_jabatan")
                    ->from($this->table. ' AS kakm')
                    ->join('master_jabatan AS mj', 'mj.id_jabatan = kakm.id_jabatan')
                    ->where('kakm.id_company', $this->id_company);

        if(!empty($id_jabatan)){
            $this->db->where('kakm.id_jabatan', $id_jabatan);
        }

        // $column_order = array('', '', '');
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("kakm.no_urut" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id = null)
    {
        $select = $this->db->query("SELECT id_aspek_kepribadian_m,
                                        personal_aspek,
                                        keterangan,
                                        bobot,
                                        poin_1,
                                        poin_2,
                                        poin_3,
                                        poin_4,
                                        poin_5,
                                        no_urut
                                    FROM $this->table
                                    WHERE MD5(id_aspek_kepribadian_m) = '$id'
                                    AND id_company = '" . $this->id_company . "'")->row();
        return $select;
    }

    public function save($data, $id = null)
    {
        if ($id != null) {
            // PROSES UPDATE
            $this->db->select("personal_aspek");
            $this->db->from("kpi_aspek_kepribadian_m");
            $this->db->where("id_company", $this->id_company);
            $this->db->where("personal_aspek", $data['personal_aspek']);
            $this->db->where("id_jabatan", $data['id_jabatan']);
            $this->db->where("md5(id_aspek_kepribadian_m) !=", $id);
            $cek_kode = $this->db->get();

            if ($cek_kode->num_rows() > 0) {
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> Personal Aspek sudah ada </font>');
                return __response_update(false, $message);
            } else {
                $data['tgl_update']  = date("Y-m-d H:i:s");
                $data['user_update'] = $this->nik_karyawan. " - ". $this->nm_karyawan;

                $this->db->where(array('md5(id_aspek_kepribadian_m)' => $id, 'id_company' => $this->id_company));
                $update = $this->db->update($this->table, $data);
                $action = "update";
            }
        } else {
            // PROSES SAVE
            $this->db->select("personal_aspek");
            $this->db->from("kpi_aspek_kepribadian_m");
            $this->db->where("id_company", $this->id_company);
            $this->db->where("personal_aspek", $data['personal_aspek']);
            $this->db->where("id_jabatan", $data['id_jabatan']);
            $cek_kode = $this->db->get();

            if ($cek_kode->num_rows() > 0) {
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> Personal Aspek sudah ada </font>');
                return __response_save(false, $message);
            } else {
                $no_urut            =   $this->db->query("
                                                SELECT 
                                                    COALESCE(MAX(no_urut), 0) + 1 as no_urut
                                                FROM kpi_aspek_kepribadian_m 
                                                WHERE id_company = '$this->id_company'
                                                AND id_jabatan = '".$data['id_jabatan']."'
                                        ")->row()->no_urut;

                $data['no_urut']    = $no_urut;
                $data['user_input'] = $this->nik_karyawan. " - ". $this->nm_karyawan;

                $nextId = $this->fungsi->getNextId($this->table, 'id_aspek_kepribadian_m', $this->id_company, 3);
                $data['id_aspek_kepribadian_m'] =  $nextId;
                $save   = $this->db->insert($this->table, $data);
                $action = "save";
            }
        }


        $bobot = $this->getBobotById(MD5($data['id_jabatan']));
        $new_params = array(
            'new_params' => array(
                'bobot_pengaturan' => $bobot->bobot_pengaturan,
                'bobot_data'       => $bobot->bobot_data,
            ),
        );

        if($action == "update"){
            return  __response_update($update, $new_params);
        }else{
            return __response_save($save, $new_params);
        }

    }

    public function delete($id = null)
    {
        $this->db->where(array('md5(id_aspek_kepribadian_m)' => $id, 'id_company' => $this->id_company));
        $delete = $this->db->delete($this->table);

        if($delete){
            $message = '<font color=\"#009900\"><i class=\"fa fa-check-square\">&nbsp;</i>Data berhasil dihapus</font>';
        }else{
            $message = '<font color=\"#eb3a28\"><i class=\"fa fa-exclamation-triangle\">&nbsp;</i>Data gagal dihapus</font>';
        }

        $id_jabatan = $this->input->post('id_jabatan');
        $bobot      = $this->getBobotById(MD5($id_jabatan));
        $new_params = array(
            'message'          => $message,
            'bobot_pengaturan' => $bobot->bobot_pengaturan,
            'bobot_data'       => $bobot->bobot_data,
        );

        return __response_delete($delete, ["message" => $new_params]);
    }

    public function getBobotById($id=""){
        return $this->db->select("
                    mj.id_jabatan,
                    mj.kode_jabatan,
                    mj.nama AS nama_jabatan,
                    COALESCE (kebp.bobot_aspek_kepribadian, 0) AS bobot_pengaturan,
                    SUM(COALESCE(kapm.bobot, 0)) AS bobot_data
                ")
            ->from('master_jabatan AS mj')
            ->join('kpi_aspek_bobot_p AS kebp', 'mj.id_jabatan = kebp.id_jabatan', 'LEFT')
            ->join('kpi_aspek_kepribadian_m AS kapm', 'mj.id_jabatan = kapm.id_jabatan', 'LEFT')
            ->where("MD5(mj.id_jabatan)", $id)
            ->where("mj.id_company", $this->id_company)
            ->group_by('mj.id_jabatan')
            ->get()
            ->row();
    }
}
