<?php

class GenerateId {

    private $jenis, $tabel, $idTabel, $formatYm, $idCompany, $digit, $id, $prefixId, $digitId;
    private $jenisExisting = [
        'id_cuti_history', 
        'id_ulang_tahun', 
        'id_pengajuan_goal',
        'id_goal_pengembangan',
        'id_goal_uraian',
        'id_goal_sasaran',
        'id_log',
        'id_cabang',
        'id_pengajuan_ph',
        'id_saldo_ph',
        'id_holidays',
        'id_pi_trx',
        'id_aspek_kepribadian',
        'id_notif_kpi',
        'id_template'
    ];

    /* jika terdapat jenis baru, variabel jenisExisting ditambahkan jenis tersebut dan tabel dan id tabel
    * yang digunakan juga ditambahkan pada method setProperty 
    */

    function __construct($jenis, $idCompany, $id = '') {
        $this->idCompany = $idCompany;
        $this->setJenis($jenis);
        $this->setPrefixId();
        $this->setGenerateId($id);
    }

    private function setJenis($jenis) {
        if(in_array($jenis, $this->jenisExisting)) {
            $this->jenis = $jenis;
            $this->setProperty();
        } else {
            echo "jenis belum ditambahkan ke jenis existing helpers/GenerateId.php";
            exit;
        }
    }

    private function setProperty() {
        if($this->jenis == 'id_cuti_history') {
            $this->tabel    = 'cuti_history';
            $this->idTabel  = 'id_cuti_history';
            $this->digit    = 5;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_ulang_tahun') {
            $this->tabel    = 'data_ulang_tahun';
            $this->idTabel  = 'id_ulang_tahun';
            $this->digit    = 4;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_pengajuan_goal') {
            $this->tabel    = 'kpi_pengajuan_goal';
            $this->idTabel  = 'id_pengajuan_goal';
            $this->digit    = 4;
            $this->formatYm = "Y";
        }elseif($this->jenis == 'id_goal_pengembangan') {
            $this->tabel    = 'kpi_pengajuan_goal_pengembangan';
            $this->idTabel  = 'id_goal_pengembangan';
            $this->digit    = 4;
            $this->formatYm = "Y";
        }elseif($this->jenis == 'id_goal_uraian') {
            $this->tabel    = 'kpi_pengajuan_goal_uraian';
            $this->idTabel  = 'id_goal_uraian';
            $this->digit    = 5;
            $this->formatYm = "Y";
        }elseif($this->jenis == 'id_goal_sasaran') {
            $this->tabel    = 'kpi_pengajuan_goal_sasaran';
            $this->idTabel  = 'id_goal_sasaran';
            $this->digit    = 4;
            $this->formatYm = "Y";
        }elseif($this->jenis == 'id_log') {
            $this->tabel    = 'kpi_pengajuan_log';
            $this->idTabel  = 'id';
            $this->digit    = 4;
            $this->formatYm = "Y";
        }elseif($this->jenis == 'id_cabang') {
            $this->tabel    = 'master_cabang';
            $this->idTabel  = 'id_cabang';
            $this->digit    = 3;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_pengajuan_ph') {
            $this->tabel    = 'saldo_cuti_ph_pengajuan';
            $this->idTabel  = 'id_pengajuan_ph';
            $this->digit    = 4;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_saldo_ph') {
            $this->tabel    = 'saldo_cuti_ph';
            $this->idTabel  = 'id_saldo_ph';
            $this->digit    = 4;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_holidays') {
            $this->tabel    = 'holidays';
            $this->idTabel  = 'id';
            $this->digit    = 3;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_pi_trx') {
            $this->tabel    = 'kpi_aspek_kinerja_trx';
            $this->idTabel  = 'id_pi_trx';
            $this->digit    = 5;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_aspek_kepribadian') {
            $this->tabel    = 'kpi_aspek_kepribadian_trx';
            $this->idTabel  = 'id_aspek_kepribadian';
            $this->digit    = 5;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_notif_kpi') {
            $this->tabel    = 'notif_kpi';
            $this->idTabel  = 'id_notif';
            $this->digit    = 5;
            $this->formatYm = "Ym";
        }elseif($this->jenis == 'id_template') {
            $this->tabel    = 'pkwt_template_m';
            $this->idTabel  = 'id_template';
            $this->digit    = 5;
            $this->formatYm = "Y";
        }
    }

    private function getDigit() {
        return $this->digit;
    }

    private function setPrefixId() {
        $this->prefixId = $this->idCompany.date($this->formatYm);
    }

    private function getPrefixId() {
        return $this->prefixId;
    }

    private function setDigitId($digitId = '') {
        if($digitId == '') {
            $this->digitId = substr($this->getId(), -$this->getDigit());
        } else {
            $this->digitId = $digitId;
        }
    }

    private function getDigitId() {
        return $this->digitId;
    }

    private function setId() {
        $CI =& get_instance();
        $CI->load->model('GenerateId_m');

        $cekId   = $CI->GenerateId_m->cekId($this->getPrefixId(), $this->tabel, $this->idTabel);
        $idTemp = $this->idTabel;
        if($cekId->num_rows() > 0) {
            $this->id = $this->getPrefixId().$cekId->row()->$idTemp;
            $this->setDigitId();
            $this->id = $this->getPrefixId().sprintf("%'.0".$this->getDigit()."d", intval($this->getDigitId())+1);
        } else {
            $this->id = $this->getPrefixId().sprintf("%'.0".$this->getDigit()."d", 1);
        }
        $this->setDigitId();
    }

    private function setGenerateId($id = '') {
        if($id == '') {
            if($this->id == NULL) {
                $this->setId();
            }
        } else {
            $this->id = $id;
        }
    }

    function getId() {
        return $this->id;
    }

    function setCustomInc($inc) {
        $this->setDigitId();
        $this->setDigitId(sprintf("%'.0".$this->getDigit()."d", intval($this->getDigitId())+$inc));
        $this->setGenerateId($this->getPrefixId().$this->getDigitId());
    }

}