<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Dashboard extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('sales_activity/dashboard/Dashboard_m', 'model');
    }

    public function index()
    {
        $data['judul']   = 'Dashboard Sales Monitoring';
        $data['periode'] = date('m-Y');
        $data['tahun']   = date('Y');
        $this->load->view('sales_activity/dashboard/home', $data);
    }

    public function list_data_sales_summary()
    {   
        $periode               = $this->input->get("periode");
        $id_group_m            = $this->input->get("id_group_m");
        $data['sales_summary'] = $this->model->data_sales_summary($periode, $id_group_m);
        $this->load->view('sales_activity/dashboard/data_sales_summary', $data);
    }

    public function list_data_po_per_sales()
    {   
        $periode              = $this->input->get("periode");
        $id_group_m           = $this->input->get("id_group_m");
        $data['po_per_sales'] = $this->model->data_po_per_sales($periode, $id_group_m);
        echo json_encode($data);
    }

    public function list_data_po_per_product()
    {
        $periode                = $this->input->get("periode");
        $id_group_m             = $this->input->get("id_group_m");
        $by                     = $this->input->get("by");
        $data['po_per_product'] = $this->model->data_po_per_product($periode, $id_group_m, $by);
        $this->load->view('sales_activity/dashboard/data_po_per_product', $data);
    }

    public function list_data_activity($periode = "")
    {   
        $periode          = $this->input->get("periode");
        $id_group_m       = $this->input->get("id_group_m");
        $data['activity'] = $this->model->data_activity($periode, $id_group_m);
        $data['html']     = $this->load->view('sales_activity/dashboard/data_activity', $data, true);
        echo json_encode($data);
    }

    public function list_data_target_realisasi()
    {
        $tahun      = $this->input->get("tahun");
        $id_group_m = $this->input->get("id_group_m");

        $data['target_tahunan'] = $this->model->data_target('tahunan', $tahun, $id_group_m);
        $data['target_kuartal'] = $this->model->data_target('kuartal', $tahun, $id_group_m);
        $data['target_bulanan'] = $this->model->data_target('bulanan', $tahun, $id_group_m);
        $data['realisasi']      = $this->model->data_target('realisasi', $tahun, $id_group_m);

        $total_target_tahunan = str_replace('.', '', $data['target_tahunan']['total']);
        $total_realisasi      = str_replace('.', '', $data['realisasi']['total']);
        $selisih              = $total_realisasi - $total_target_tahunan;
        $data['selisih']      = number_format($selisih, 0, ",", ".");

        echo json_encode($data);
    }

    // DROPDOWN GROUP
    public function dropdown_group_area(){
        $for    = $this->input->get('for');
        $search = $this->input->get('q');

        if($for == "periode"){
            $periode = $this->input->get('periode');
            $this->model->dropdown_group_periode($periode, $search);
        }elseif($for == "tahun"){
            $tahun = $this->input->get('tahun');
            $this->model->dropdown_group_tahun($tahun, $search);
        }else{
            echo "failed to get data";
        }
    }
}
