<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Aspek_kedisiplinan extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('kpi/user/approval/aspek_kedisiplinan_m', 'model');
    }

    public function index() {
        $this->load->view('kpi/user/approval/detail/table/aspek_kedisiplinan');
    }

    public function list_data()
    {
        $this->load->model('kpi/user/team/detail_m');
        $this->load->helper('kpi/kpi');

        $dataTrx = $this->detail_m->getDataTrx()->row();

        $list  = $this->model->get_datatables($dataTrx->status);
        $data  = array();
        $no    = $_GET['start'];
		foreach ($list as $field) {
			$row = array();
			$row[] = $this->keterangan($field->jenis);
			$row[] = $field->jumlah;
			$row[] = $field->bobot."%";
			$row[] = $field->poin;
			$row[] = $field->skor;

			$data[] = $row;
            // $indek++;
		}

		$output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => 4,
            "recordsFiltered" => 4,
            "data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    private function keterangan($kode) {
        $data = [
            'T'   => 'Terlambat',
            'IT'  => 'Izin Terlambat',
            'PC'  => 'Pulang Cepat',
            'IPC' => 'Izin Pulang Cepat',
            'TAP' => 'Tidak Absen Pulang',
            'A'   => 'Alpa',
        ];

        return $data[$kode];
    }
}