<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Wizard_kepala_departemen extends MY_Controller{

  public function __construct()
  {
    parent::__construct();
    $this->load->model('wizard_m');
  }

  function index() {
    $this->db->select('data_karyawan.id_karyawan,
      data_karyawan.nik,
      data_karyawan.nama_lengkap,
      data_karyawan.id_departemen,
      users.username');
    $this->db->from('data_karyawan');
    $this->db->join('master_jabatan','master_jabatan.id_jabatan = data_karyawan.id_jabatan');
    $this->db->join('users', 'users.id_karyawan = data_karyawan.id_karyawan');
    $this->db->where('data_karyawan.id_company', $this->session->userdata('id_company'));
    $this->db->where('master_jabatan.level_user', 2);
    $this->db->order_by('data_karyawan.id_karyawan', 'desc');
    $this->db->limit(1);
    $data_kepala_departemen = $this->db->get();

    if($data_kepala_departemen->num_rows() == 0) {
      //jika belum ada kepala departemen
      $this->tambah();
    } else {
      //jika sudah ada edit
      $data = $data_kepala_departemen->row();
      $this->edit($data);
    }
  }

  function tambah() {
    //view tambah kepala departemen
    $id_company = $this->session->userdata('id_company');
    $this->db->where('id_company',$id_company);
    $this->db->order_by('id_departemen','desc');
    $this->db->limit(1);
    $data['data'] = $this->db->get('master_departemen')->row();
    $this->load->view('wizard/header');
    $this->load->view('wizard/kepala_departemen/tambah', $data);
    $this->load->view('wizard/footer');
  }

  function tambah_akun() {
    //view tambah kepala departemen
    $id_company = $this->session->userdata('id_company');
    $this->db->where('id_company',$id_company);
    $this->db->order_by('id_departemen','desc');
    $this->db->limit(1);
    $this->load->view('wizard/header');
    $this->load->view('wizard/kepala_departemen/tambah_akun', $data);
    $this->load->view('wizard/footer');
  }

  function edit($data_kepala) {
    //view edit kepala departemen
    $this->db->where('id_departemen',$data_kepala->id_departemen);
    $data['data_departemen'] = $this->db->get('master_departemen')->row();
    $data['data'] = $data_kepala;
    $this->load->view('wizard/header');
    $this->load->view('wizard/kepala_departemen/edit', $data);
    $this->load->view('wizard/footer');
  }

  function insert() {
    $id_company = $this->session->userdata('id_company');
    $nik = $this->input->post('nik');
    $nama = $this->input->post('nama');
    $departemen = $this->input->post('departemen');
    $username = $this->input->post('username');
    $password = $nik;
    $data_cabang = $this->wizard_m->data_cabang();
    $master_departemen = $this->master_departemen($departemen);
    $master_jabatan = $this->master_jabatan();
    $id_karyawan		= $this->wizard_m->generate_id('data_karyawan','id_karyawan', 4, $id_company);
    $id_user	= $this->wizard_m->generate_id('users','id_user', 4, $id_company, 3);
    $data = array(
      'id_cabang' => $data_cabang['id_cabang'],
      'id_jabatan' => $master_jabatan['id_jabatan'],
      'id_departemen' => $master_departemen['id_departemen'],
      'nik' => $nik,
      'nama'  => $nama,
      'username' => $username,
      'password' => $password,
      'id_company' => $id_company,
      'id_karyawan' => $id_karyawan,
      'id_user' => $id_user
    );
    $buat_karyawan	= $this->wizard_m->buat_karyawan($data);
    $data_karyawan	= $buat_karyawan['data_karyawan'];
    $data_users		= $buat_karyawan['data_users'];
    if(!array_key_exists('kode', $master_departemen)) {
      //jika departemen ada
      $data_departemen = $this->wizard_m->data_departemen();
    } else {
      $data_departemen = $master_departemen;
    }
    if(!array_key_exists('kode_jabatan', $master_jabatan)) {
      //jika jabatan ada
      $data_jabatan = $this->wizard_m->data_jabatan();
    } else {
      $data_jabatan = $master_jabatan;
    }

    $absensi = $this->wizard_m->buat_absensi($data_karyawan, $data_cabang, $data_departemen, $data_jabatan);

    $this->db->trans_start();
    if(array_key_exists('kode', $master_departemen)) {
      //jika departemen belum ada maka insert
      $this->db->insert('master_departemen', $master_departemen);
    }
    if(array_key_exists('kode_jabatan', $master_jabatan)) {
      //jika jabatan belum ada maka insert
      $this->db->insert('master_jabatan', $master_jabatan);
    }
    $this->db->insert('data_karyawan', $data_karyawan);
    $this->db->insert('users', $data_users);
    $this->db->insert_batch('absensi_masuk', $absensi['absensi_masuk']);
    $this->db->insert_batch('absensi_pulang', $absensi['absensi_pulang']);
    $this->db->insert_batch('r_absensi', $absensi['r_absensi']);
    $this->db->trans_complete();
    if ($this->db->trans_status() === FALSE)
    {
      return __response_save(false);
    } else {
      if($this->session->has_userdata('id_departemen_kedep')) {
        $this->session->set_userdata('id_departemen_kedep', $master_departemen['id_departemen']);
      }
      $this->update_status_wizard();
      return __response_save(true);
    }
  }

  function update() {
    $nik = $this->input->post('nik');
    $nik_edit = $this->input->post('nik_edit');
    $nama = $this->input->post('nama');
    $nama_edit = $this->input->post('nama_edit');
    $id_departemen = $this->input->post('departemen');
    $id_departemen_edit = $this->input->post('departemen_edit');
    $username = $this->input->post('username');
    $username_edit = $this->input->post('username_edit');
    $password = $nik;
    $id_karyawan = $this->input->post('id_karyawan');

    $data_karyawan = array();
    $data_users = array();
    if($nik != $nik_edit) {
      $data_karyawan['nik'] = $nik;
    }
    if($nama != $nama_edit) {
      $data_karyawan['nama_lengkap'] = $nama;
    }
    if($id_departemen != $id_departemen_edit) {
      $id_departemen_temp = $this->master_departemen($id_departemen);
      $data_karyawan['id_departemen'] = $id_departemen_temp['id_departemen'];
    }
    if($username != $username_edit) {
      $data_users['username'] = $username;
    }
    if($password != "") {
      $data_users['password'] = sha1(sha1(md5($password)));
      $data_users['password_2'] = $password;
    }
    $this->db->trans_start();
    if(isset($id_departemen_temp)) {
      if(array_key_exists('kode', $id_departemen_temp)) {
        //jika departemen belum ada maka insert
        $this->db->insert('master_departemen', $id_departemen_temp);
      }
    }
    if(!empty($data_karyawan)) {
      $this->db->update('data_karyawan', $data_karyawan, array('id_karyawan' => $id_karyawan));
    }
    if(!empty($data_users)) {
      $this->db->update('users', $data_users, array('id_karyawan' => $id_karyawan));
    }
    $this->db->trans_complete();
    $this->update_status_wizard();
    return __response_update(true);
  }

  function master_jabatan() {
    /*mengecek apakah jabatan kepala pada departemen id ada
    jika belum ada maka buat baru*/
    if($this->cek_jabatan() == false) {
      //belum ada jabatan maka create
      return $this->data_jabatan();
    } else {
      $id_jabatan = $this->wizard_m->data_jabatan();
      return array('id_jabatan' => $id_jabatan['id_jabatan']);
    }
  }

  function data_jabatan() {
    //buat data jabatan baru
    $id_company = $this->session->userdata('id_company');
    $id_jabatan	= $this->wizard_m->generate_id("master_jabatan", "id_jabatan", 3, $id_company, 3);
    $data = array(
			'id_jabatan'	=> $id_jabatan,
			'kode_jabatan'	=> 'K_DEP',
			'nama'			=> 'Kepala Departemen',
			'level_user'	=> 2,
			'id_company'	=> $id_company
		);
    return $data;
  }

  function cek_jabatan() {
    //cek jabatan apakah ada
    $id_company = $this->session->userdata('id_company');
    $cek = $this->db->get_where('master_jabatan', array('level_user' => 2, 'id_company' => $id_company))->num_rows();
    if($cek > 0) {
      return true;
    } else {
      return false;
    }
  }

  function master_departemen($id) {
    /*mengecek apakah ada data departemen tersebut
    jika ada maka return array kosong jika tidak maka buat data departemen baru*/
    if($this->cek_departemen($id) == false) {
      /*belum ada departemen maka create*/
      return $this->data_departemen($id);
    } else {
      return array('id_departemen' => $id);
    }
  }

  function data_departemen($departemen) {
    //buat data departemen baru
    $id_company = $this->session->userdata('id_company');
    $id_departemen = $this->wizard_m->generate_id("master_departemen", "id_departemen", 3, $id_company);
    $data = array(
			'id_departemen'	=> $id_departemen,
			'kode'			  => substr(str_replace(' ','',$departemen),0,3), //mengambil tiga karakater dan menghilangkan spasi
			'nama'			  => $departemen,
			'id_company'	=> $id_company
		);
    return $data;
  }

  function cek_departemen($id) {
    //cek apakah terdapat departemen
    $cek = $this->db->get_where('master_departemen', array('id_departemen' => $id))->num_rows();
    if($cek > 0) {
      return true;
    } else {
      return false;
    }
  }

  function cek_username() {
    //cek apakah username ada
    $username = $this->input->get('username');
    $query = $this->db->where('username', $username)->get('users')->num_rows();
    if($query > 0) {
      $result['username'] = true;
    } else {
      $result['username'] = false;
    }
    echo json_encode($result);
  }

  public function select2_departemen(){
      $id_company = $this->session->userdata('id_company');
      $search = $this->input->get("q");

      $this->db->select('nama, id_departemen, kode');
      $this->db->where('id_departemen
        NOT IN(SELECT GROUP_CONCAT(distinct id_departemen)
        FROM data_karyawan JOIN master_jabatan ON master_jabatan.id_jabatan = data_karyawan.id_jabatan
        WHERE level_user = 2 AND data_karyawan.id_company = "'.$id_company.'")');
      $this->db->where('id_company', $id_company);

      $this->db->group_start();
      $this->db->like('nama', $search);
      $this->db->or_like('kode', $search);
      $this->db->group_end();
      $this->db->order_by('id_departemen', 'ASC');

      $result = $this->db->get('master_departemen')->result();
      $json = [];
      foreach ($result as $rows) {
          $json[] = ['id'             =>$rows->id_departemen,
                      'kodedepartemen'=>$rows->kode,
                      'namadepartemen'=>$rows->nama,
                      'text'          =>$rows->kode." - ".$rows->nama];
      }
      echo json_encode($json);
  }

  function update_status_wizard() {
    //update status akun_kedep pada tabel wizard
    $id_company = $this->session->userdata('id_company');
    $this->db->set('akun_kedep','1')->where('id_company', $id_company)->update('wizard');
  }
}
