<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Kalender extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Kalender_m');
        $this->load->model('Db_model', 'db_model');
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel'));
    }

    public function index()
    {
        $data['judul']    = $this->lang->line('menu_hari_libur');
        $data['aktif']    = 'kalender';
        $data['kalender'] = $this->kalender();
        $data['menu']     = $this->load->view('main_menu', $data, true);
        $data['content']  = $this->load->view('kalender/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data()
    {
        $data['judul'] = $this->lang->line('menu_hari_libur');
        $data['aktif'] = 'kalender';
        $this->load->view('kalender/list_view', $data, false);
    }

    public function kalender_data()
    {
        $data['data_kelender'] = $this->kalender();
        $this->load->view('kalender/kalender_view', $data, false);
    }

    public function kalender()
    {
        $libur = $this->db->get_where('holidays', array('id_company' => $this->id_company))->result();

        $json = array();
        foreach ($libur as $qq) {
            $isi               = array();
            $isi['id_holiday'] = md5($qq->id);
            $isi['title']      = ucwords($qq->keterangan);
            $isi['jenis']      = $qq->jenis;
            $isi['start']      = date_format(date_create($qq->tanggal), "Y-m-d H:i:s");
            $isi['id_company'] = intval($qq->id_company);
            $isi['color']      = $qq->color;
            $isi['textColor']  = 'white';
            $json[]            = $isi;
        }
        // echo json_encode($json);
        return json_encode($json);
    }

    public function list_data()
    {
        $list = $this->Kalender_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = (($this->code_lang == 'id') ? $this->fungsi->tgl_indo($field->tanggal) : date('d F Y', strtotime($field->tanggal)));
            $row[] = $field->keterangan;
            $row[] = $this->lang->line('libur_' . $field->jenis);
            if (in_array($this->level_user, array("1"))) {
                $row[] = '<a href="javascript:void(0)" class="text-warning" title="Edit">
							<i id="' . md5($field->id) . '" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
						<a href="javascript:void(0)" class="text-danger" title="Delete">
							<i id="' . md5($field->id) . '" class="btn_delete fa fa-trash"></i>
						</a>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Kalender_m->count_all(),
            "recordsFiltered" => $this->Kalender_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null)
    {
        if ($id == null) {
            $this->load->view('kalender/form');
        } else {
            $data['data'] = $this->Kalender_m->getDataById($id);
            $this->load->view('kalender/form_edit', $data);
        }
    }

    public function save()
    {
        $tanggal_str = $this->input->post('tanggal');

        $tanggal_array = explode(',', $tanggal_str);

        $data_to_insert = [];

        foreach ($tanggal_array as $tgl) {
            $data_to_insert[] = [
                'tanggal'    => date('Y-m-d', strtotime($tgl)),
                'keterangan' => $this->input->post('keterangan'),
                'jenis'      => $this->input->post('jenis'),
                'id_company' => $this->id_company,
                'user_input' => $this->nik_karyawan." - ".$this->nm_karyawan
            ];
        }

        $this->Kalender_m->save($data_to_insert, $id);
    }

    public function update()
    {
        $id = $this->input->post('id');
    
        $data = array(
                    'tanggal'     => date('Y-m-d', strtotime($this->input->post('tanggal'))),
                    'keterangan'  => $this->input->post('keterangan'),
                    'id_company'  => $this->id_company,
                    'user_update' => $this->nik_karyawan." - ".$this->nm_karyawan,
                    'tgl_update'  => date('Y-m-d h:i:s')
                );
    
        $this->Kalender_m->update($data,$id); 
    }

    public function delete()
    {
        $id = $this->input->post("id");
        $this->Kalender_m->delete($id);
    }

}