<script src="/assets/js/autoNumeric.js"></script>
<div class="row">
    <div class="col-md-5">
        <!-- bpjs kesehatan -->
        <div class="row mt-1 mb-1">
            <div class="col-md-8">
                <h3>BPJS KESEHATAN</h3>
            </div>
            <div class="col-md-4 text-right">
                <label class="switch">
                    <input type="checkbox" class="default" name="bpjs_kes_flag" value="1" <?= $data_bpjs_kes->flag == '1' ? 'checked' : '' ?> onclick="pengaturan_bpjs_kes()">
                    <span class="slider round text-center"><?= $data_bpjs_kes->flag == '1' ? 'Aktif' : 'Nonaktif' ?></span>
                </label>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 table-responsive">
                <table class="table dataTable" style="width: 100%;">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 10%;">NO</th>
                            <th>JENIS</th>
                            <th>NOMINAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text-center">1.</td>
                            <td>TUNJANGAN PERUSAHAAN</td>
                            <td class="text-center"><?= $data_bpjs_kes->tunj_perus ?> %</td>
                        </tr>
                        <tr>
                            <td class="text-center">2.</td>
                            <td>POTONGAN KARYAWAN</td>
                            <td class="text-center"><?= $data_bpjs_kes->pot_kry ?> %</td>
                        </tr>
                        <tr>
                            <td class="text-center">3.</td>
                            <td>POTONGAN TAMBAHAN KARYAWAN</td>
                            <td class="text-center"><?= $data_bpjs_kes->pot_tambahan_kry ?> %</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-7">
        <!-- bpjs ketenagakerjaan -->
        <div class="row mt-1 mb-1">
            <div class="col-md-8">
                <h3>BPJS KETENAGAKERJAAN</h3>
            </div>
            <div class="col-md-4 text-right"></div>
        </div>
        <div class="row">
            <div class="col-md-12 table-responsive">
                <table id="bpjs_ket" class="table dataTable" style="width: 100%;">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 10%;">NO</th>
                            <th style="width: 30%;">JENIS</th>
                            <th>STATUS</th>
                            <th style="width: 20%;">TUNJANGAN</th>
                            <th style="width: 20%;">POTONGAN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text-center">1.</td>
                            <td>JAMINAN HARI TUA (JHT)</td>
                            <td class="text-center">
                                <label class="switch">
                                    <input type="checkbox" class="default" name="flag_jht" value="1" <?= $data_bpjs_tk->flag_jht == '1' ? 'checked' : '' ?>>
                                    <span class="slider round"><?= $data_bpjs_tk->flag_jht == '1' ? 'Aktif' : 'Nonaktif' ?></span>
                                </label>
                            </td>
                            <td class="text-right" id="tunj_jht_perus">
                                <?= $data_bpjs_tk->tunj_jht_perus ?> %
                                <?= $data_bpjs_tk->flag_jht == '1' ? '&nbsp;<button class="btn btn-warning" onclick="input_nominal(this)"><i class="fa fa-edit"></i></button>' : '' ?>
                            </td>
                            <td class="text-right" id="pot_jht_kry">
                                <?= $data_bpjs_tk->pot_jht_kry ?> %
                                <?= $data_bpjs_tk->flag_jht == '1' ? '&nbsp;<button class="btn btn-warning" onclick="input_nominal(this)"><i class="fa fa-edit"></i></button>' : '' ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-center">2.</td>
                            <td>JAMINAN KECELAKAAN KERJA (JKK)</td>
                            <td class="text-center">
                                <label class="switch">
                                    <input type="checkbox" class="default" name="flag_jkk" value="1" <?= $data_bpjs_tk->flag_jkk == '1' ? 'checked' : '' ?>>
                                    <span class="slider round"><?= $data_bpjs_tk->flag_jkk == '1' ? 'Aktif' : 'Nonaktif' ?></span>
                                </label>
                            </td>
                            <td class="text-right" id="tunj_jkk">
                                <?= $data_bpjs_tk->tunj_jkk ?> %
                                <?= $data_bpjs_tk->flag_jkk == '1' ? '&nbsp;<button class="btn btn-warning" onclick="input_nominal(this)"><i class="fa fa-edit"></i></button>' : '' ?>
                            </td>
                            <td class="text-center">-</td>
                        </tr>
                        <tr>
                            <td class="text-center">3.</td>
                            <td>JAMINAN KEMATIAN (JKM)</td>
                            <td class="text-center">
                                <label class="switch">
                                    <input type="checkbox" class="default" name="flag_jkm" value="1" <?= $data_bpjs_tk->flag_jkm == '1' ? 'checked' : '' ?>>
                                    <span class="slider round"><?= $data_bpjs_tk->flag_jkm == '1' ? 'Aktif' : 'Nonaktif' ?></span>
                                </label>
                            </td>
                            <td class="text-right" id="tunj_jkm">
                                <?= $data_bpjs_tk->tunj_jkm ?> %
                                <?= $data_bpjs_tk->flag_jkm == '1' ? '&nbsp;<button class="btn btn-warning" onclick="input_nominal(this)"><i class="fa fa-edit"></i></button>' : '' ?>
                            </td>
                            <td class="text-center">-</td>
                        </tr>
                        <tr>
                            <td class="text-center">4.</td>
                            <td>JAMINAN PENSIUN (JP)</td>
                            <td class="text-center">
                                <label class="switch">
                                    <input type="checkbox" class="default" name="flag_jp" value="1" <?= $data_bpjs_tk->flag_jp == '1' ? 'checked' : '' ?>>
                                    <span class="slider round"><?= $data_bpjs_tk->flag_jp == '1' ? 'Aktif' : 'Nonaktif' ?></span>
                                </label>
                            </td>
                            <td class="text-right" id="tunj_jp_perus">
                                <?= $data_bpjs_tk->tunj_jp_perus ?> %
                                <?= $data_bpjs_tk->flag_jp == '1' ? '&nbsp;<button class="btn btn-warning" onclick="input_nominal(this)"><i class="fa fa-edit"></i></button>' : '' ?>
                            </td>
                            <td class="text-right" id="pot_jp_kry">
                                <?= $data_bpjs_tk->pot_jp_kry ?> %
                                <?= $data_bpjs_tk->flag_jp == '1' ? '&nbsp;<button class="btn btn-warning" onclick="input_nominal(this)"><i class="fa fa-edit"></i></button>' : '' ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    function pengaturan_bpjs_kes() {
        $('#tampil_form').load('<?= route("payroll.bpjs.config.form", ["jenis" => "bpjs_kes"]) ?>', function() {
            $('#modal_form').modal('show');
        });
    }

    $('table#bpjs_ket input').click(function() {
        var name = $(this).attr('name');
        $('#tampil_form').load('<?= route("payroll.bpjs.config.form", ["jenis" => "bpjs_tk", "name" => "'+name+'"]) ?>', function() {
            // $('.nominal').autoNumeric('init', {aSep: '.', aDec: ',', vMax: '99.99'});
            $('#modal_form').modal('show');
        });
    });

    function simpan_bpjs_kes() {
        $('#form_bpjs_kes #message').html('');

        // Create a new instance of ladda for the specified button
        var l = Ladda.create(document.querySelector('#form_bpjs_kes .btn_save'));

        // Start loading
        l.start();

        $.post('<?= route("payroll.bpjs.config.save", ["jenis" => "bpjs_kes"]) ?>', $('#form_bpjs_kes #form_input').serialize(), function(response) {
            l.stop();
            showMsg(response.message);
            if (response.success) {
                $('#form_bpjs_kes .btn_save').prop('disabled', true);
                $('#form_bpjs_kes input[name="flag_temp"]').val(response.new_flag);
                $('.switch > span:eq(0)').html((response.new_flag == '1') ? 'Aktif' : 'Nonaktif');
            }
        }, 'json');
    }

    function simpan_bpjs_tk() {
        $('#form_bpjs_tk #message').html('');

        var flag_temp = $('input[name="flag_temp"]').val();
        var name = $('input[name="name"]').val();

        // Create a new instance of ladda for the specified button
        var l = Ladda.create(document.querySelector('#form_bpjs_tk .btn_save'));

        // Start loading
        l.start();

        $.post('<?= route("payroll.bpjs.config.save", ["jenis" => "bpjs_tk"]) ?>', $('#form_bpjs_tk #form_input').serialize(), function(response) {
            l.stop();
            showMsg(response.message);
            if (response.success) {
                $('#form_bpjs_tk .btn_save').prop('disabled', true);
                $('#form_bpjs_tk input[name="temp"]').val(response.new_flag);
                config();
            }
        }, 'json');
    }

    function input_nominal(element) {
        var id = $(element).parent().attr("id");
        $.get('<?= route("payroll.bpjs.config.input-nominal", ["name" => "' + id + '"]) ?>', function(response) {
            $('#' + id).html(response);
            $('#' + id + ' .nominal').autoNumeric('init', {
                aSep: '.',
                aDec: ',',
                vMax: '99.99'
            });
        });
    }

    function save_nominal(element) {
        var id = $(element).closest("td").attr("id");
        var form = $('#' + id + ' form').serialize();

        let loading = Ladda.create($("form .btn-save")[0]);
        loading.start();
        $.post('<?= route("payroll.bpjs.config.save-nominal") ?>', form, function(response) {
            if (response.success) {
                $('#' + id).html(response.html);
                loading.stop();
            }
        }, 'json');
    }
</script>
