
<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Absenku | <?= $this->lang->line('title_bagan_organisasi') ?></title>
        <link rel="shortcut icon" href="<?= $this->config->item('dir_assets') ?>images/icon/favicon-absenku-pro.svg">
        <link rel="apple-touch-icon" href="<?= $this->config->item('dir_assets') ?>app-assets/images/ico/apple-icon-120.png">


        <link rel="stylesheet" type="text/css" href="<?= $this->config->item('dir_assets') ?>app-assets/css/vendors.css">
        <link rel="stylesheet" type="text/css" href="<?= $this->config->item('dir_assets') ?>app-assets/css/app.css">
        <link rel="stylesheet" type="text/css" href="<?= $this->config->item('dir_assets') ?>css/custom-vii.css?v=2">

        <link href="https://cdnjs.cloudflare.com/ajax/libs/orgchart/4.0.1/css/jquery.orgchart.min.css" rel="stylesheet">

        <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/orgchart/4.0.1/js/jquery.orgchart.min.js"></script>

        <script type="text/javascript">
            $(function() {
                var oc = $('#bagan-organisasi').orgchart({
                                'data' : {},
                                'nodeContent': 'title',
                                'createNode': function(node, data) {
                                        if (data.levelOffset) {
                                        node.css({
                                            'margin-top': (data.levelOffset * 20) + 'px',
                                            '--top': (-11 - data.levelOffset * 20) + 'px',
                                            '--height': (9 + data.levelOffset * 20) + 'px',
                                            '--top-cross-point': (-13 - data.levelOffset * 20) + 'px',
                                            '--height-cross-point': (11 + data.levelOffset * 20) + 'px'
                                        });
                                        }
                                    },
                                    'verticalLevel': 4
                                    // 'verticalLevel': 4
                                });

                $.ajax({
                    type: 'GET',
                    dataType: 'json',
                    url: '<?= route("master.karyawan.bagan.organisasi.data") ?>',
                }).done(function(data, textStatus, jqXHR) {
                        oc.init({ 'data': data });
                });
            });
        </script>
    </head>
    <style>
        body{
            height:100ph;
            padding-bottom:200px;
            /* width: fit-content; */
        }
        .header-chart{
            border-bottom: 1px solid #14d0ff;
            background-color: #fff;
            padding: 15px;
            margin: unset !important;
            position: fixed;
            width: 100%;
            z-index: 999;
        }
        footer{
            position:fixed;
            bottom:0px;
            width: 100%;
        }

        .app-content {
            padding:0px 0px 40px 0px;

        }

        #bagan-organisasi {
            padding-top:50px !important;
        }

        .box-org{
            background-color:#e1f1f8;
            font-weight:bold;
        }



        .orgchart {
            min-height:80vh;
            min-width: 100%;
            padding:50px 30px !important;
            background-image:unset !important;
        }

        /* .orgchart .node {
            margin: 0 0 40px 0;
            flex-wrap: wrap !important;
        } */

        /* .orgchart .nodes {
            display: flex;
            list-style: none;
            padding-left: 0;
            margin: 0 0 40px 0;
            flex-wrap: wrap;
        } */

        .orgchart .nodes {
            justify-content:center;
        }
        .orgchart .node .title {
            background-color: rgb(0 130 195);
            width: 180px;
            padding: 0 10px;
            height: unset !important;
            -webkit-line-clamp: 2;
        }

        .orgchart .node .content {
            border: 1px solid #404e67;
            height:unset;
            border-right: 1px solid #404e67;
            width: 180px;
        }

        .orgchart .nodes.vertical .nodes {
            padding-left: 90px;
        }

        .orgchart .nodes.vertical .hierarchy::after,
        .orgchart .nodes.vertical .hierarchy::before,
        .orgchart .hierarchy::before,
        .orgchart .hierarchy::after{
            border-color:#404e67 !important
        }

        .orgchart>ul>li>ul li>.node::before,
        .orgchart>ul>li>ul li>.node::after,
        .orgchart .node:not(:only-child)::after{
            background-color:#404e67 !important
        }

        /* START */
        .orgchart .node:not(:only-child)::after {
            height: 15px;
        }

        .orgchart .hierarchy.isSiblingsCollapsed.left-sibs::before,
        .orgchart .hierarchy:first-child::before {
            left: calc(50% - 5px);
            width: calc(50% + 5px);
        }

        .orgchart .hierarchy.isSiblingsCollapsed.right-sibs::before,
        .orgchart .hierarchy:last-child::before {
            /* width: calc(45% + 6px); */
            width: calc(30% + 38px);
        }
        .orgchart .nodes.vertical>.hierarchy:first-child::before {
            width: calc(45% + 6.5px);
        }
        /* END */


    </style>
    <body>
        <div class="app-content">
            <div class="content-wrapper">
                <div class="content-body">
                    <div class="row mt-2 mb-2 header-chart" style="margin-right:unset;margin-left:unset;">
                        <div class="col-md-12 text-center">
                            <img width="150" src="<?= $this->config->item('dir_assets') ?>images/logo/logo-absenku-pro.svg">
                            <button type="button" onclick="window.open('', '_self', ''); window.close();" class="btn btn-secondary pull-right"><i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?></button>
                        </div>
                    </div>

                    <div id="bagan-organisasi"></div>
                </div>
            </div>
        </div>
    </body>
    <footer class="footer footer-static navbar-shadow">
        <p class="clearfix text-sm-center mb-0 px-2">
            Copyright © 2021-<?= date('Y') ?> Absenku
        </p>
    </footer>



</html>

