<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Laporan_pph_uu24_m extends CI_Model
{
    protected $table = 'payroll_pph21_trx_uu24';

    function get_datatables($bulan = "0000-00", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        $this->_get_datatables_query($bulan, $cabang, $departemen, $karyawan);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($bulan = "0000-00", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        $this->_get_datatables_query($bulan, $cabang, $departemen, $karyawan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($bulan = "0000-00", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        $this->_get_datatables_query($bulan, $cabang, $departemen, $karyawan);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($bulan = "0000-00", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        // $parts = explode('-', $bulan);
        // $bulan = $parts[1]. "-". $parts[0];

        $this->db->where("pph.periode", $bulan);
        $this->db->where("pph.id_company", $this->id_company);

        if ($karyawan != "all") {
            $this->db->where("MD5(pph.id_karyawan)", $karyawan);
        } else {
            if ($cabang != "all") {
                $this->db->where("pph.id_cabang", $cabang);
            }

            if ($departemen != "all") {
                $this->db->where("pph.id_departemen", $departemen);
            }
        }

        $this->db->select('
            pph.id_karyawan,
            pph.nik,
            pph.nm_karyawan,
            pph.no_ktp,
            pph.npwp,
            pph.alamat_ktp,
            pph.id_jabatan,
            pph.kd_jabatan,
            pph.nm_jabatan,
            pph.id_cabang,
            pph.kd_cabang,
            pph.nm_cabang,
            pph.id_departemen,
            pph.kd_departemen,
            pph.nm_departemen,
            pph.periode,
            pph.gapok,
            pph.ttl_tunjangan,
            pph.gaji_bruto,
            pph.penerima_penghasilan,
            pph.kd_objek_pajak,
            pph.penandatangan_jenis,
            pph.penandatangan_npwp,
            pph.penandatangan_nik,
            pph.kd_ptkp,
            pph.pegawai_harian,
            pph.gross_up,
            pph.fasilitas,
            pph.no_skb_dtp,
            pph.tgl_pemotongan,
            pph.ter_jenis,
            pph.ter_persen,
            pph.min_bruto,
            pph.max_bruto,
            pph.pph21,
            pph.id_company,
            pph.user_input,
            pph.tgl_input
        ')
            ->from($this->table . ' AS pph')
            ->order_by('pph.id_karyawan', 'ASC');
    }

    function nama_karyawan($id_karyawan)
    {
        return $this->db->select('nama_lengkap')
            ->where('MD5(id_karyawan)', $id_karyawan)
            ->get('data_karyawan')->row()->nama_lengkap;
    }

    function nama_cabang($id_cabang)
    {
        return $this->db->select('nama')
            ->where('id_cabang', $id_cabang)
            ->get('master_cabang')->row()->nama;
    }

    function nama_departemen($id_departemen)
    {
        return $this->db->select('nama')
            ->where('id_departemen', $id_departemen)
            ->get('master_departemen')->row()->nama;
    }
}
