<?php

if (!function_exists('language_init')) {
    function language_init($lang = '')
    {
        $ci = &get_instance();
        $ci->load->helper('language');
        $siteLang = $lang ?: $ci->session->userdata('site_lang');
        if ($siteLang) {
            $ci->lang->load(array('error_message', 'content'), $siteLang);
        } else {
            $ci->lang->load(array('error_message', 'content'), 'indonesia');
        }
        return $ci;
    }
}

if (!function_exists('notif_status')) {
    function notif_status($status)
    {
        if ($status == '1') {
            $status = '&nbsp;<i class="fa fa-circle text-warning" aria-hidden="true"></i>';
        } elseif ($status == '3') {
            $status = '&nbsp;<i class="fa fa-circle text-warning" aria-hidden="true"></i>';
        } elseif ($status == '4') {
            $status = '&nbsp;<i class="fa fa-circle text-danger" aria-hidden="true"></i>';
        } else {
            $status = '';
        }
        return $status;
    }
}

if (!function_exists('notif_kepegawaian')) {
    function notif_kepegawaian($id_karyawan, $menu, $id, $jenis, $aksi)
    {
        $init = language_init('english');
        $init->load->model('wizard_m');
        $init->load->helper('notif');

        $id_company       = $init->session->userdata('id_company');
        $nama_karyawan    = $init->db->select('nama_lengkap')->get_where('data_karyawan', ['id_karyawan' => $id_karyawan])->row()->nama_lengkap;
        $nama_verifikator = $init->session->userdata('nama_user');
        $pre_ket          = explode(',', pre_keterangan($jenis, $menu));

        if ($aksi == 'setuju') {
            $aksi_detail = 'disetujui';
            $aksi_detail_en = 'approved';
        } elseif ($aksi == 'revisi') {
            $aksi_detail = 'dikembalikan untuk direvisi';
            $aksi_detail_en = 'returned for revision';
        }

        $data = [
            'id_notif'              => $init->wizard_m->generate_id('notif_kepegawaian', 'id_notif', 4, $id_company),
            'id_karyawan'           => $id_karyawan,
            'id_karyawan_pengajuan' => $init->session->userdata('id_karyawan'),
            'menu'                  => $menu,
            'id_ref'                => $id,
            'rute'                  => rute_notif_kepegawaian($menu),
            'ket_notif'             => "Pengajuan " . implode(' ', $pre_ket) . " $nama_karyawan Telah $aksi_detail oleh $nama_verifikator",
            'ket_notif_id'          => "Pengajuan " . implode(' ', $pre_ket) . " $nama_karyawan Telah $aksi_detail oleh $nama_verifikator",
            'ket_notif_en'          => "The application to " . strtolower($init->lang->line(strtolower($pre_ket[0]))) . " $nama_karyawan " . strtolower($init->lang->line(str_replace(' ', '_', strtolower($pre_ket[1])))) . " has been $aksi_detail_en by $nama_verifikator",
            'id_company'            => $id_company
        ];

        if ($aksi == 'revisi') {
            $data['jenis'] = 'revisi';
        }

        $init->db->insert('notif_kepegawaian', $data);
    }
}

if (!function_exists('rute_notif_kepegawaian')) {
    function rute_notif_kepegawaian($menu)
    {
        if ($menu == 'data_diri') {
            return 'detail_data_diri';
        } elseif ($menu == 'data_keluarga') {
            return 'detail_data_keluarga';
        } elseif ($menu == 'data_pendidikan') {
            return 'detail_data_pendidikan';
        } elseif ($menu == 'pengalaman_kerja') {
            return 'detail_data_pengalaman_kerja';
        } elseif ($menu == 'sertifikat') {
            return 'detail_data_sertifikat';
        } elseif ($menu == 'kelengkapan') {
            return 'detail_data_kelengkapan_file';
        }
    }
}

if (!function_exists('pre_keterangan')) {
    function pre_keterangan($jenis, $menu)
    {
        // jenis = tambah, update, dan hapus
        $init = language_init();
        $init->load->helper('notif');

        return strtoupper($jenis) . "," . strtoupper(keterangan_menu($menu));
    }
}

if (!function_exists('keterangan_menu')) {
    function keterangan_menu($menu)
    {
        $init = language_init();

        if ($menu == 'data_diri') {
            return 'data diri';
        } elseif ($menu == 'data_keluarga') {
            return 'data keluarga';
        } elseif ($menu == 'data_pendidikan') {
            return 'data pendidikan';
        } elseif ($menu == 'pengalaman_kerja') {
            return 'pengalaman kerja';
        } elseif ($menu == 'sertifikat') {
            return 'data sertifikat';
        } elseif ($menu == 'kelengkapan') {
            return 'kelengkapan file';
        }
    }
}

if (!function_exists('jenis_revisi')) {
    function jenis_revisi($result)
    {
        $init = language_init();

        if ($result > 0) {
            return 'update';
        } else {
            return 'tambah';
        }
    }
}
