<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Realisasi_won extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/report/Realisasi_won_m', 'model');
    }

    public function dropdown_group()
    {
        $periode_mulai   = date_format(date_create($this->input->get("periode_mulai")),"Y-m-d");
        $periode_selesai = date_format(date_create($this->input->get("periode_selesai")),"Y-m-d");
        $search          = $this->input->get("q");
        return $this->model->dropdown_group($periode_mulai, $periode_selesai, $search);
    }

    public function dropdown_karyawan()
    {
        $periode_mulai   = date_format(date_create($this->input->get("periode_mulai")),"Y-m-d");
        $periode_selesai = date_format(date_create($this->input->get("periode_selesai")),"Y-m-d");
        $id_group        = $this->input->get("id_group");
        $search          = $this->input->get("q");
        return $this->model->dropdown_karyawan($periode_mulai, $periode_selesai, $id_group, $search);
    }

    public function list_data(){
        $periode_mulai  = date_format(date_create($this->input->get("periode_mulai")),"Y-m-d");
        $periode_selesai = date_format(date_create($this->input->get("periode_selesai")),"Y-m-d");
        $id_group        = $this->input->get("id_group");
        $id_karyawan     = $this->input->get('id_karyawan');

        $list = $this->model->get_datatables($periode_mulai, $periode_selesai, $id_group, $id_karyawan);

        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = date_format(date_create($field->tgl_approve), "d-m-Y");
            $row[] = $field->nama_karyawan . "<br><b>" . $field->nik . "</b>";
            $row[] = number_format($field->nominal_layanan, 0,",",".");
            $row[] = $field->nama_product;
            $row[] = $field->nama_perusahaan;
            $row[] = $field->title;
            $row[] = ucwords($field->kategori_pelanggan);
            $row[] = $field->jenis_perusahaan;
            $row[] = ucwords($field->nama_lead);

            $lama_closing = timespan(strtotime($field->tgl_input_main), strtotime($field->tgl_approve), 2);
            $row[] = $lama_closing;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($periode_mulai, $periode_selesai, $id_group, $id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($periode_mulai, $periode_selesai, $id_group, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function download(){
        $periode_mulai   = date_format(date_create($this->input->get('periode_mulai')), "Y-m-d");
        $periode_selesai = date_format(date_create($this->input->get('periode_selesai')), "Y-m-d");
        $id_group        = $this->input->get('id_group');
        $nm_group        = $this->input->get('nm_group');
        $id_karyawan     = $this->input->get('id_karyawan');
        $nm_karyawan     = $this->input->get('nm_karyawan');

        $header   = "Sales Monitoring - Laporan PO ".$nm_group." ".$nm_karyawan;

        $data['periode_mulai']   = $this->input->get('periode_mulai');
        $data['periode_selesai'] = $this->input->get('periode_selesai');
        $data['header']          = $header;
        $data['list']            = $this->model->get_datatables($periode_mulai, $periode_selesai, $id_group, $id_karyawan);

		$filename = "Sales Monitoring - Laporan PO ".$data['periode_mulai']." sd ".$data['periode_selesai']." ".$nm_group." ".$nm_karyawan;
		$output   = true;
		$sb_view  = $this->load->view('sales_activity/report/realisasi_won/download', $data, $output);

        // START FORMAT COLUMN
        $format_columns = [
			'A'  => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
			'B'  => ['width' => 12, 'align' => 'center', 'valign' => 'middle'],
			'C'  => ['width' => 16, 'align' => 'left', 'valign' => 'middle', 'format'=>'text'],
			'D'  => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
			'E'  => ['width' => 15, 'align' => 'right', 'valign' => 'middle', 'format'=>'text', 'rupiah'=>true],
			'F'  => ['width' => 30, 'align' => 'left', 'valign' => 'middle'],
			'G'  => ['width' => 30, 'align' => 'left', 'valign' => 'middle'],
			'H'  => ['width' => 30, 'align' => 'left', 'valign' => 'middle'],
			'I'  => ['width' => 20, 'align' => 'center', 'valign' => 'middle'],
			'J'  => ['width' => 20, 'align' => 'left', 'valign' => 'middle'],
			'K'  => ['width' => 16, 'align' => 'center', 'valign' => 'middle'],
			'L'  => ['width' => 20, 'align' => 'left', 'valign' => 'middle'],
		];
        // END FORMAT COLUMN

        $param = [
			'download'    => true,
			'cLength'     => 11,
			'file_name'   => strtoupper($filename),
			'paper_size'  => 'LEGAL',
			'font-size'   => 11,
			'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
			'orientation' => 'landscape',
			'header'      => [
				'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
			],
			'thead'        => ['4'],
			'tbody'        => [
				'start'  => '4',
				'height' => 15,
				'wrap'   => ['B','C','D','E'],
				'column' => $format_columns,
			],
            'align_column_unit' => [
                [   'align' => 'center', 'column' => ['A4:L4'] ]
            ]
		];

		$this->load->library('PHPExcel/Excel');

		if ($output) {
			$this->excel->generateExcel($sb_view, $param);
		}
		exit;
    }
}