<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Aktivitas extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/report/Aktivitas_m', 'model');
    }

    public function view_data(){

        $periode_mulai   = $this->input->get('periode_mulai');
        $periode_selesai = $this->input->get('periode_selesai');
        $id_group        = $this->input->get('id_group');
        $id_karyawan     = $this->input->get('id_karyawan');

        $data['periode_mulai']   = $periode_mulai;
        $data['periode_selesai'] = $periode_selesai;
        $data['id_group']        = $id_group;
        $data['id_karyawan']     = $id_karyawan;
        $data['table_header']    = $this->model->table_header($periode_mulai, $periode_selesai);
        $this->load->view('sales_activity/report/aktivitas/table', $data);
    }

    public function list_data(){
        $periode_mulai   = $this->input->get('periode_mulai');
        $periode_selesai = $this->input->get('periode_selesai');
        $id_group        = $this->input->get('id_group');
        $id_karyawan     = $this->input->get('id_karyawan');

        $table_header = $this->model->table_header($periode_mulai, $periode_selesai, $id_group);
        $get_aktivitas = $this->model->get_total_activity($periode_mulai, $periode_selesai, $id_group, $id_karyawan);

        $list = $this->model->get_datatables($periode_mulai, $periode_selesai, $id_group, $id_karyawan);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";

            foreach($table_header AS $header){
                $total_aktivitas = $get_aktivitas[$field->id_karyawan][$header->nama_aktivitas]['total'];
                $row[]           = !empty($total_aktivitas) ? $total_aktivitas : 0;
            }

            $data[] = $row;
        }

        // Footer Total
        $row   = array();
        $row[] = '<B>TOTAL AKTIVITAS</B>';
        $row[] = '';
        foreach($table_header AS $header){
            $total_aktivitas = $get_aktivitas['total_aktivitas_all'][$header->nama_aktivitas];
            $row[]           = '<b>' . (!empty($total_aktivitas) ? $total_aktivitas : 0) . '</b>';
        }
        $row[] = 'colspan';
        $data[] = $row;

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($periode_mulai, $periode_selesai, $id_group, $id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($periode_mulai, $periode_selesai, $id_group, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function download(){

        $periode_mulai   = $this->input->get('periode_mulai');
        $periode_selesai = $this->input->get('periode_selesai');
        $id_group        = $this->input->get('id_group');
        $nm_group        = $this->input->get('nm_group');
        $id_karyawan     = $this->input->get('id_karyawan');
        $nm_karyawan     = $this->input->get('nm_karyawan');


        $header   = "Sales Monitoring - Laporan Aktivitas ".$nm_group." ".$nm_karyawan;

        $filename = "Sales Monitoring - Laporan Aktivitas ".$periode_mulai." sd ".$periode_selesai." ".$nm_group." ".$nm_karyawan;

        $data['periode_mulai']   = $periode_mulai;
        $data['periode_selesai'] = $periode_selesai;
        $data['header']          = $header;
        $data['list']            = $this->model->get_datatables($periode_mulai, $periode_selesai, $id_group, $id_karyawan);
        $data['table_header']    = $this->model->table_header($periode_mulai, $periode_selesai);
        $data['get_aktivitas']   = $this->model->get_total_activity($periode_mulai, $periode_selesai, $id_group, $id_karyawan);

        $output  = true;
		$sb_view = $this->load->view('sales_activity/report/aktivitas/download', $data, $output);

        // START FORMAT COLUMN
        $format_columns = [
			'A'  => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
			'B'  => ['width' => 20, 'align' => 'center', 'valign' => 'middle', 'format'=>'text'],
			'C'  => ['width' => 30, 'align' => 'left', 'valign' => 'middle'],
		];

        for ($i = 4; $i <= (COUNT($data['table_header']))+4; $i++) {
            $alphabet = $this->_numberToLetters($i);
            $alphabet = strtoupper($alphabet);
            $format_columns[$alphabet] = ['width' => 18, 'align' => 'center', 'valign' => 'middle'];
        }
        // END FORMAT COLUMN

        // Bold Header & Footer Table
        $bold_footer = COUNT($data['list']) + 6;
        $thead = ['4', '5', strval($bold_footer)];

        $cLength = COUNT($data['table_header']) + 2;

        $param = [
			'download'    => true,
			'cLength'     => $cLength,
			'file_name'   => strtoupper($filename),
			'paper_size'  => 'LEGAL',
			'font-size'   => 11,
			'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
			'orientation' => 'landscape',
			'header'      => [
				'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
			],
			'freezecolumn' => ['D6'],
			'thead'        => $thead,
			'tbody'        => [
				'start'  => '4',
				'height' => 15,
				'wrap'   => ['B','C','D','E'],
				'column' => $format_columns,
			],
		];

		$this->load->library('PHPExcel/Excel');

		if ($output) {
			$this->excel->generateExcel($sb_view, $param);
		}
		exit;
    }

    public function dropdown_group(){
        $periode_mulai   = date_format(date_create($this->input->get("periode_mulai")),"Y-m-d");
        $periode_selesai = date_format(date_create($this->input->get("periode_selesai")),"Y-m-d");
        $search          = $this->input->get("q");
        return $this->model->dropdown_group($periode_mulai, $periode_selesai, $search);
    }

    public function dropdown_karyawan($tanggal_mulai = "", $tanggal_selesai=""){
        $periode_mulai   = date_format(date_create($this->input->get("periode_mulai")),"Y-m-d");
        $periode_selesai = date_format(date_create($this->input->get("periode_selesai")),"Y-m-d");
        $id_group        = $this->input->get("id_group");
        $search          = $this->input->get("q");
        return $this->model->dropdown_karyawan($periode_mulai, $periode_selesai, $id_group, $search);
    }

    private function _numberToLetters($number) {
		$letters = '';
		while ($number > 0) {
			$mod = ($number - 1) % 26;
			$letters = chr(97 + $mod) . $letters;
			$number = floor(($number - 1) / 26);
		}
		return $letters;
	}
}