<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pot_absensi extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/pengaturan/Pot_absensi_m', 'model');
        $this->load->library('form_validation');
    }

    public function index()
    {
        $data['judul']            = 'Pengaturan Umum';
        $data['aktif']            = 'pengaturan_pot_absensi';
        $data['menu']             = $this->load->view('main_menu', $data, true);
        $data['pengaturan_pph21'] = $this->model->getDataPengaturanPph21();
        $data['content']          = $this->load->view('payroll/pengaturan/potongan_absensi/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data()
    {
        $list = $this->model->get_datatables();
        $data = array();
        $no   = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            # JENIS
            switch ($field->jenis) {
                case 'terlambat':
                    $jenis = 'Terlambat';
                    break;
                case 'pc':
                    $jenis = 'Pulang Cepat';
                    break;
                case 'tap':
                    $jenis = 'Tidak Absen Pulang';
                    break;
                case 'alpa':
                    $jenis = 'Alpa';
                    break;

                default:
                    $jenis = '-';
                    break;
            }
            $row[] = $jenis;

            # FLAG AKTIF
            if ($field->flag_aktif == "1") {
                $row[] = '<label class="switch">
							<input id="' . md5($field->jenis) . '" data-flag="flag_aktif" type="checkbox" class="default" value="1" checked>
							<span class="slider round">Aktif</span>
						</label>';
            } else {
                $row[] = '<label class="switch">
							<input id="' . md5($field->jenis) . '" data-flag="flag_aktif" type="checkbox" class="default" value="0" >
							<span class="slider round">Nonaktif</span>
						</label>';
            }

            # FLAG PERSENTASE GAPOK
            if ($field->flag_persentase_gapok == "1") {
                $row[] = '<label class="switch">
							<input id="' . md5($field->jenis) . '" data-flag="flag_persentase_gapok" type="checkbox" class="default" value="1" checked>
							<span class="slider round">Ya</span>
						</label>';
                # PERSENTASE
                $editPersen = '
                <div class="input-group nominal-edit" data-btn="persen" style="display:none">
                    <input type="text" name="nominal" onkeyup="calculatePersentase(this)" class="form-control" value="' . str_replace('.00', '', $field->persentase) . '">
                    <div class="input-group-append">
                        <button class="btn_edit_nominal btn btn-primary" type="button"><i class="fa fa-check"></i></button>
                    </div>
                </div>';
                $nominalWithButton = '
                <div id="' . md5($field->jenis) . '" class="nominal-with-button btn_edit">
                    <span>' . str_replace('.00', '', $field->persentase) . '</span> %
                    <button type="button" class="btn btn-warning">
                        <i class="fa fa-edit (alias) "></i>
                    </button>
                </div>';
                $row[] = '<div class="nominal-form">' . $editPersen . $nominalWithButton . '</div>';
            } else {
                $row[] = '<label class="switch">
							<input id="' . md5($field->jenis) . '" data-flag="flag_persentase_gapok" type="checkbox" class="default" value="0" >
							<span class="slider round">Tidak</span>
						</label>';
                $row[] = '';
            }

            # NOMINAL POTONGAN
            $editNominal = '
            <div class="input-group nominal-edit" data-btn="nominal" style="display:none">
                <input type="text" name="nominal" onkeyup="format_amount($(this));" class="form-control" value="' . number_format($field->nominal_potongan, 0, ',', '.') . '">
                <div class="input-group-append">
                    <button class="btn_edit_nominal btn btn-primary" type="button"><i class="fa fa-check"></i></button>
                </div>
            </div>';
            if ($field->flag_persentase_gapok == "1") {
                $nominalWithButton = '';
            } else {
                $nominalWithButton = '
                <div id="' . md5($field->jenis) . '" class="nominal-with-button btn_edit">
                    <span>' . number_format($field->nominal_potongan, 0, ',', '.') . '</span>
                    <button type="button" class="btn btn-warning">
                        <i class="fa fa-edit (alias) "></i>
                    </button>
                </div>';
            }
            $row[] = '<div class="nominal-form">' . $editNominal . $nominalWithButton . '</div>';

            # MENIT
            if ($field->jenis == 'terlambat' || $field->jenis == 'pc') {
                $editNominal = '
                <div class="input-group nominal-edit" data-btn="menit" style="display:none">
                    <input type="text" name="nominal" oninput="format_amount($(this));" class="form-control" value="' . $field->menit . '">
                    <div class="input-group-append">
                        <button class="btn_edit_nominal btn btn-primary" type="button"><i class="fa fa-check"></i></button>
                    </div>
                </div>';
                $nominalWithButton = '
                <div id="' . md5($field->jenis) . '" class="nominal-with-button btn_edit">
                    <span>' . $field->menit . '</span> menit
                    <button type="button" class="btn btn-warning">
                        <i class="fa fa-edit (alias) "></i>
                    </button>
                </div>';
                $row[] = '<div class="nominal-form">' . $editNominal . $nominalWithButton . '</div>';
            } else {
                $row[] = '';
            }

            # KELIPATAN
            if ($field->jenis == 'terlambat' || $field->jenis == 'pc') {
                if ($field->kelipatan == "1") {
                    $row[] = '<label class="switch">
                                <input id="' . md5($field->jenis) . '" data-flag="kelipatan" type="checkbox" class="default" value="1" checked>
                                <span class="slider round">Ya</span>
                            </label>';
                } else {
                    $row[] = '<label class="switch">
                                <input id="' . md5($field->jenis) . '" data-flag="kelipatan" type="checkbox" class="default" value="0" >
                                <span class="slider round">Tidak</span>
                            </label>';
                }
            } else {
                $row[] = '';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_POST['draw'],
            "recordsTotal"    => $this->model->count_all(),
            "recordsFiltered" => $this->model->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form()
    {
        $this->load->view('payroll/pengaturan/potongan_absensi/form');
    }

    public function form_pph21()
    {
        $data['pengaturan_pph21'] = $this->model->getDataPengaturanPph21();
        $this->load->view('payroll/pengaturan/potongan_absensi/form_pph21', $data, false);
    }

    public function save()
    {
        $jenis   = $this->input->post('jenis');
        $nominal = $this->input->post('nominal_potongan');
        $menit   = $this->input->post('menit');
        $persen  = $this->input->post('persen');

        if ($persen != '') {
            $data = array('persentase' => $persen);
        } else if ($menit != '') {
            $data = array('menit' => $menit);
        } else {
            $data = array('nominal_potongan' => str_replace(".", "", $nominal));
        }

        $this->model->update($data, $jenis);
    }

    public function save_pph21()
    {
        $for_data       = $this->input->post('for_data');
        $aktif          = $this->input->post('aktif');
        $jenis_pot_pph  = $this->input->post('jenis_pot_pph');
        $nama_pemotong  = $this->input->post('nama_pemotong');
        $jenis_pemotong = $this->input->post('jenis_pemotong');
        $nomor_pemotong = $this->input->post('nomor_pemotong');

        // validasi
        if (!in_array($aktif, ['0', '1'])) {
            return __response_save(false, ['message' => [
                'aktif',
                "<i class='fa fa-exclamation-triangle'></i> Status aktif harus dipilih"
            ]]);
        }
        if (!$jenis_pot_pph) {
            return __response_save(false, ['message' => [
                'jenis_pot_pph',
                "<i class='fa fa-exclamation-triangle'></i> Jenis potongan harus dipilih"
            ]]);
        }

        if ($aktif == "1"){
            if (!$nama_pemotong) {
                return __response_save(false, ['message' => [
                    'nama_pemotong',
                    "<i class='fa fa-exclamation-triangle'></i> Nama pemotong harus diisi"
                ]]);
            }
            if (!$jenis_pemotong) {
                return __response_save(false, ['message' => [
                    'jenis_pemotong',
                    "<i class='fa fa-exclamation-triangle'></i> Jenis pemotong harus dipilih"
                ]]);
            }
            if (!$nomor_pemotong) {
                return __response_save(false, ['message' => [
                    'nomor_pemotong',
                    "<i class='fa fa-exclamation-triangle'></i> Nomor NPWP/Nomor KTP harus diisi"
                ]]);
            } else {
                if (!is_numeric($nomor_pemotong)) {
                    return __response_save(false, ['message' => [
                        'nomor_pemotong',
                        "<i class='fa fa-exclamation-triangle'></i> Nomor NPWP/Nomor KTP harus berupa angka"
                    ]]);
                }
            }
        }

        $data = array(
            'aktif'          => $aktif,
            'jenis'          => $jenis_pot_pph,
            'nm_pemotong'    => $nama_pemotong,
            'jenis_pemotong' => $jenis_pemotong
        );

        if ($jenis_pemotong == 'NPWP') {
            $data['npwp']   = $nomor_pemotong;
            $data['no_ktp'] = '';
        } else {
            $data['npwp']   = '';
            $data['no_ktp'] = $nomor_pemotong;
        }

        $this->model->save_pph21($data, $for_data);
    }

    public function update_flag()
    {
        $jenis      = $this->input->post('id_p');
        $for_flag   = $this->input->post('for_flag');
        $status     = $this->input->post('status');
        $persentase = $this->input->post('persentase');

        if ($for_flag == 'menit') {
            if ($status == '1') {
                $status = 'jam';
            } else {
                $status = 'menit';
            }
        }

        // if (preg_match('/^[0-9][0-9]?(\.[0-9]{0,2})?$/', $persentase)) {
        //     $persentase = $persentase;
        // }else{
        //     $persentase = '';
        // }

        if ($for_flag == 'flag_persentase_gapok') {
            $data = array(
                $for_flag => $status,
                'persentase' => $persentase
            );
        } else {
            $data = array(
                $for_flag => $status
            );
        }

        $this->model->update($data, $jenis);
    }

    // public function update_pot_pph()
    // {
    //     $jenis  = $this->input->post('jenis_pph');
    //     $update = $this->model->update_pot_pph($jenis);
    // }
}
