<div class="position-relative pull-right" style="top: -2.5em;">
    <button id="view-table" type="button" class="ml-1 btn btn-biru ladda-button" data-style="expand-left">
        <i class="fa fa-table"></i> View Table
    </button>
</div>

<div class="pt-2">
    <div class="position-absolute pt-1 w-100 text-right" style="right: 15px;">
        <button id="download-diagram" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <div class="w-100 mt-1" style="overflow-x: auto;">
        <div style="height: 60vh;">
            <canvas id="grafik_poin_mingguan"></canvas>
        </div>
    </div>
</div>

<script>
    $(function() {
        initChart();

        $("#view-table").click(function() {
            list_datatable("table", this);
        });

        $("#download-diagram").click(function() {
            downloadChartImage("Report Poin Mingguan", ctxGrafikPoinMingguan, this);
        });

        let periode     = "<?= $periode ?>";
        let id_group    = "<?= $id_group ?>";
        let id_karyawan = "<?= $id_karyawan ?>";
        view_diagram(periode, id_group, id_karyawan);
    });

    var ctxGrafikPoinMingguan = document.getElementById('grafik_poin_mingguan').getContext('2d');
    var grafikPoinMingguan;

    function initChart() {
        grafikPoinMingguan = new Chart(ctxGrafikPoinMingguan, {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                        label: "Target Poin",
                        borderColor: "#007aff",
                        backgroundColor: "rgba(0, 122, 255, 0.03)",
                        fill: true,
                        tension: 0.1,
                        data: [],
                    },
                    {
                        label: "Realisasi",
                        borderColor: "#ff9500",
                        backgroundColor: "rgba(255, 149, 0, 0.03)",
                        fill: true,
                        tension: 0.1,
                        data: [],
                    },
                ],
            },
            options: {
                maintainAspectRatio: false,
                responsive: true,
                layout: {
                    padding: {
                        left: 20,
                        right: 20,
                        top: 20,
                        bottom: 10
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                    },
                    x: {
                        grid: {
                            display: false
                        },
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        align: 'start',
                        text: '',
                        color: '#1c77d4',
                        font: {
                            size: 16,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 10
                        }
                    },
                    subtitle: {
                        display: true,
                        align: 'start',
                        text: '',
                        font: {
                            size: 14,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 20
                        }
                    },
                    legend: {
                        labels: {
                            boxWidth: 40,
                        },
                        display: true,
                        position: 'bottom',
                    },
                }
            }
        });
    }

    function view_diagram(periode="00-0000", id_group="all", id_karyawan="all") {
        return $.get("<?= route('sales_activity.report.poin.mingguan.diagram.data.list') ?>"+
                                    '?periode='+periode+
                                    '&id_group='+id_group+
                                    '&id_karyawan='+id_karyawan, function(data) {
            var result = JSON.parse(data);

            grafikPoinMingguan.data.labels = result.minggu_ke;
            grafikPoinMingguan.data.datasets[0].data = result.target_poin;
            grafikPoinMingguan.data.datasets[1].data = result.realisasi;

            grafikPoinMingguan.options.scales.y.steps = 0
            grafikPoinMingguan.options.scales.y.max = result.max;
            grafikPoinMingguan.options.scales.y.ticks.stepSize = result.max / 10;

            if (id_karyawan == "all") {
                if(id_group == "all"){
                    grafikPoinMingguan.options.plugins.title.text = 'Report Poin Mingguan Semua Sales';
                }else{
                    let nama_group = $('#id_group').select2('data')[0].text;
                    grafikPoinMingguan.options.plugins.title.text = 'Report Poin Mingguan '+ucwords(nama_group.split('-')[1].trim().toLocaleLowerCase());
                }
            } else {
                let nama_sales = $('#id_karyawan').select2('data')[0].text;
                grafikPoinMingguan.options.plugins.title.text = 'Report Poin Mingguan ' + ucwords(nama_sales.split('-')[1].trim().toLocaleLowerCase());
            }
            grafikPoinMingguan.options.plugins.subtitle.text = 'Bulan <?= $periode ?>';

            grafikPoinMingguan.update();
        });
    }
</script>
