<script>
    $(function() {
        dropdown_periode();
        dropdown_group();
        dropdown_karyawan();
        list_datatable("table");

        $("#btn_filter").on("click", function() {
            if ($("#view-table").length) {
                list_datatable("chart", this);
            } else {
                list_datatable("table", this);
            }
        });
    });

    function dropdown_periode() {
        $(".filter #periode").inputmask({
            'alias': 'datetime',
            'inputFormat': 'yyyy'
        });

        $(".filter #periode").datepicker({
            format: "yyyy",
            viewMode: "years",
            orientation: 'bottom',
            minViewMode: "years",
            autoclose: true,
        });
    }

    function dropdown_group() {
        let periode = $(".filter #periode").val();
        $(".filter #id_group").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.poin.bulanan.dropdown.group") ?>'+'?periode='+periode,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function dropdown_karyawan() {
        let periode  = $(".filter #periode").val();
        let id_group = (!$('.filter #id_group').val())?"all":$('.filter #id_group').val();

        $(".filter #id_karyawan").select2({
            placeholder: "Semua Sales",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.poin.bulanan.dropdown.karyawan") ?>'+'?periode='+periode+'&id_group='+id_group,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_dropdown_periode(){
        $(".filter #id_group").val('').trigger('change');
        $(".filter #id_karyawan").val('').trigger('change');
        dropdown_group();
        dropdown_karyawan();
    }

    function onchange_dropdown_group() {
        $(".filter #id_karyawan").val('').trigger('change');
        dropdown_karyawan();
    }


    function list_datatable(view = "table", e = "") {
        if (e !== "") {
            var loading = Ladda.create(e);
            loading.start();
        }
        var load_url = "";
        if (view === "table") {
            load_url = "<?= route('sales_activity.report.poin.bulanan.table.data.view') ?>";
        } else {
            load_url = "<?= route('sales_activity.report.poin.bulanan.diagram.data.view') ?>";
        }
        return $.get(load_url, function(data) {
            $("#view_data").html(data);
            if (e !== "") loading.stop();
        });
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Report Poin Bulanan</h5>
    </div>
</div>
<hr>

<div class="filter row">
        <div class="col-md-3">
            <label><?= $this->lang->line('tahun'); ?></label>
            <input type="text" id="periode" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('Y') ?>" onchange="onchange_dropdown_periode()">
        </div>

        <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
            <div class="col-md-3">
                <label><?= $this->lang->line('group_area'); ?></label>
                <select id="id_group" class="form-control" style="width: 100%" onchange="onchange_dropdown_group()"></select>
            </div>
        <?php endif; ?>

        <div class="col-md-3">
            <label>Sales</label>
            <select id="id_karyawan" class="form-control" style="width: 100%"></select>
        </div>

        <div class="col-md-1 align-self-end">
            <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </div>
    </div>
</div>


<div id="view_data"></div>
