<script type="text/javascript">
    $(function() {
        list_data_m_lead = $('#list_data_m_lead').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama Lead Source'
                <?php else : ?> 'searchPlaceholder': 'Lead Source Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.master.lead.source.list.data') ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({'text-align': 'center', 'width': '30px'});
                $('td:eq(2)', nRow).css({'text-align': 'center', 'width': '10px'});
            }
        });

        $('#list_data_m_lead').sortable({
            items: "tr",
            cursor: "move",
            handle: "span.sort",
            placeholder: "ui-state-highlight",
            update: function() {
                var order = [];
                $('#list_data_m_lead tbody tr').each(function(index, element) {
                    order.push({
                        id_lead_m: $(this).find("td:eq(0) span").data("key"),
                        no_urut: index + 1
                    });
                });
                // console.log(order);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "<?= route("sales_activity.master.lead.source.order") ?>",
                    data: {
                        order: order,
                    },
                    success: function(response) {
                        if (response.status == "success") {
                            console.log(response);
                        } else {
                            console.log(response);
                        }
                    }
                });
            }
        });
    });
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Master <?= $this->lang->line('lead_source') ?></h5>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <button type="button" class="btn btn_tambah_m_lead btn-success pull-right">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div> 
<hr>

<div class="table-responsive mt-2">
    <table id="list_data_m_lead" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_lead') ?></th>
                <th class="text-center align-middle text-uppercase" width="50"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
