<script type="text/javascript">
    $(document).ready(function() {
        $("#id_shift").select2({
            placeholder: "<?= $this->lang->line('pilih_shift') ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.shift.nama")."/".$data->id_cabang ?>',
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_shift_karyawan" class="form-control" value="<?= md5($data->id_shift_karyawan) ?>">

    <div class="form-group">
        <label><?= $this->lang->line('nama_karyawan'); ?></label>
        <p class="font-weight-bold"><?= $data->nik." - ".$data->nama_karyawan ?></p>
    </div>
    <div class="form-group">
        <label><?= $this->lang->line('tgl'); ?></label>
        <p class="font-weight-bold"><?= date_format(date_create($data->tanggal),"d-m-Y") ?></p>
    </div>

    <?php
    if ($cek_absen > 0) { ?>
        <div class="form-group">
            <label>Shift</label>
            <?php
                    $jam_masuk  = date_format(date_create($data->jam_masuk),"H:i");
                    $jam_pulang = date_format(date_create($data->jam_pulang),"H:i");
                ?>
            <p class="font-weight-bold"><?= $data->kode_shift." - ".$data->nama_shift."(".$jam_masuk." - ".$jam_pulang.")" ?></p>
        </div>
    <?php }else{ ?>
        <div class="form-group">
            <label>Shift <i class="text-danger">*</i></label>
            <select id="id_shift"  class="form-control" class="select2 form-control" style="width:100%">
                <?php
                    $jam_masuk  = date_format(date_create($data->jam_masuk),"H:i");
                    $jam_pulang = date_format(date_create($data->jam_pulang),"H:i");
                ?>
                <option value="<?=$data->id_master_shift?>" selected><?= $data->kode_shift." - ".$data->nama_shift."(".$jam_masuk." - ".$jam_pulang.")" ?></option>
            </select>
        </div>
    <?php } ?>
</div>
<div class="card-footer">
    <div class="row">
        <?php
            if ($cek_absen > 0) { ?>
                <div class="col-md-12">
                    <div class="alert alert-info" role="alert">
                        <i class="fa fa-info-circle" aria-hidden="true"></i> 
                        <?= $this->lang->line('karyawan_sudah_absen'); ?>
                    </div>
                </div>
        <?php }else{ ?>
            <div class="col-md-7 text-left">
                <div id="message_jadwal_shift"></div>
            </div>
            <div class="col-md-5 text-right">
                <button id="btn_update" onclick="edit()" class="btn btn-warning ladda-button" data-style="expand-left">
                    <i class="fa fa-edit (alias)"></i> <?= $this->lang->line('button_form_perbarui'); ?>
                </button>
            </div>
        <?php } ?>
    </div>
</div>