<script type="text/javascript">
    $(function() {
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function(e, settings, techNote, message) {
            if (confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'stateSave': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'NIK/Nama Karyawan'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('payroll.gaji.ptkp.data') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                "aTargets": [0, 2, -1],
                "className": "text-center"
            }],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(-1)', nRow).css({
                    'text-align': 'center',
                    'width': '30px'
                });
            }

        });

        $(document).on('click', '#ptkp .btn_edit', function() {
            var row = this.closest('tr');
            row.children[2].querySelector('select').className = "form-control";
            row.children[2].querySelector('span').className = "hidden";

            this.closest('td').querySelector('#save').className = "";
            this.closest('td').querySelector('#edit').className = "hidden";
        });

        $(document).on('click', '#ptkp .btn_save', function(e) {
            e.preventDefault();

            const row = this.closest('tr');
            const selects = row.querySelector('select');

            var params = {};
            params.id = $(this).attr('id');
            params.ptkp = selects.value;

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.gaji.ptkp.save') ?>",
                data: params,
                dataType: 'JSON',
                beforeSend: function() {
                    loading_start(row, selects);
                },
                success: function(result) {
                    if (result.success == true) {
                        loading_stop(row, selects, true);
                        list_data.ajax.reload();
                    } else {
                        loading_stop(row, selects, false);
                        showMsg(result.message, false);
                    }
                },
                error: function() {
                    loading_stop(row, selects, false);
                    showMsg('error', false);
                }
            });
        });

        $(document).on('click', '#ptkp .btn_batal', function() {
            var row = this.closest('tr');
            let selectElement = row.children[2].querySelector('select');
            selectElement.className = "hidden";
            selectElement.value = selectElement.getAttribute("data-old");
            row.children[2].querySelector('span').className = "";

            this.closest('td').querySelector('#save').className = "hidden";
            this.closest('td').querySelector('#edit').className = "";
        });
    });


    function loading_start(row, selects) {
        var loading = row.querySelector('.custom-loader');

        row.querySelector('#save').className = "hidden";
        loading.className = "custom-loader";
        selects.disabled = true;
    }

    function loading_stop(row, selects, hidden = true) {
        var loading = row.querySelector('.custom-loader');

        if (hidden) {
            row.querySelector('#edit').className = "";
        } else {
            row.querySelector('#edit').className = "hidden";
            row.querySelector('#save').className = "";
        }
        loading.className = "custom-loader hidden";
        selects.disabled = false;
    }
</script>
<style>
    .custom-loader {
        width: 25px;
        height: 25px;
        border-radius: 50%;
        border: 4px solid;
        border-color: #E4E4ED;
        border-right-color: #1c77d4;
        animation: s2 1s infinite linear;
    }

    @keyframes s2 {
        to {
            transform: rotate(1turn)
        }
    }
</style>
<div class="content-header mt-4">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item"><a href="<?= route('payroll.gaji.home') ?>">Hitung Gaji</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('payroll.gaji.home') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-bordered table-striped" style="width:100%">
                    <thead>
                        <th class="text-center text-uppercase">No</th>
                        <th class="text-center text-uppercase">Nama Karyawan</th>
                        <th class="text-center text-uppercase">PTKP</th>
                        <th class="text-center text-uppercase">Aksi</th>
                    </thead>
                    <tbody id="ptkp">
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
