<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({
            'searching': false,
            'paging': false,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language'    :{
                                'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                'searchPlaceholder': ''
                            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('kpi.pengaturan.predikat.data') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0],
                    "bSortable": false
                },

            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                $('td:eq(1)', nRow).css({
                    'text-align': 'center'
                });
                
                $('td:eq(2)', nRow).css({
                    'text-align': 'center'
                });

                $('td:eq(3)', nRow).css({
                    'text-align': 'center'
                });

                $('td:eq(4)', nRow).css({
                    'text-align': 'center'
                });

                $('td:eq(5)', nRow).css({
                    'text-align': 'center',
                    'width': '15px'
                });

                $('th:eq(4)', nRow).css({
                    'text-align': 'right'
                });
            }

        });
    });
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Predikat</h5>
    </div>
</div>
<hr>

<div class="table-responsive mt-2">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle" rowspan="2">No</th>
                <th class="text-center align-middle" rowspan="2">Grade</th>
                <th class="text-center align-middle" colspan="2">Poin</th>
                <th class="align-middle" rowspan="2">Keterangan</th>
                <th class="align-middle" rowspan="2">Aksi</th>
            </tr>
            <tr>
                <th class="text-center">Batas Bawah</th>
                <th class="text-center">Batas Atas</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>