<script type="text/javascript">
    $(function() {
        data_dashboard();
        list_data();
        dropdown_cabang();
        dropdown_departemen();
        dropdown_jam_kerja();
        $(document).on('click', '#btn_search', function() {
            data_dashboard();
            list_data();
        });
        filter();
    });

    function data_dashboard() {
        var level_user = '<?= $level_user ?>';
        var multi_departemen = '<?= $multi_departemen ?>';
        var multi_cabang = '<?= $multi_cabang ?>';

        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = ($("#cabang").val() == null || $("#cabang").val() == '') ? "all" : $("#cabang").val();
            var id_departemen = ($("#departemen").val() == null || $("#departemen").val() == '') ? "all" : $("#departemen").val();
        } else if (level_user == "5") {
            var id_cabang = "<?= $this->session->userdata('id_cabang') ?>";
            var id_departemen = ($("#departemen").val() == null || $("#departemen").val() == '') ? "all" : $("#departemen").val();
        } else {
            var id_cabang = "<?= $this->session->userdata('id_cabang') ?>";
            var id_departemen = "<?= $this->session->userdata('id_departemen') ?>";
        }

        var jadwal_kerja = (!$("#jam_kerja").val()) ? "all" : $("#jam_kerja").val();

        $.ajax({
            type: 'GET',
            dataType: 'json',
            url: '<?= site_url("dashboard/absensi/detail/data_dashboard") ?>/' + id_cabang + '/' + id_departemen + '/' + jadwal_kerja + '/' + $("#kehadiran").val(),
        }).then(function(data) {
            $("#hadir").html(": " + data.hadir);
            $("#terlambat").html(": " + data.terlambat);
            $("#belum_absen").html(": " + data.belum_absen);
            $("#izin").html(": " + data.izin);
            $("#cuti").html(": " + data.cuti);
            $("#sakit").html(": " + data.sakit);
        });
    }

    function list_data() {
        var level_user = '<?= $level_user ?>';
        var multi_departemen = '<?= $multi_departemen ?>';
        var multi_cabang = '<?= $multi_cabang ?>';
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = ($("#cabang").val() == null || $("#cabang").val() == '') ? "all" : $("#cabang").val();
            var id_departemen = ($("#departemen").val() == null || $("#departemen").val() == '') ? "all" : $("#departemen").val();
        } else if (level_user == "5") {
            var id_cabang = "<?= $this->session->userdata('id_cabang') ?>";
            var id_departemen = ($("#departemen").val() == null || $("#departemen").val() == '') ? "all" : $("#departemen").val();
        } else {
            var id_cabang = "<?= $this->session->userdata('id_cabang') ?>";
            var id_departemen = "<?= $this->session->userdata('id_departemen') ?>";
        }

        var jadwal = (!$('#jam_kerja').val()) ? "all" : $('#jam_kerja').val();
        var status = $('#kehadiran').val();

        $('#view_data').load("<?php echo site_url('dashboard/absensi/detail/view-data') ?>" + "/" + id_cabang + '/' + id_departemen + '/' + jadwal + '/' + status);
    }

    function filter() {
        $("#kehadiran").select2({
            ajax: {
                url: '<?= site_url("dashboard/absensi/detail/list_absensi") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
    }

    function dropdown_cabang() {
        $('#cabang').select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function onchange_dropdown_cabang() {
        dropdown_departemen();
        dropdown_jam_kerja();

        $('#departemen').val('0').trigger("change");
        $('#jam_kerja').val('0').trigger("change");
    }

    function dropdown_departemen() {
        var level_user = '<?= $level_user ?>';
        var multi_departemen = '<?= $multi_departemen ?>';
        var multi_cabang = '<?= $multi_cabang ?>';
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = ($("#cabang").val() == null || $("#cabang").val() == '') ? "all" : $("#cabang").val();
        } else {
            var id_cabang = "<?= $this->session->userdata('id_cabang') ?>";
        }

        $('#departemen').select2({
            placeholder: '<?= $this->lang->line('semua_departemen') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>' + '/' + id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_jam_kerja() {
        var level_user = '<?= $level_user ?>';
        var multi_departemen = '<?= $multi_departemen ?>';
        var multi_cabang = '<?= $multi_cabang ?>';
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = ($("#cabang").val() == null || $("#cabang").val() == '') ? "all" : $("#cabang").val();
        } else {
            var id_cabang = "<?= $this->session->userdata('id_cabang') ?>";
        }

        $("#jam_kerja").select2({
            placeholder: '<?= $this->lang->line('semua') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.jamkerja") ?>' + '/' + id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
        </div>
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <div class="float-right">
                <a href="<?= route('dashboard.absensi'); ?>" class="btn btn-secondary">
                    <i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?>
                </a>
            </div>
        </div>
    </div><br>
    <div class="table-responsive">
        <table class="table">
            <tbody>
                <tr>
                    <th><?= $this->lang->line('sudah_absen') ?></th>
                    <th id="hadir" class="font-weight-bold">:</th>
                    <th><?= $this->lang->line('terlambat') ?></th>
                    <th id="terlambat" class="font-weight-bold">:</th>
                    <th><?= $this->lang->line('belum_absen') ?></th>
                    <th id="belum_absen" class="font-weight-bold">:</th>
                </tr>
                <tr>
                    <th><?= $this->lang->line('cuti') ?></th>
                    <th id="cuti" class="font-weight-bold">:</th>
                    <th><?= $this->lang->line('izin') ?></th>
                    <th id="izin" class="font-weight-bold">:</th>
                    <th><?= $this->lang->line('sakit') ?></th>
                    <th id="sakit" class="font-weight-bold">:</th>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row filter">
                <?php
                if (in_array($level_user, array("1", "4")) || $multi_cabang == true) {
                ?>
                    <div class="col-md-3">
                        <label><?= $this->lang->line('cabang') ?></label>
                        <select id="cabang" class="form-control" class="select2 form-control" onchange="onchange_dropdown_cabang()">
                            <?php
                            if ($id_cabang != "0") {
                            ?>
                                <option value="<?= $cabang_selected->id_cabang ?>" selected><?= $cabang_selected->kode . " - " . $cabang_selected->nama ?></option>
                            <?php
                            }
                            ?>
                        </select>
                    </div>
                <?php
                }
                ?>

                <?php
                if (in_array($level_user, array("1", "4", "5")) || $multi_departemen == true) {
                ?>
                    <div class="col-md-3">
                        <label><?= $this->lang->line('departemen') ?></label>
                        <select id="departemen" class="form-control" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        </select>
                    </div>
                <?php
                }
                ?>
                <div class="col-md-2">
                    <label><?= $this->lang->line('jadwal_kerja') ?></label>
                    <select class="form-control" id="jam_kerja">
                        <?php
                        if ($id_shift == '0') {
                        ?>
                            <option value="0" selected="true"><?= $this->lang->line('reguler') ?></option>
                        <?php
                        } else if ($id_shift == "all") {
                        ?>
                            <option value="all" selected="true"><?= $this->lang->line('semua') ?></option>
                        <?php
                        } else {
                        ?>
                            <option value="<?= $shift_selected->id_shift ?>" selected="true"><?= $shift_selected->kode_shift . " - " . $shift_selected->nama_shift ?></option>
                        <?php
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label>Status</label>
                    <select class="form-control" id="kehadiran">
                        <option value="H" selected="true"><?= strtoupper($this->lang->line('hadir')) ?></option>
                    </select>
                </div>
                <div class="col-md-2 align-self-end">
                    <button type="button" id="btn_search" class="btn btn-success ladda-button" data-style="expand-left"><?= $this->lang->line('button_tampilkan') ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div id="view_data" class="col-md-12 bbna"></div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
