[//]: # ([author] Anderson Salas)
[//]: # ([meta_description] Las rutas de Luthier CI también funcionan para la línea de comandos, y aquí te explicamos cómo usarlas)

# Línea de Comandos

### Contenido

1. [Introducción](#introduction)
2. [Sintaxis](#syntax)
3. [Usando rutas CLI](#using-cli-routes)
4. [Herramientas CLI incorporadas](#built-in-cli-tools)
   1. [Activación](#activation)
   2. [Comando 'luthier make'](#luthier-make)
   3. [Comando 'luthier migrate'](#luthier-migrate)

### <a name="introduction"></a> Introducción

Gracias a Luthier CI puedes aprovechar aún más las posibilidades que ofrece el framework a través de la interfaz de línea de comandos (CLI)

### <a name="syntax"></a> Sintaxis

Las rutas CLI son parecidas a las rutas HTTP y AJAX en cuanto a su sintaxis. Éstas rutas se deben definir en el archivo `application/routes/cli.php`

Ejemplo:

```php
<?php
# application/routes/cli.php

// Usando funciones anónimas
Route::cli('test', function(){ // <- (nota que aquí el método es 'cli' y no 'get', 'post', etc.)
    echo 'Hello world!';
});

// Apuntando a un controlador existente
Route::cli('test2', 'foo@bar');
```

Las rutas CLI comparten las mismas propiedades de sus homólogas HTTP/AJAX, puedes aprender más sobre ellas [aquí](./routes#syntax).

### <a name="using-cli-routes"></a> Usando rutas CLI

Para acceder a las rutas CLI debes llamar al intérprete de PHP desde la línea de comandos en el archivo `index.php` de la carpeta raíz de tu aplicación, separando con espacios cada segmento de la ruta deseada, por ejemplo:

```
$ php path/to/app/index.php [segment1] [segument2] ... [segmentN]
```

Así pues, teniendo esta ruta:

```php
Route::cli('make/controller/{name}', function($name){
    echo 'Making the controller ' . $name ;
});
```

Se puede acceder a ella ejecutando:

```
$ php path/to/app/index.php make controller test
```

Y el resultado sería:

```
Making the controller test
```

### <a name="built-in-cli-tools"></a> Herramientas para CLI incorporadas

A partir de la versión 0.2.0 Luthier CI viene con varias herramientas para línea de comandos que te ayudarán con algunas tareas repetitivas.

<div class="alert alert-warning">
    <i class="fa fa-warning" aria-hidden="true"></i>
    <strong>Permisos de escritura</strong>
    <br />
    Asegúrate de que la carpeta <code>application</code> tenga permisos de escritura para que estos comandos funcionen correctamente
</div>

<div class="alert alert-info">
    <i class="fa fa-info-circle" aria-hidden="true"></i>
    <strong>Sólo disponibles para desarrollo</strong>
    <br />
    Por motivos de seguridad, éstos comandos se desactivarán si tu aplicación está configurada con los entornos <code>testing</code> o <code>production</code>
</div>

#### <a name="activation"></a> Activación

Las herramientas CLI vienen desactivadas por defecto. Para activarlas, sólo basta con añadir un par de líneas a tu archivo de rutas:

```php
<?php
# application/routes/cli.php


Luthier\Cli::maker();      // Comando 'luthier make'
Luthier\Cli::migrations(); // Comando 'luthier migrate'
```

#### <a name="luthier-make"></a> Comando <kbd>luthier make</kbd>

Permite generar una amplia variedad de archivos del framework.

Sintaxis:

```
$ php index.php luthier make [resource] [name] [type?(sequenatial|date)=date]
```

Donde `resource` es el tipo de recurso (`controller`, `model`, `helper`, `library`, `middleware` o `migration`), `name` es el nombre
del recurso y `type` (en caso de crear una migración) es el tipo de migración a generar.

Ejemplos:

```
// Creando un controlador:
$ php index.php luthier make controller ControllerName

// Creando un modelo:
$ php index.php luthier make model ModelName

// Creando una librería:
$ php index.php luthier make library LibraryName

// Creando un helper:
$ php index.php luthier make helper HelperName

// Creando un middleware:
$ php index.php luthier make middleware MiddlewareName

// Creando una migración (por defecto, las migraciones son creadas por fecha)
$ php index.php luthier make migration create_users_table
$ php index.php luthier make migration create_users_table date
$ php index.php luthier make migration create_users_table sequential
```

#### <a name="luthier-migrate"></a> Comando <kbd>luthier migrate</kbd>

Corre (o revierte) una migración.

Sintaxis:

```
$ php index.php luthier migrate [version?=latest]
```

Donde `version` es la versión de la migración a correr. Si se omite, se procederá a migrar a la última versión disponible.
Tambien es posible utilizar uno de estos comandos especiales como `version`:

* `reverse`: revierte TODAS las migraciones
* `refresh`: revierte TODAS las migraciones y luego procede a migrar a la última versión disponible

Ejemplos:

```
$ php index.php luthier migrate reverse
$ php index.php luthier migrate refresh
```
