<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Data_sales_m extends CI_Model
{
    var $table = 'data_karyawan';
    
    function get_datatables($bulan = "00-0000", $id_karyawan = "all", $nama_group = "all")
    {
        $this->_get_datatables_query($bulan, $id_karyawan, $nama_group);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($bulan = "00-0000", $id_karyawan = "all", $nama_group = "all")
    {
        $this->_get_datatables_query($bulan, $id_karyawan, $nama_group);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($bulan = "00-0000", $id_karyawan = "all", $nama_group = "all")
    {
        $this->_get_datatables_query($bulan, $id_karyawan, $nama_group);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($bulan = "00-0000", $id_karyawan = "all", $nama_group = "all")
    {
        // $check_sa        = $this->fungsi->check_atasan_get_bawahan_sa();
        $id_karyawan_arr = $this->_get_id_karyawan_union($bulan, $nama_group);
        $id_karyawan_arr = !empty($id_karyawan_arr) ? $id_karyawan_arr : [""];

        $tahapan_arr = $this->get_tahapan_trx($bulan);
        foreach ($tahapan_arr as $value) {
            $this->db->select(
                "
                SUM(
                    IF(id_tahapan = '" . $value->id_tahapan_m . "', pipeline_trx.nominal_layanan, 0)
                ) AS nominal___" . $value->id_tahapan_m
                    .
                    ", SUM(
                    IF(id_tahapan = '" . $value->id_tahapan_m . "', 1, 0)
                ) AS jumlah_po___" . $value->id_tahapan_m
            );
        }

        $this->db->select("
                karyawan.id_karyawan,
                karyawan.nik,
                karyawan.nama_lengkap,
            ")
            ->from($this->table . " AS karyawan")
            ->join(
                "sales_pipeline_trx AS pipeline_trx",
                "pipeline_trx.id_karyawan = karyawan.id_karyawan
                    AND CONCAT(pipeline_trx.bulan,'-',pipeline_trx.tahun) = '" . $bulan . "'",
                "LEFT"
            )
            ->where("karyawan.id_company", $this->id_company)
            ->where_in('karyawan.id_karyawan', $id_karyawan_arr);
        
        // Filter Id Karyawan
        if(!empty($id_karyawan)){
            if($id_karyawan != "all"){
                $this->db->where('karyawan.id_karyawan', $id_karyawan);
            }
        }else{
            // if($check_sa['is_atasan'] == true){
            //     $this->db->where_in('karyawan.id_karyawan', $check_sa['list_bawahan']);
            // }
        }

        $this->db->group_by("karyawan.id_karyawan");

        $column_search = array('karyawan.nama_lengkap');
        $i             = 0;
        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        // $column_order = array('', '');
        if (isset($_GET['order'])) {
            //   $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("karyawan.nama_lengkap" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    // Untuk Footer Grand Total
    public function get_total_jumlah_dan_nominal($bulan = "00-0000", $id_karyawan = "all", $nama_group = "all")
    {
        $check_sa        = $this->fungsi->check_atasan_get_bawahan_sa();
        $id_karyawan_arr = $this->_get_id_karyawan_union($bulan, $nama_group);
        $id_karyawan_arr = !empty($id_karyawan_arr) ? $id_karyawan_arr : [""];
 
        $tahapan_arr = $this->get_tahapan_trx($bulan);
        foreach ($tahapan_arr as $value) {
            $this->db->select(
                "
                SUM(
                    IF(id_tahapan = '" . $value->id_tahapan_m . "', pipeline_trx.nominal_layanan, 0)
                ) AS nominal___" . $value->id_tahapan_m
                    .
                    ", SUM(
                    IF(id_tahapan = '" . $value->id_tahapan_m . "', 1, 0)
                ) AS jumlah_po___" . $value->id_tahapan_m
            );
        }
 
        $this->db->from($this->table . " AS karyawan");
        $this->db->join(
            "sales_pipeline_trx AS pipeline_trx",
            "pipeline_trx.id_karyawan = karyawan.id_karyawan
                AND CONCAT(pipeline_trx.bulan,'-',pipeline_trx.tahun) = '" . $bulan . "'",
            "LEFT"
        );
 
         $this->db->where("karyawan.id_company", $this->id_company);
         $this->db->where_in('karyawan.id_karyawan', $id_karyawan_arr);
         $this->db->group_by("karyawan.id_company");
         
        // Filter Id Karyawan
        if(!empty($id_karyawan)){
            $this->db->where('karyawan.id_karyawan', $id_karyawan);
        }else{
            if($check_sa['is_atasan'] == true){
                $this->db->where_in('karyawan.id_karyawan', $check_sa['list_bawahan']);
            }
        }
 
        $query = $this->db->get()->row();
        $total = array();
        foreach ($tahapan_arr as $value) {
            $var_nominal_layanan = "nominal___" . $value->id_tahapan_m;
            $var_jumlah_po       = "jumlah_po___" . $value->id_tahapan_m;

            $total[$value->id_tahapan_m]['jumlah']  += (int)$query->$var_jumlah_po;
            $total[$value->id_tahapan_m]['nominal'] += (int)$query->$var_nominal_layanan;
        }

        return $total;
    }

    function get_tahapan_trx($bulan = "")
    {
        return $this->db->select('id_tahapan_m, jenis, nama, warna')
            ->from('sales_tahapan_trx')
            ->where("id_company", $this->id_company)
            ->where("CONCAT(bulan,'-',tahun) =", $bulan)
            ->order_by("no_urut ASC")
            ->get()
            ->result();
    }

    // Dropdown Group
    public function dropdown_nama_group($bulan="", $search=""){
        $sql_where = "";
        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $kode_nama_group = $this->_get_kode_nama_group($this->sales_admin_group);
                $sql_where       = "AND combined.nama_group IN ('" .implode("', '", $kode_nama_group). "')";
            }
        }

        $binding[] = $bulan;
        $binding[] = "%".$search."%";

        $sql = "
            SELECT * FROM (
                SELECT 
                    CONCAT(kode, ' - ', nama) AS nama_group
                FROM sales_group_m 
                WHERE id_company = '" . $this->id_company . "'

                UNION ALL

                SELECT 
                    nama_group 
                FROM sales_pipeline_trx
                WHERE id_company = '" . $this->id_company . "'
                AND CONCAT(bulan,'-',tahun) = ?
                AND nama_group != ''
                GROUP BY nama_group
            ) AS combined
            WHERE combined.nama_group LIKE ?
            ".$sql_where."
            GROUP BY combined.nama_group
            ORDER BY combined.nama_group ASC
        ";

        $result = $this->db->query($sql, $binding)->result();

        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id' => $rows->nama_group, 'text' => $rows->nama_group];
        }
        echo json_encode($json);
    }

    // Get Id Karyawan Union
    private function _get_id_karyawan_union($periode = "", $nama_group="all")
    {   
        $binding[] = $periode;

        $sql_where = "";
        $admin_sales_bukan_all = false;
        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $kode_nama_group = $this->_get_kode_nama_group($this->sales_admin_group);
                $sql_where       = "WHERE combined.nama_group IN ('" .implode("', '", $kode_nama_group). "')";
                $admin_sales_bukan_all = true;
            }
        }

        $sql_where_2 = "";
        if($nama_group != "all"){
            if($admin_sales_bukan_all){
                $sql_where_2 = "AND combined.nama_group = ?";
            }else{
                $sql_where_2 = "WHERE combined.nama_group = ?";
            }

            $binding[] = urldecode($nama_group);
        }

        $sql = "
            SELECT id_karyawan FROM (
                SELECT 
                    sa.id_karyawan,
                    CONCAT(kode, ' - ', nama) AS nama_group
                FROM sales_approver AS sa
                JOIN sales_group_m AS sgm
                    ON sgm.id_group_m = sa.id_group_m
                WHERE sa.id_company = '" . $this->id_company . "'
                AND sa.status = '1'

                UNION ALL

                SELECT 
                    id_karyawan,
                    nama_group 
                FROM sales_pipeline_trx
                WHERE id_company = '" . $this->id_company . "'
                AND CONCAT(bulan,'-',tahun) = ?
                GROUP BY id_karyawan
            ) AS combined
            ".$sql_where."
            ".$sql_where_2."
            GROUP BY combined.id_karyawan
        ";

        $query = $this->db->query($sql, $binding)->result();

        $data = array();
        foreach ($query as $value) {
            $data[] = $value->id_karyawan;
        }

        return $data;
    }

    // Get Concat Kode Nama Group
    private function _get_kode_nama_group(){
        $query = $this->db->select("CONCAT(kode, ' - ', nama) AS nama_group")
                        ->from("sales_group_m")
                        ->where("id_company", $this->id_company)
                        ->where_in('id_group_m', explode(',', $this->sales_admin_group))
                        ->get()
                        ->result();

        $data = [];
        foreach($query AS $rows){
            $data[] = $rows->nama_group;
        }

        return $data;
    }
}
