<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Data_komponen_m extends CI_Model
{
    protected $master     = "payroll_komponen_m";
    protected $pendapatan = "payroll_tunj_tdk_tetap_m";
    protected $potongan   = "payroll_pot_tdk_tetap_m";

    function get_datatables($id_karyawan, $id_cabang, $id_departemen)
    {
        $this->_get_datatables_query($id_karyawan, $id_cabang, $id_departemen);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($id_karyawan, $id_cabang, $id_departemen)
    {
        $this->_get_datatables_query($id_karyawan, $id_cabang, $id_departemen);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($id_karyawan, $id_cabang, $id_departemen)
    {
        $this->_get_datatables_query($id_karyawan, $id_cabang, $id_departemen);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($id_karyawan, $id_cabang, $id_departemen)
    {
        if ($id_karyawan != 'all') {
            $this->db->where('md5(dk.id_karyawan)', $id_karyawan);
        } else {
            if ($id_cabang != 'all') {
                $this->db->where('master_cabang.kode', $id_cabang);
            }

            if ($id_departemen != 'all') {
                $this->db->where('master_departemen.kode', $id_departemen);
            }
        }

        $this->db->select('
            dk.id_karyawan,
            dk.nama_lengkap,
            dk.nik,
        ')
            ->from('data_karyawan AS dk')
            ->join('master_cabang', 'master_cabang.id_cabang = dk.id_cabang')
            ->join('master_departemen', 'master_departemen.id_departemen = dk.id_departemen', 'LEFT')
            ->join('master_jabatan', 'master_jabatan.id_jabatan = dk.id_jabatan')
            ->where('dk.id_company', $this->id_company)
            ->where_in('dk.status', ['1', '2', '3', '4'])
            ->where_not_in("master_jabatan.level_user", ["1", "6"]);

        $column_search = array('');
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by("dk.nama_lengkap ASC, dk.nik ASC");
        }
    }

    public function list_komponen_pendapatan($bulan)
    {
        $select = $this->db->select('
            p.id_item,
            p.jenis_komponen,
            p.jenis_master,
            p.nm_tunjangan
        ')
            ->from($this->pendapatan . ' as p')
            ->join($this->master . ' as master', 'master.id_item = p.id_item')
            ->where('master.id_company', $this->id_company)
            ->where('p.jenis_komponen', 'tidak tetap')
            ->where('p.periode', date('Y-m', strtotime('01-' . $bulan)))
            ->group_by('p.id_item')
            ->order_by('master.no_urut ASC')
            ->get()
            ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->jenis_master][] = [
                'id_item'               => $key->id_item,
                'jenis_master'          => $key->jenis_master,
                'nm_tunjangan'          => $key->nm_tunjangan,
            ];
        }
        return json_encode($data);
    }

    public function list_komponen_potongan($bulan)
    {
        $select = $this->db->select('
            p.id_item,
            p.jenis_komponen,
            p.jenis_master,
            p.nm_potongan
        ')
            ->from($this->potongan . ' as p')
            ->join($this->master . ' as master', 'master.id_item = p.id_item')
            ->where('master.id_company', $this->id_company)
            ->where('p.jenis_komponen', 'tidak tetap')
            ->where('p.periode', date('Y-m', strtotime('01-' . $bulan)))
            ->group_by('p.id_item')
            ->order_by('master.no_urut ASC')
            ->get()
            ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->jenis_master][] = [
                'id_item'               => $key->id_item,
                'jenis_master'          => $key->jenis_master,
                'nm_potongan'           => $key->nm_potongan,
            ];
        }
        return json_encode($data);
    }

    public function tambah_pendapatan($bulan, $id_karyawan, $id_cabang, $id_departemen)
    {
        if ($id_karyawan != 'all') {
            $this->db->where('md5(id_karyawan)', $id_karyawan);
        } else {
            if ($id_cabang != 'all') {
                $this->db->like('cabang', $id_cabang, 'after');
            }

            if ($id_departemen != 'all') {
                $this->db->like('departemen', $id_departemen, 'after');
            }
        }

        $select = $this->db->select('
            p.id_karyawan,
            p.periode,
            p.id_item,
            p.nm_tunjangan,
            p.nominal_tunjangan,
            p.cabang,
            p.departemen,
            p.jabatan
        ')
            ->from($this->pendapatan . ' as p')
            ->join($this->master . ' as master', 'master.id_item = p.id_item')
            ->where('master.id_company', $this->id_company)
            ->where('p.jenis_komponen', 'tidak tetap')
            ->where('p.periode', date('Y-m', strtotime('01-' . $bulan)))
            ->order_by('master.no_urut ASC')
            ->get()
            ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->id_karyawan][] = [
                'id_karyawan'       => $key->id_karyawan,
                'id_item'           => $key->id_item,
                'nm_tunjangan'      => $key->nm_tunjangan,
                'nominal_tunjangan' => $key->nominal_tunjangan,
                'cabang'            => $key->cabang,
                'departemen'        => $key->departemen,
                'jabatan'           => $key->jabatan,
            ];
        }
        return json_encode($data);
    }

    public function tambah_potongan($bulan, $id_karyawan, $id_cabang, $id_departemen)
    {
        if ($id_karyawan != 'all') {
            $this->db->where('md5(id_karyawan)', $id_karyawan);
        } else {
            if ($id_cabang != 'all') {
                $this->db->like('cabang', $id_cabang, 'after');
            }

            if ($id_departemen != 'all') {
                $this->db->like('departemen', $id_departemen, 'after');
            }
        }

        $select = $this->db->select('
            p.id_karyawan,
            p.periode,
            p.id_item,
            p.nm_potongan,
            p.nominal_potongan,
            p.cabang,
            p.departemen,
            p.jabatan
        ')
            ->from($this->potongan . ' as p')
            ->join($this->master . ' as master', 'master.id_item = p.id_item')
            ->where('master.id_company', $this->id_company)
            ->where('p.jenis_komponen', 'tidak tetap')
            ->where('p.periode', date('Y-m', strtotime('01-' . $bulan)))
            ->order_by('master.no_urut ASC')
            ->get()
            ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->id_karyawan][] = [
                'id_karyawan'      => $key->id_karyawan,
                'id_item'          => $key->id_item,
                'nm_potongan'      => $key->nm_potongan,
                'nominal_potongan' => $key->nominal_potongan,
                'cabang'           => $key->cabang,
                'departemen'       => $key->departemen,
                'jabatan'          => $key->jabatan,
            ];
        }
        return json_encode($data);
    }

    public function update($data, $master_komponen, $id_item)
    {
        $this->db->trans_start();

        if ($master_komponen == 'pendapatan') {
            $komponen = $this->pendapatan;
        } else {
            $komponen = $this->potongan;
        }

        $this->db->where('md5(concat(id_karyawan,id_item,periode,id_company))', $id_item);
        $this->db->update($komponen, $data);

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            $message = ["message" => '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Data berhasil disimpan</font>'];
            return __response_update(true, $message);
        }
    }
}
