<?php

class Aspek_kepribadian_m extends CI_Model {
    
    var $table = 'kpi_aspek_kepribadian_trx';
    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($id_karyawan = null, $tahun = null, $bulan = null) {
        $this->db->select("id_aspek_kepribadian")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        if($id_karyawan != null) {
            $this->db->where("id_karyawan", $id_karyawan);
            $this->db->where("tahun", $tahun);
            $this->db->where("bulan", $bulan);
        } elseif($this->input->server('REQUEST_METHOD') === 'POST') {
            $this->db->where("id_karyawan", htmlentities($this->input->post('karyawan')));
            $this->db->where("tahun", htmlentities($this->input->post('tahun')));
            $this->db->where("bulan", htmlentities($this->input->post('bulan')));
        } else {
            $this->db->where("id_karyawan", htmlentities($this->input->get('karyawan')));
            $this->db->where("tahun", htmlentities($this->input->get('tahun')));
            $this->db->where("bulan", htmlentities($this->input->get('bulan')));
        }
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($id_karyawan = null, $tahun = null, $bulan = null){
        $this->db->select("id_aspek_kepribadian,
            personal_aspek,
            keterangan,
            bobot,
            poin_1,
            poin_2,
            poin_3,
            poin_4,
            poin_5,
            actual_poin_approval")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        if($id_karyawan != null) {
            $this->db->where("id_karyawan", $id_karyawan);
            $this->db->where("tahun", $tahun);
            $this->db->where("bulan", $bulan);
        } else {
            $this->db->where("id_karyawan", htmlentities($this->input->get('karyawan')));
            $this->db->where("tahun", htmlentities($this->input->get('tahun')));
            $this->db->where("bulan", htmlentities($this->input->get('bulan')));
        }
        $this->db->order_by('no_urut', 'asc');
    }

    public function getMaster($id_jabatan) {
        $this->db->from('kpi_aspek_kepribadian_m');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('id_jabatan', $id_jabatan);
        $this->db->order_by('no_urut', 'asc');
        return $this->db->get();
    }

    public function insertKepribadian($id_jabatan) {
        $actual_arr = $this->input->post('actual');
        $getMaster = $this->getMaster($id_jabatan);
        if($getMaster->num_rows() > 0) {
            $data                 = [];
            $id_aspek_kepribadian = null;
            foreach($getMaster->result() as $key => $row) {

                if(empty($data)) {
                    $id_aspek_kepribadian = generate_id('id_aspek_kepribadian', $this->id_company);
                } else {
                    $id_aspek_kepribadian = generate_id_from_prev('id_aspek_kepribadian', $this->id_company, $id_aspek_kepribadian);
                }

                $data[] = [
                    'id_karyawan'          => htmlentities($this->input->post('karyawan')),
                    'tahun'                => htmlentities($this->input->post('tahun')),
                    'bulan'                => htmlentities($this->input->post('bulan')),
                    'id_aspek_kepribadian' => $id_aspek_kepribadian,
                    'personal_aspek'       => $row->personal_aspek,
                    'keterangan'           => $row->keterangan,
                    'bobot'                => $row->bobot,
                    'id_jabatan'           => $id_jabatan,
                    'poin_1'               => $row->poin_1,
                    'poin_2'               => $row->poin_2,
                    'poin_3'               => $row->poin_3,
                    'poin_4'               => $row->poin_4,
                    'poin_5'               => $row->poin_5,
                    'no_urut'              => $row->no_urut,
                    'actual_poin_approval' => $actual_arr[$key],
                    'id_company'           => $this->id_company,
                    'user_input'           => "$this->nik_karyawan - $this->nm_karyawan"
                ];
            }

            if(count($data) > 0) {
                $this->db->insert_batch('kpi_aspek_kepribadian_trx', $data);
            }
        }
    }

    public function totalSkorBelumDisetujui() {
        $data  = $this->get_datatables();
        $total = 0;
        foreach($data as $row) {
            $total += ($row->bobot/100)*$row->actual_poin_approval;
        }
        return round($total, 2);
    }

    public function validasi() {
        $this->db->where('actual_poin_approval', 0);
        $this->db->where("id_karyawan", htmlentities($this->input->post('karyawan')));
        $this->db->where("tahun", htmlentities($this->input->post('tahun')));
        $this->db->where("bulan", htmlentities($this->input->post('bulan')));
        return $this->db->count_all_results($this->table);
    }

    public function data() {
        $id_arr     = $this->input->post('id');
        $actual_arr = $this->input->post('actual');

        $data = [];
        foreach($id_arr as $index => $id) {
            $data[] = [
                'id_aspek_kepribadian' => $id,
                'actual_poin_approval' => $actual_arr[$index]
            ];
        }
        return $data;
    }

    public function download($id_karyawan, $tahun, $bulan, $id_jabatan) {
        $count = $this->count_all($id_karyawan, $tahun, $bulan);
        if($count == 0) {
            return $this->getMaster($id_jabatan);
        } else {
            $this->_get_datatables_query($id_karyawan, $tahun, $bulan);
            return $this->db->get();
        }
    }

    public function count() {
        $this->db->where("id_karyawan", htmlentities($this->input->post('karyawan')));
        $this->db->where("tahun", htmlentities($this->input->post('tahun')));
        $this->db->where("bulan", htmlentities($this->input->post('bulan')));
        return $this->db->count_all_results($this->table);
    }
    
}