<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Adm_payroll extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('pengaturan/admin/Adm_payroll_m');
    }

    public function index()
    {
        $data['judul']   = $this->lang->line('menu_admin_payroll');
        $data['aktif']   = 'p_admin';
        $this->load->view('pengaturan/admin/adm_payroll/home', $data, false);
    }

    public function list_data(){
        $list = $this->Adm_payroll_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";
            
            // $btn_edit  = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_karyawan) . '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_karyawan) . '" class="btn_delete fa fa-trash" onclick="hapus_form(this)"></i></a>';
            $row[]     = $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Adm_payroll_m->count_all(),
            "recordsFiltered" => $this->Adm_payroll_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Adm_payroll_m->getDataById($id);
		}

		$this->load->view('pengaturan/admin/adm_payroll/form',$data);
    }

    public function save(){
        $id           = $this->input->post('id');

        $data = array( 
            'id_karyawan'    => $this->input->post('id_karyawan'),
            'id_company'    => $this->id_company,
            'user_input'    => $this->nik_karyawan. ' - '. $this->nm_karyawan,
            'tgl_input'     => date("Y-m-d H:i:s")
        );
        
        $this->Adm_payroll_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Adm_payroll_m->delete($id);
    }
}