<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Approver extends MY_Controller {
    public function __construct()
	{
		parent::__construct();
		$this->load->model('kpi/admin/pengaturan/Approver_m');
	}

    public function index()
    {
        $this->load->view('kpi/admin/pengaturan/approver/home');
        // $this->load->view('kpi/admin/pengaturan/approver/js');
    }

    public function list_data()
    {
        $status_atasan = $this->input->get("status_atasan");
        $list = $this->Approver_m->get_datatables($status_atasan);
        
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";
            $row[] = $field->nama_jabatan;
            $row[] = $field->nama_departemen;

            if(!empty($field->nama_atasan)){
                $row[] = $field->nama_atasan . "<br><b>" . $field->nik_atasan . "</b>";
            }else{
                $row[] = "-";
            }

             $row[] = '<a href="javascript:void(0)" class="text-warning" title="EDIT">
                        <i id="' . md5($field->id_karyawan). '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>&nbsp';

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Approver_m->count_all($status_atasan),
            "recordsFiltered" => $this->Approver_m->count_filtered($status_atasan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null)
    {
        if(empty($id)){
            $this->load->view('kpi/admin/pengaturan/approver/form_tambah');
        }else{
            $data['data'] = $this->Approver_m->getDataById($id);
            $this->load->view('kpi/admin/pengaturan/approver/form', $data);
        }
    }

    public function update(){   
        if($this->input->post('id_karyawan') == $this->input->post('id_atasan')){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Karyawan dan approver tidak boleh sama</font>');
            return __response_save(false, $message);
        }

        $action    = $this->input->post('action');
        $id_atasan = $this->input->post('id_atasan');
        // $id_atasan = $id_atasan != "null" ? $id_atasan : "";
        $data = array(
            'id_karyawan' => $this->input->post('id_karyawan'),
            'id_atasan'   => $id_atasan,
            'id_company'  => $this->id_company,
        );

        if($id_atasan == "null"){
            // ACTION DELETE
            $this->db->where("id_company", $this->id_company);
            $this->db->where("id_karyawan", $this->input->post('id_karyawan'));
            $delete = $this->db->delete('kpi_approver_p');
            return __response_update($delete);
        }else{
            if($action == "insert"){
                // ACTION INSERT
                $user_input = array(
                    'tgl_input'  => date("Y-m-d H:i:s"),
                    'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
                );
    
                $insert = $this->db->insert('kpi_approver_p', array_merge($data,$user_input));
                return __response_update($insert);
            }else{
                // ACTION UPDATE
                $user_update = array(
                    'tgl_update'  => date("Y-m-d H:i:s"),
                    'user_update' => $this->nik_karyawan. " - ". $this->nm_karyawan
                );
    
                $this->db->where("id_karyawan", $data['id_karyawan']);
                $update = $this->db->update('kpi_approver_p', array_merge($data,$user_update));
                return __response_update($update);
            }
        }

    }

    public function delete()
    {
        $id = $this->input->post("id_karyawan");
        $this->Approver_m->delete($id);
    }
}