<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" name="id" id="id" value="<?= $id ?>">
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold">Nama Karyawan</label><br>
            <label><?= $data->nik." - ".$data->nama_lengkap ?></label>
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold">Tanggal Pengajuan</label><br>
            <label><?= date_format(date_create($data->tgl_pengajuan),"d-m-Y") ?></label>
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold">Periode</label><br>
            <label><?= date_format(date_create($data->tgl_mulai_izin),"d-m-Y")." s/d ".date_format(date_create($data->tgl_selesai_izin),"d-m-Y") ?></label>
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold">Lama Izin/Cuti/Sakit</label><br>
            <label><?= $data->jml_izin ?> Hari</label>
        </div>
    </div>
    <?php
        if($data->flag == "1"){
    ?>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold">Sisa Cuti Tahunan Karyawan</label><br>
            <label><?= $data->sisa_cuti ?></label>
        </div>
    </div>
    <?php
        }
    ?>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold">Keterangan Izin/Cuti/Sakit</label><br>
            <label><?= $data->ket_izin ?></label>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label class="font-weight-bold">Karyawan lain yg sedang melakukan izin(sudah disetujui)</label>
                <div class="table-responsive" style="width:100%; max-height: 250px; overflow-y: auto;">
                    <table class="table table-striped">
                        <thead>
                            <tr class="bg-tr">
                                <th class="text-center" valign="middle" style="width: 150px">TANGGAL</th>
                                <th class="text-left" valign="middle">NAMA</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                    $start = $data->tgl_mulai_izin;
                                    $end = $data->tgl_selesai_izin;
                                    $format = 'Y-m-d';
                                    $array = array();
                                    $interval = new DateInterval('P1D');
                                    $realEnd = new DateTime($end);
                                    $realEnd->add($interval);
                                    $period = new DatePeriod(new DateTime($start), $interval, $realEnd);
                                    foreach ($period as $date) {
                                        $tanggal_real = $date->format("d-m-Y");
                                        $tanggal = $date->format($format);
                            ?>
                                        <tr>
                                            <td class="text-center"><?=  $tanggal_real ?></td>
                                            <td><?= $this->fungsi->get_izin_kar($tanggal,$id,$level) ?></td>
                                        </tr>
                            <?php
                                    }
                                    ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button class="btn btn-danger btn_tolak ladda-button" id="3" data-style="expand-left">TOLAK</button>
            <button class="btn btn-success btn_setuju ladda-button" id="4" data-style="expand-left">SETUJU</button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        // Basic
        $('.dropify').dropify();

        // Translated
        $('.dropify-fr').dropify({
            messages: {
                default: 'Glissez-déposez un fichier ici ou cliquez',
                replace: 'Glissez-déposez un fichier ou cliquez pour remplacer',
                remove: 'Supprimer',
                error: 'Désolé, le fichier trop volumineux'
            }
        });

        // Used events
        var drEvent = $('#input-file-events').dropify();

        drEvent.on('dropify.beforeClear', function(event, element) {
            return confirm("Do you really want to delete \"" + element.file.name + "\" ?");
        });

        drEvent.on('dropify.afterClear', function(event, element) {
            alert('File deleted');
        });

        drEvent.on('dropify.errors', function(event, element) {
            console.log('Has Errors');
        });

        var drDestroy = $('#input-file-to-destroy').dropify();
        drDestroy = drDestroy.data('dropify')
        $('#toggleDropify').on('click', function(e) {
            e.preventDefault();
            if (drDestroy.isDropified()) {
                drDestroy.destroy();
            } else {
                drDestroy.init();
            }
        })
    });
</script>
