<div id="calendarIO" class="p-5"></div>

<div class="modal fade" id="modal_update_kalender" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-body">
                <input type="hidden" id="id_hari_libur" value="">
                <input type="hidden" id="tanggal" name="tanggal" class="form-control datepicker" value="<?= $tanggal; ?>" readonly="true"><span id="user-availability-status"></span>
                <div class="form-group">
                    <label><b>Keterangan</b> <i class="text-danger">*</i></label>
                    <input type="text" id="keterangan" name="keterangan" class="form-control" value="<?= ((isset($data))?$data->keterangan:'') ?>">
                </div>

            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-6 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-6 text-right">
                        <button type="button" class="btn btn-danger delete_holiday"><i class="fa fa-trash"></i> HAPUS</button>
                        <button type="button" id="btn_update" class="btn btn-warning ladda-button" data-style="expand-left"><i class="fa fa-edit (alias)"></i> PERBARUI</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
	$(document).ready(function () {
            $('#calendarIO').fullCalendar({
                displayEventTime: false,
                firstDay: 1,
                lang:"id",
                dayNamesShort: ['Minggu', 'Senin', 'Selasa', 'Rabu','Kamis', 'Jumat', 'Sabtu'],
                dayNames : ['Minggu', 'Senin', 'Selasa', 'Rabu','Kamis', 'Jumat', 'Sabtu'],
                monthNames : ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli','Agustus', 'September', 'Oktober', 'November', 'Desember'],
                monthNamesShort : ['Jan', 'Feb', 'Mar', 'Apr', 'Mai', 'Jun' , 'Jul', 'Ags', 'Sep', 'Okt', 'Nov', 'Des'],
                code: "id",
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'month,agendaWeek,agendaDay'
                },
                weekLabel: "Mg",
                allDayHtml: "Sehari<br/>penuh",
                eventLimitText: "lebih",
                buttonText: {
                    prev: "",
                    next: "",
                    today: 'Hari Ini',
                    month: 'Bulan',
                    week: 'Minggu',
                    day: 'Hari'
                },
                defaultDate: moment().format('YYYY-MM-DD'),
                navLinks: true,
                editable: true,
                eventLimit: true,
                selectable: true,
                selectHelper: true,
                select: function (start, end) {
                    $('#create_modal input[name=jam_mulai]').val(moment(start).format('YYYY-MM-DD HH:mm'));
                    $('#create_modal input[name=jam_selesai]').val(moment(end).format('YYYY-MM-DD HH:mm'));
                    $('#create_modal .delete_calendar').hide();
                    $('#calendarIO').fullCalendar('unselect');
                },
                eventClick: function (info){
                    detail_holiday(info);
                    editDataHoliday(info);
                    deleteDataHoliday(info);
                },
                dayRender: function(date, cell) {
                    if(!cell.hasClass('fc-other-month')) {
                        cell.css('background-color', '#FFFFFF'); // or whatever
                    }else{
                        cell.css('background-color', '#C8C6C6'); // or whatever
                    }
                },
                events: <?= $data_kelender ?>,
            });
	});
</script>