<script type="text/javascript">
    $(function() {
        $("#periode").datepicker( {
            format: "mm-yyyy",
            viewMode: "months", 
            orientation: 'bottom',
            minViewMode: "months"
        });

        $(document).on('click','#btn_form_template',function(){
            $('#tampil_form').load("<?= route('informasi.gaji.form.templateimport') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Unduh Template Gaji");
                $(".btn_unduh").addClass("btn_unduh btn btn-success");
                $(".btn_unduh").append('<i class="fa fa-download"></i> ');
                $(".btn_unduh").append('UNDUH');
            });
        });

        $(document).on('click', '#btn_import_gaji', function(){
            var loading = Ladda.create(this);
            $('.form_import #message').html("");

            if($("#periode").val() ==""){
				$('.form_import #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Periode belum diiisi</font>");
				$('#periode').focus();
				return false;
			}else if(document.getElementById("file").files.length == "0"){
				$('.form_import #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> File belum diupload</font>");
				$('#file').focus();
				return false;
			}

            loading.start();
            
            var data = new FormData();
            data.append('periode',$("#periode").val());
            data.append('file',$('#file').prop('files')[0]);

            $.ajax({
                type: 'POST',
                url: "<?= route('informasi.gaji.import.excel') ?>",
                data: data,
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(result){
                    loading.stop();
                    $('.form_import #message').show();
                    $('.form_import #message').html(result.message);
                },
                error: function(){
                    loading.stop();
					$('.form_import #message').show();
					$('.form_import #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });

        });

        $(document).on('click','.btn_edit',function(){
            var id = $(this).attr('id');
            window.location.href = "<?= route('informasi.gaji.import.form.edit') ?>"+"/"+id
        });


        $(document).on('click','.btn_form_hapus',function(){
                var id = $(this).attr('id');
                $('#modal_hapus').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $("#modal_hapus .card-body").show();
                $("#modal_hapus .card-footer").show();
                $(".tombol").empty();
                $(".tombol").append('<button class="btn_hapus btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');

                //btn_delete
                $('.btn_hapus').on('click',function(){
                    var loading = Ladda.create(this);
                    loading.start();
                    $.ajax({
                        type: 'POST',
                        url: "<?= route('informasi.gaji.import.delete') ?>",
                        data: 'id='+id,
                        dataType:'JSON',
                        success: function(result){
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html(result.message);
                            loading.stop();
                        },
                        error:function(){
                            loading.stop();
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });
                //btn_delete
        });

        // # SIMPAN SEMUA DATA TEMPORARY
        $(document).on('click','.btn_simpan_semua',function(){
                var id = $(this).attr('id');
                $('#modal_hapus').modal('show');
                $(".title").text("Apakah anda ingin menyimpan semua data ini?");
                $("#modal_hapus .card-body").show();
                $("#modal_hapus .card-footer").show();
                $(".tombol").empty();
                $(".tombol").append('<button class="btn_save_semua btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>');

                //btn_delete
                $('.btn_save_semua').on('click',function(){
                    var loading = Ladda.create(this);
                    loading.start();
                    $.ajax({
                        type: 'POST',
                        url: "<?= route('informasi.gaji.import.saveall') ?>",
                        data: 'id='+id,
                        dataType:'JSON',
                        success: function(result){
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html(result.message);
                            loading.stop();
                        },
                        error:function(){
                            loading.stop();
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });
        });

        $(document).on('click','.btn_hapus_semua',function(){
                $('#modal_hapus').modal('show');
                $(".title").text("Apakah anda ingin menghapus semua data ini?");
                $("#modal_hapus .card-body").show();
                $("#modal_hapus .card-footer").show();
                $(".tombol").empty();
                $(".tombol").append('<button class="btn_delete_semua btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');

                //btn_delete
                $('.btn_delete_semua').on('click',function(){
                    var loading = Ladda.create(this);
                    loading.start();
                    $.ajax({
                        type: 'POST',
                        url: "<?=  route('informasi.gaji.import.deleteall') ?>",
                        dataType:'JSON',
                        success: function(result){
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html(result.message);
                            loading.stop();
                        },
                        error:function(){
                            loading.stop();
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });
                //btn_delete
        });
    });

</script>

<style>
    th, td { 
        white-space: nowrap; 
    }
    div.dataTables_wrapper {
        margin: 0 auto;
    }
</style>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Informasi Gaji</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('informasi.gaji.home') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body form_import">
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <label>PERIODE <span class="text-danger">*</span></label>
                        <?php
                            if($tanggal != "") {
                                $tgl = $tanggal;
                            }else{
                                $tgl = date("m-Y");
                            }
                        ?>
                        <input type="text" class="form-control text-center" value="<?= $tgl; ?>" id="periode" autocomplete="off" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input type="file" name="file" id="file" class="form-control">
                    </div>
                </div>
                <div class="col-md-7 align-self-end">
                    <div class="form-group">
                        <button type="button" id="btn_import_gaji" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-upload"></i> IMPORT GAJI</button>
                        <button type="button" id="btn_form_template" class="btn btn-primary"><i class="fa fa-download"></i> UNDUH TEMPLATE</button>
                        <label id="message"></label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <button class="btn btn-danger btn_hapus_semua" id="hapus_all"><i class="fa fa-trash"></i> HAPUS SEMUA</button>
                    <button class="btn btn-success btn_simpan_semua" id="simpan_all"><i class="fa fa-save"></i> SIMPAN SEMUA</button>
                </div>
                <div class="col-md-4 text-right">
                    <button class="btn btn-danger btn-sm" title="Data tidak lengkap"></button> <span>Data tidak lengkap</span>
                    <button class="btn btn-warning btn-sm" title="Data sudah ada"></button> <span>Data sudah ada</span>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-md-12">
                    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr class="bg-tr">
                                <th class="text-center" rowspan="2">NO</th>
                                <th class="text-center" rowspan="2">PERIODE</th>
                                <th class="text-center" valign="middle" rowspan="2">NAMA KARYAWAN</th>
                                <th class="text-center" rowspan="2">CABANG</th>
                                <th class="text-center" rowspan="2">DEPARTEMEN</th>
                                <th class="text-center" rowspan="2">JABATAN</th>

                                <th class="text-center" rowspan="2">GAJI POKOK</th>
                                <th class="text-center" colspan="8">TUNJANGAN</th>
                                <th class="text-center" rowspan="2">TOTAL TUNJANGAN</th>
                                <th class="text-center" rowspan="2">TOTAL PENERIMAAN</th>
                                <th class="text-center" colspan="3">TUNJANGAN YANG DIBIAYAI PERUSAHAAN</th>
                                <th class="text-center" rowspan="2">TOTAL <br> TUNJANGAN YANG <br> DIBIAYAI PERUSAHAAN</th>
                                <th class="text-center" colspan="7">POTONGAN</th>
                                <th class="text-center" rowspan="2">TOTAL POTONGAN</th>
                                <th class="text-center" rowspan="2">GAJI DITERIMA</th>
                                <th class="text-center pl-2 pr-2" rowspan="2">AKSI</th>
                                <th rowspan="2">FLAG</th>
                            </tr>
                            <tr class="bg-color-grayDark">
                                <th class="fg-color-white" style="text-align:center;">JABATAN</th>
                                <th class="fg-color-white" style="text-align:center;">TRANSPORT</th>
                                <th class="fg-color-white" style="text-align:center;">MAKAN</th>
                                <th class="fg-color-white" style="text-align:center;">TUNJANGAN ISTRI</th>
                                <th class="fg-color-white" style="text-align:center;">TUNJANGAN ANAK</th>
                                <th class="fg-color-white" style="text-align:center;">LEMBUR</th>
                                <th class="fg-color-white" style="text-align:center;">KOMISI</th>
                                <th class="fg-color-white" style="text-align:center;">LAIN-LAIN</th>

                                <th class="fg-color-white" style="text-align:center;">BPJS KETENAGAKERJAAN</th>
                                <th class="fg-color-white" style="text-align:center;">BPJS KESEHATAN</th>
                                <th class="fg-color-white" style="text-align:center;">LAIN-LAIN</th>

                                <th class="fg-color-white" style="text-align:center;">ABSENSI</th>
                                <th class="fg-color-white" style="text-align:center;">KETERLAMBATAN</th>
                                <th class="fg-color-white" style="text-align:center;">KOPERASI</th>
                                <th class="fg-color-white" style="text-align:center;">ASURANSI KESEHATAN</th>
                                <th class="fg-color-white" style="text-align:center;">BPJS KETENAGAKERJAAN</th>
                                <th class="fg-color-white" style="text-align:center;">BPJS KESEHATAN</th>
                                <th class="fg-color-white" style="text-align:center;">LAIN-LAIN</th> 
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_hapus" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right tombol">
                        <!-- <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left"></button> -->
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                'searching'     : true,
                'paging'        : true,
                'lengthChange'  : true,
                'ordering'      : true,
                'info'          : true,
                'scrollX'       :true,
                'scrollCollapse': true,
                'fixedColumns'  :{
                    'leftColumns': 3,
                    'rightColumns': 3,
                },
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= route('informasi.gaji.import.listdata') ?>",
                                    "type": "POST",
                                    "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false},
                                        { "aTargets": [-2], "bSortable": false },
                                        {"targets": [ -1], "visible": false, "searchable": false}
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            if(aData[31] == "2"){
                                $('td', nRow).css('background-color', '#ff425c');
                                $('td', nRow).css('color', 'White');
                            }

                            if(aData[31] == "3"){
                                $('td', nRow).css('background-color', '#ffbc34');
                                $('td', nRow).css('color', 'White');
                            }

                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(-1)', nRow).css({'text-align':'center','width':'100px !important'});

                            for(i=6;i<=29;i++){
                                $('td:eq('+i+')', nRow).css({'text-align':'right'});
                            }
                    },
        });
    });
</script>