<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pengaturan_perusahaan extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Db_model', 'db_model');
        $this->load->model('Dashboard_m', 'dash');
        $this->load->library('Uploadfile');
	}

	public function index()
	{
		$data['judul'] = 'Profil Perusahaan';
		$data['aktif'] = 'perusahaan';

		$data['profil'] = $this->db_model->get("master_company","*",["id_company" => $this->session->userdata('id_company')])->row();
		$data['layanan'] = $this->db_model->get("r_plan","*",["id_company" => $this->session->userdata('id_company')],"","10","0","","")->result();
		$data['tagihan'] = $this->db_model->get("tb_transaksi","tb_transaksi.*, tb_invoice.tgl_invoice, tb_invoice.tgl_jatuh_tempo, tb_invoice.id_order, tb_invoice.id_invoice",["id_company" => $this->session->userdata('id_company')],"","10","0","",['table' => 'tb_invoice', 'on' => 'tb_transaksi.id_transaksi = tb_invoice.id_order', 'pos' => 'left'])->result();

        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pengaturan/pengaturan_perusahaan/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function form($id_company=null){
        if($id_company==null){
            $this->load->view('pengaturan/pengaturan_perusahaan/form');
        }else{
            $data['data'] = $this->db->select("*")->from("master_company")->where("md5(id_company)",$id_company)->get()->row();
            $this->load->view('pengaturan/pengaturan_perusahaan/form',$data);
        }
        
    }

	public function save_profil(){
        $logo_lama = $this->input->post('file_lama');

        $logo_baru = $_FILES['file'];
        if($logo_baru['name'] == ""){
            $file = $logo_lama;
        }else{

            $fileUpload['fname']    = 'file';
            $fileUpload['location'] = 'logo-perusahaan';
            $fileUpload['allowed']  = 'jpg|png|jpeg';
            $fileUpload['compress_image']  = true;
            $fileUpload['filename']  = $this->session->userdata("id_company");

            $upload = $this->uploadfile->doUpload($fileUpload);
            if($upload["success"] == true){
                $this->fungsi->delete_fileupload($logo_lama);
                $file = $upload['url'];
            }else{
                $message = ["message"=>$upload["message"]];
                return __response_save(false,["params"=>$message]);
            }
        }

        $data = array('nama'        =>$this->input->post('nama'),
                    'deskripsi'     =>$this->input->post('deskripsi'),
                    'alamat'        =>$this->input->post('alamat'),
                    'url_logo'      =>$file,);            

        $logo = $this->db->select("url_logo")
                        ->from("master_company")
                        ->where("id_company",$this->session->userdata("id_company"))
                        ->get()
                        ->row('url_logo');

        $this->db->where(array('id_company'=>$this->session->userdata("id_company")));
        $update = $this->db->update('master_company',$data);
        if($update){
            if(empty($logo_lama)){
                $this->fungsi->delete_fileupload($logo);
            }
            return  __response_update(true);
        }else{
            return  __response_update(false);
        }
    }

    function invoice_excel($id) {
        $today = date("Y-m-d");
        $dt = strtotime(date("Y-m-d"));
        $next_month = date("Y-m-d", strtotime("+1 month", $dt));
        $id_company = $_SESSION['id_company'];

        $data['data'] = $this->db_model->get("tb_transaksi","tb_transaksi.*, tb_invoice.tgl_invoice, tb_invoice.tgl_jatuh_tempo, tb_invoice.id_order, tb_invoice.id_invoice, master_company.nama as nama_company, master_company.alamat, master_customer.nama as nama_customer, master
            .telp",["md5(id_transaksi)" => $id],"","","","",
            [
                ['table' => 'tb_invoice', 'on' => 'tb_transaksi.id_transaksi = tb_invoice.id_order', 'pos' => 'left'],
                ['table' => 'master_company', 'on' => 'tb_transaksi.id_company = master_company.id_company', 'pos' => 'left'],
                ['table' => 'master_customer', 'on' => 'master_customer.id_customer = master_company.id_customer', 'pos' => 'left']
            ])->row();
        
        $filename = "Invoice_".$id_company.".xls";
        @header("Cache-Control: "); // leave blank to avoid IE errors
        @header("Pragma: "); // leave blank to avoid IE errors
        @header("Content-type: application/msexcel");
        @header("Content-Disposition: attachment; filename=\"$filename\"");
        $this->load->view('peraturan/peraturan_perusahaan/invoice_pdf', $data, false);
        
    }


    public function invoice_pdf($id){
        $id_company = $_SESSION['id_company'];

        $data['data'] = $this->db_model->get("tb_transaksi","tb_transaksi.*, tb_invoice.tgl_invoice, tb_invoice.tgl_jatuh_tempo, tb_invoice.id_order, tb_invoice.id_invoice, master_company.nama as nama_company, master_company.alamat, master_customer.nama as nama_customer, master_customer
            .telp, tb_paket.nama as nama_paket, tb_paket.tarif as harga_satuan, master_plan.tgl_aktif as tanggal_aktif, master_plan.tgl_berakhir",["md5(id_transaksi)" => $id],"","","","",
            [
                ['table' => 'tb_invoice', 'on' => 'tb_transaksi.id_transaksi = tb_invoice.id_order', 'pos' => 'left'],
                ['table' => 'tb_paket', 'on' => 'tb_transaksi.id_tb_paket = tb_paket.id_tb_paket', 'pos' => 'left'],
                ['table' => 'master_company', 'on' => 'tb_transaksi.id_company = master_company.id_company', 'pos' => 'left'],
                ['table' => 'master_plan', 'on' => 'tb_transaksi.id_company = master_plan.id_company', 'pos' => 'left'],
                ['table' => 'master_customer', 'on' => 'master_customer.id_customer = master_company.id_customer', 'pos' => 'left']
            ])->row();
        
        $this->logger->create_log('export_invoice', 'export', $this->db->last_query());
        $html = $this->load->view('pengaturan/pengaturan_perusahaan/invoice_pdf', $data, true);
        $html = preg_replace('/>\s+</', '><', $html); //bug dompdf
        $this->load->add_package_path(APPPATH . 'third_party/dompdf/');
        require_once(APPPATH . "third_party/dompdf/dompdf_config.inc.php");
        $name = "Invoice_".$id_company.".pdf";
        $dompdf = new DOMPDF();
        $dompdf->set_paper('A4', 'potrait');
        $dompdf->load_html($html);
        $dompdf->render();
        $dompdf->stream($name, array("Attachment" => false));
        echo $html;
    }
}
