<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Data_reimburse extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Data_reimburse_m');
        // $this->load->model('Db_model', 'db_model');
    }

	public function index(){
		$data['judul'] = 'Pengajuan Reimburse';
		$data['aktif'] = 'reimburse';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('data_reimburse/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
        $tipe = $this->input->post("tipe");
		$list = $this->Data_reimburse_m->get_datatables($tipe);
		$query = $this->db->last_query();
		$data = array();
		$no = $_POST['start'];

		foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $this->fungsi->format_date_strip($field->tgl_pengajuan);
            $row[] = $field->no_pengajuan;
            $row[] = $field->nama_karyawan."<br><b>".$field->nik."</b>";
            $row[] = $field->nama_cabang."<br><b>".$field->kode_cabang."</b>";
            $row[] = $field->nama_departemen."<br><b>".$field->kode_departemen."</b>";
            $row[] = number_format($field->total_reimburse,0,",",".");
            $row[] = $field->keterangan;
            $row[] = "<a href='".route("reimburse.detail")."/".MD5($field->id)."'>
                        <button class='btn btn-info'>DETAIL</button>
                    </a>";
            $data[] = $row;
        }

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Data_reimburse_m->count_all($tipe),
							"recordsFiltered" => $this->Data_reimburse_m->count_filtered($tipe),
							"data"            => $data,
							"query"			  => $query);

            $output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function detail($id_pengajuan=null){
        $data['judul']          = 'Detail Pengajuan Reimburse';
        $data['aktif']          = 'reimburse';
        $data['data_pengajuan'] = $this->Data_reimburse_m->getNoPengajuan($id_pengajuan);
        $data['list_pengajuan'] = $this->Data_reimburse_m->list_pengajuan($id_pengajuan);
        $data['list_akun'] = $this->Data_reimburse_m->list_akun();
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('data_reimburse/detail_pengajuan', $data, true);
        $this->load->view('main_template', $data, false);
    }

    private function __approve_to_service($post_data){

        // echo $post_data;
        // die();
		$base = $this->config->item('url_api');
        $request_headers = array(
            "id-company:".$this->id_company,
            "id-departemen:".$this->id_departemen,
            "id-cabang:".$this->id_cabang,
            "id-karyawan:".$this->id_karyawan,
            "level-user:".$this->level_user,
            "api-key:absenku123**"
        );
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL,$base."reimbursement/update-status");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,$post_data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);

        // In real life you should use something like:
        // curl_setopt($ch, CURLOPT_POSTFIELDS,
        //          http_build_query(array('postvar1' => 'value1')));

        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $server_output = curl_exec($ch);

        curl_close ($ch);

        // echo '<pre>'.print_r($server_output, true).'</pre>';
        //     exit;


        if(!empty($server_output)){
            $json = json_decode($server_output);

            $data['status'] = $json->success;
            $data['message'] = $json->message;
        }else{
            $data['status'] = false;
            $data['message'] = 'Request tidak diketahui';
        }

		return $data;
	}


    public function save(){
        $jumlah_data = $this->input->post("jumlah_data");
        $id_pengajuan_reimburse = $this->input->post("id_pengajuan_reimburse");

        $post_data = "id_pengajuan=".$id_pengajuan_reimburse.
                    "&jumlah_item=".$jumlah_data."";

        $no=0;
        for ($i = 1; $i <= $jumlah_data; $i++) {
            $id_reimburse       = $this->input->post("id_reimburse_$i");
            $status_reimburse   = $this->input->post("status_reimburse_$i");
            $ket_revisi         = $this->input->post("ket_revisi_$i");
            $ket_ditolak        = $this->input->post("ket_ditolak_$i");
            $nominal_setuju     = str_replace('.','',$this->input->post("nominal_setuju_$i"));
            $id_akun            = $this->input->post("id_akun_$i");

            $keterangan         = ($status_reimburse=="3")?$ket_ditolak:$ket_revisi;


            // 0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui 6=proses
            if(!empty($status_reimburse)) {
                    $post_data .="&id_item".$no."=".$id_reimburse.
                                    "&status".$no."=".$status_reimburse.
                                    "&nominal".$no."=".$nominal_setuju.
                                    "&keterangan".$no."=".$keterangan.
                                    "&kode_akun".$no."=".$id_akun."";
                    // echo $no."<br>";
                    $no++;

            }else{
                return __response_update_reimburse(false,5);
            }
        }

        // echo $post_data;
        // die();
        $res = $this->__approve_to_service($post_data);



        if($res['status'] === true) {
			$color = '#009900';
			$icon = 'fa-check-square';
            $status = true;
		}else{
            $status = false;
			$color = '#eb3a28';
			$icon = 'fa-close';
		}

		$json['message'] = '<font color="'.$color.'"><i class="fa '.$icon.'">&nbsp;</i> '.$res['message'].'</font>';
		$json['success'] = $status;

        // echo "status = ".$json['success']."<br>";
        // echo "message = ".$json['message']."<br>";
        // die();

		$response = __response($this->MY_response, $json);
		echo json_encode($response);
    }
}
