

<div class="row">
    <div class="col-md-12">
        <div id="map_canvas2" style="width:100%; height:580px;"></div>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-12">
        <table id="listrekap" class="table table-striped" style="width:100%">
            <thead>
                <tr class="bg-tr">
                    <th class="text-center">NO</th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('nama'); ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('cabang'); ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('departemen'); ?></th>
                    <th class="text-center text-uppercase"><?= $this->lang->line('jumlah_aktivitas'); ?></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">

    var map;
    var lat_longs_map = new Array();
    var markers = []; // Create a marker array to hold your markers
    var beaches = [];
    var mapCentre;

    var tgl_mulai      = '<?= $tgl_mulai ?>';
    var tgl_selesai    = '<?= $tgl_selesai ?>';
    var id_karyawan    = '<?= $id_karyawan ?>';
    var id_cabang      = '<?= $id_cabang ?>';
    var id_departemen  = '<?= $id_departemen ?>';


    var map;
    var lat_longs_map = new Array();
    var markers = []; // Create a marker array to hold your markers
    var beaches = [];
    $.get("<?= route("laporan.aktivitas.data.maps.lokasi") ?>"+"/"+tgl_mulai+"/"+tgl_selesai+"/"+id_karyawan+"/"+id_cabang+"/"+id_departemen, function(data){
        $.each(data, function(index, element) {
            var arr = [];
            arr.push(element.lat);
            arr.push(element.long);
            arr.push(element.title);
            arr.push(element.index);
            beaches.push(arr);
        });

        setMarkers(beaches);
        fitMapToBounds_map();
    },"json");

    var mapCentre;

    function setMarkers(locations) {
        for (var i = 0; i < locations.length; i++) {
            var beach = locations[i];
            var myLatLng = new google.maps.LatLng(beach[0], beach[1]);
            var marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                animation: google.maps.Animation.DROP,
                title: beach[2],
                zIndex: beach[3]
            });

            // Push marker to markers array
            markers.push(marker);

            // Push marker to lat_longs_map array
            lat_longs_map.push(marker.getPosition());

        }
    }

    function initialize() {
        var varcenter = new google.maps.LatLng(-0.4183772,117.4237542);
        var varZoom = 5.4;
        var mapOptions = {
            zoom: varZoom,
            center: varcenter,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        }
        map = new google.maps.Map(document.getElementById('map_canvas2'), mapOptions);

        setMarkers(beaches);
        fitMapToBounds_map();
    }

    function fitMapToBounds_map() {
        var bounds = new google.maps.LatLngBounds();

        if (lat_longs_map.length > 0) {
            for (var i=0; i<lat_longs_map.length; i++) {
                bounds.extend(lat_longs_map[i]);
            }
            map.fitBounds(bounds);
            // map.setZoom(18)
        }
    }
    initialize();


    $(function() {
        list_data = $('#listrekap').DataTable({
                        'searching'     : false,
                        'paging'        : true,
                        'lengthChange'  : true,
                        'ordering'      : true,
                        'info'          : true,
                        'scrollX'       :true,
                        'scrollCollapse': true,
                        'language'    :{
                                            <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                                                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                                                'searchPlaceholder': 'Keterangan'
                                            <?php else : ?> 'searchPlaceholder': 'Description'
                                            <?php endif; ?>
                                        },
                        "processing"  : true,
                        "serverSide"  : true,
                        "order"       : [],

                        "ajax"        : {
                                            "url": "<?= route('laporan.aktivitas.listrekap') ?>",
                                            "type": "GET", 
                                            "data": {
                                                "tgl_mulai"     : "<?= $tgl_mulai ?>",
                                                "tgl_selesai"   : "<?= $tgl_selesai ?>",
                                                "id_karyawan"   : "<?= $id_karyawan ?>",
                                                "id_cabang"     : "<?= $id_cabang ?>",
                                                "id_departemen" : "<?= $id_departemen ?>"
                                            },
                                            "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                        },

                        "aoColumnDefs": [
                                            { "aTargets": [0], "bSortable": false},
                                            { "aTargets": [-1], "bSortable": false }
                                        ],
                        "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(2)', nRow).css({'text-align':'left','width':'350px'});
                            $('td:eq(3)', nRow).css({'text-align':'left','width':'350px'});
                            $('td:eq(4)', nRow).css({'text-align':'center','width':'150px'});
                        }

                });
    })
</script>

