<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Kota_m extends CI_Model
{
    function get_datatables($tahun="0000", $bulan="00", $id_group_m="all", $kota="all"){
        $this->_get_datatables_query($tahun, $bulan, $id_group_m, $kota);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($tahun="0000", $bulan="00", $id_group_m="all", $kota="all"){
        $this->_get_datatables_query($tahun, $bulan, $id_group_m, $kota);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all($tahun="0000", $bulan="00", $id_group_m="all", $kota="all"){
        $this->_get_datatables_query($tahun, $bulan, $id_group_m, $kota);
        return $this->db->count_all_results();
    }
    
    private function _get_datatables_query($tahun="0000", $bulan="00", $id_group_m="all", $kota="all"){
        $this->db->select('
            sptx.kota AS nama_kota,
            sptx.provinsi AS nama_provinsi,
            COUNT(sptx.jumlah_layanan) AS jumlah,
            SUM(sptx.nominal_layanan) AS nominal
        ');
        $this->db->from('sales_pipeline_trx AS sptx');
        $this->db->join('master_kota AS kota', 'kota.nama = sptx.kota');
        $this->db->where('sptx.id_company', $this->id_company);
        $this->db->where('sptx.tahun', $tahun);
        $this->db->where('sptx.jenis_tahapan', "wont");
        $this->db->group_by('sptx.kota');

        if($bulan != "all"){
            $this->db->where('sptx.bulan', sprintf('%02d', $bulan));
        }

        if($kota != "all"){
            $this->db->where('kota.id_kota', $kota);
        }

        if($id_group_m != "all"){
            $this->db->where('sptx.id_group_m', $id_group_m);
        }

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('sptx.id_group_m', explode(',', $this->sales_admin_group));
            }
        }
        
        // COLUMN ORDER
        $column_order = array('', 'sptx.nama', 'COUNT(sptx.jumlah_layanan)', 'SUM(sptx.nominal_layanan)');
        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by("COUNT(sptx.jumlah_layanan) DESC, kota.id_kota ASC");
        }
    }

    public function get_total_jumlah_dan_nominal($tahun="0000", $bulan="00", $id_group_m="all", $kota="all"){
        $this->db->select('
            COUNT(sptx.jumlah_layanan) AS jumlah,
            SUM(sptx.nominal_layanan) AS nominal
        ');
        $this->db->from('sales_pipeline_trx AS sptx');
        $this->db->where('sptx.id_company', $this->id_company);
        $this->db->where('sptx.tahun', $tahun);
        $this->db->where('sptx.jenis_tahapan', "wont");
        $this->db->group_by('sptx.id_company');

        if($bulan != "all"){
            $this->db->where('sptx.bulan', sprintf('%02d', $bulan));
        }

        if($id_group_m != "all"){
            $this->db->where('sptx.id_group_m', $id_group_m);
        }

        if($kota != "all"){
            $this->db->join('master_kota AS kota', 'kota.nama = sptx.kota');
            $this->db->where('kota.id_kota', $kota);
        }

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('sptx.id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        return $this->db->get()->row();
    }
}